/*
 * Decompiled with CFR 0.152.
 */
package baguchi.enchantwithmob.mobenchant;

import baguchi.enchantwithmob.EnchantConfig;
import baguchi.enchantwithmob.api.IEnchantCap;
import baguchi.enchantwithmob.capability.MobEnchantCapability;
import baguchi.enchantwithmob.mobenchant.MobEnchant;
import baguchi.enchantwithmob.registry.MobEnchants;
import baguchi.enchantwithmob.utils.MobEnchantUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

@EventBusSubscriber(modid="enchantwithmob")
public class HugeMobEnchant
extends MobEnchant {
    public HugeMobEnchant(MobEnchant.Properties properties) {
        super(properties);
    }

    @Override
    public int getMinEnchantability(int enchantmentLevel) {
        return 20 + (enchantmentLevel - 1) * 10;
    }

    @Override
    public int getMaxEnchantability(int enchantmentLevel) {
        return this.getMinEnchantability(enchantmentLevel) + 20;
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingIncomingDamageEvent event) {
        IEnchantCap cap;
        LivingEntity attacker;
        LivingEntity livingEntity = event.getEntity();
        if (event.getSource().getEntity() instanceof LivingEntity && (attacker = (LivingEntity)event.getSource().getEntity()) instanceof IEnchantCap && (cap = (IEnchantCap)attacker).getEnchantCap().hasEnchant() && event.getAmount() > 0.0f) {
            event.setAmount(HugeMobEnchant.getDamageIncrease(event.getAmount(), cap.getEnchantCap()));
        }
    }

    public static float getDamageIncrease(float damage, MobEnchantCapability cap) {
        int level = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getMobEnchants(), (ResourceKey<MobEnchant>)MobEnchants.HUGE.getKey());
        if (level > 0) {
            damage *= 1.0f + (float)level * 0.15f;
        }
        return damage;
    }

    @Override
    public boolean isTresureEnchant() {
        return true;
    }

    @Override
    public boolean isCompatibleMob(LivingEntity livingEntity) {
        return super.isCompatibleMob(livingEntity) || (Boolean)EnchantConfig.COMMON.bigYourSelf.get() != false;
    }
}

