/*
 * Decompiled with CFR 0.152.
 */
package baguchi.enchantwithmob.mobenchant;

import baguchi.enchantwithmob.EnchantConfig;
import baguchi.enchantwithmob.api.IEnchantCap;
import baguchi.enchantwithmob.mobenchant.MobEnchant;
import baguchi.enchantwithmob.registry.MobEnchants;
import baguchi.enchantwithmob.utils.MobEnchantUtils;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;

@EventBusSubscriber(modid="enchantwithmob")
public class PoisonCloudMobEnchant
extends MobEnchant {
    public PoisonCloudMobEnchant(MobEnchant.Properties properties) {
        super(properties);
    }

    @Override
    public int getMinEnchantability(int enchantmentLevel) {
        return 20;
    }

    @Override
    public int getMaxEnchantability(int enchantmentLevel) {
        return 50;
    }

    @Override
    public void tick(LivingEntity entity, int level) {
        super.tick(entity, level);
    }

    @Override
    public boolean isCompatibleMob(LivingEntity livingEntity) {
        return ((List)EnchantConfig.COMMON.WHITELIST_SHOOT_ENTITY.get()).contains(BuiltInRegistries.ENTITY_TYPE.getKey((Object)livingEntity.getType()).toString()) && !(livingEntity instanceof Witch) || super.isCompatibleMob(livingEntity);
    }

    @Override
    protected boolean canApplyTogether(MobEnchant ench) {
        return ench != MobEnchants.POISON.get() && super.canApplyTogether(ench);
    }

    @Override
    public boolean isTresureEnchant() {
        return true;
    }

    @SubscribeEvent
    public static void onImpact(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (!PoisonCloudMobEnchant.shooterIsLiving(projectile) || !((List)EnchantConfig.COMMON.ALLOW_POISON_CLOUD_PROJECTILE.get()).contains(BuiltInRegistries.ENTITY_TYPE.getKey((Object)projectile.getType()).toString())) {
            return;
        }
        LivingEntity owner = (LivingEntity)projectile.getOwner();
        if (owner instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)owner;
            int i = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getEnchantCap().getMobEnchants(), (ResourceKey<MobEnchant>)MobEnchants.POISON_CLOUD.getKey());
            if (cap.getEnchantCap().hasEnchant() && MobEnchantUtils.findMobEnchantFromHandler(cap.getEnchantCap().getMobEnchants(), (ResourceKey<MobEnchant>)MobEnchants.POISON_CLOUD.getKey()) && (!(projectile instanceof AbstractArrow) || !projectile.onGround())) {
                AreaEffectCloud areaeffectcloud = new AreaEffectCloud(owner.level(), event.getRayTraceResult().getLocation().x, event.getRayTraceResult().getLocation().y, event.getRayTraceResult().getLocation().z);
                areaeffectcloud.setRadius(0.6f);
                areaeffectcloud.setRadiusOnUse(-0.01f);
                areaeffectcloud.setWaitTime(10);
                areaeffectcloud.setDuration(80);
                areaeffectcloud.setOwner(owner);
                areaeffectcloud.setRadiusPerTick(-0.001f);
                areaeffectcloud.addEffect(new MobEffectInstance(MobEffects.POISON, 80, i - 1));
                owner.level().addFreshEntity((Entity)areaeffectcloud);
            }
        }
    }

    public static boolean shooterIsLiving(Projectile projectile) {
        return projectile.getOwner() != null && projectile.getOwner() instanceof LivingEntity;
    }
}

