/*
 * Decompiled with CFR 0.152.
 */
package baguchi.enchantwithmob.mobenchant;

import baguchi.enchantwithmob.EnchantConfig;
import baguchi.enchantwithmob.mobenchant.MobEnchant;
import baguchi.enchantwithmob.registry.MobEnchants;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.monster.CaveSpider;

public class PoisonMobEnchant
extends MobEnchant {
    public PoisonMobEnchant(MobEnchant.Properties properties) {
        super(properties);
    }

    @Override
    public int getMinEnchantability(int enchantmentLevel) {
        return 5 + (enchantmentLevel - 1) * 10;
    }

    @Override
    public int getMaxEnchantability(int enchantmentLevel) {
        return this.getMinEnchantability(enchantmentLevel) + 30;
    }

    @Override
    public void tick(LivingEntity entity, int level) {
        super.tick(entity, level);
        if (entity.level().isClientSide() && !((Boolean)EnchantConfig.CLIENT.disablePoisonParticle.get()).booleanValue()) {
            entity.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.4f, (float)0.8f, (float)0.4f), entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean isCompatibleMob(LivingEntity livingEntity) {
        return !(livingEntity instanceof Bee) && !(livingEntity instanceof CaveSpider);
    }

    @Override
    protected boolean canApplyTogether(MobEnchant ench) {
        return ench != MobEnchants.POISON_CLOUD.get() && super.canApplyTogether(ench);
    }
}

