/*
 * Decompiled with CFR 0.152.
 */
package baguchi.enchantwithmob.mobenchant;

import baguchi.enchantwithmob.api.IEnchantCap;
import baguchi.enchantwithmob.message.SoulParticleMessage;
import baguchi.enchantwithmob.mobenchant.MobEnchant;
import baguchi.enchantwithmob.registry.MobEnchants;
import baguchi.enchantwithmob.utils.MobEnchantUtils;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="enchantwithmob")
public class SoulStealMobEnchant
extends MobEnchant {
    public SoulStealMobEnchant(MobEnchant.Properties properties) {
        super(properties);
    }

    @Override
    public int getMinEnchantability(int enchantmentLevel) {
        return 10 + (enchantmentLevel - 1) * 10;
    }

    @Override
    public int getMaxEnchantability(int enchantmentLevel) {
        return this.getMinEnchantability(enchantmentLevel) + 30;
    }

    @SubscribeEvent
    public static void onLivingDeathAndStealEvent(LivingDeathEvent event) {
        LivingEntity attacker;
        LivingEntity entity = event.getEntity();
        DamageSource damageSource = event.getSource();
        if (damageSource != null && damageSource.getDirectEntity() instanceof LivingEntity && (attacker = (LivingEntity)damageSource.getDirectEntity()) instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)attacker;
            int enchantLevel = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getEnchantCap().getMobEnchants(), (ResourceKey<MobEnchant>)MobEnchants.SOUL_STEAL.getKey());
            if (cap.getEnchantCap().hasEnchant() && enchantLevel > 0) {
                attacker.heal(Mth.clamp((float)enchantLevel, (float)0.0f, (float)entity.getMaxHealth()));
                if (!entity.level().isClientSide()) {
                    SoulParticleMessage message = new SoulParticleMessage((Entity)entity);
                    PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    @Override
    public boolean isTresureEnchant() {
        return true;
    }

    @Override
    public boolean isDiscoverable() {
        return false;
    }
}

