/*
 * Decompiled with CFR 0.152.
 */
package baguchi.enchantwithmob.utils;

import baguchi.enchantwithmob.EnchantConfig;
import baguchi.enchantwithmob.api.IEnchantCap;
import baguchi.enchantwithmob.capability.MobEnchantHandler;
import baguchi.enchantwithmob.item.mobenchant.ItemMobEnchantments;
import baguchi.enchantwithmob.mobenchant.MobEnchant;
import baguchi.enchantwithmob.registry.MobEnchants;
import baguchi.enchantwithmob.registry.ModDataCompnents;
import baguchi.enchantwithmob.registry.ModTags;
import baguchi.enchantwithmob.utils.MobEnchantmentData;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.Nullable;

public class MobEnchantUtils {
    public static final String TAG_MOBENCHANT = "MobEnchant";
    public static final String TAG_ENCHANT_LEVEL = "EnchantLevel";
    public static final String TAG_STORED_MOBENCHANTS = "StoredMobEnchants";

    public static void executeIfPresent(Entity entity, ResourceKey<MobEnchant> mobEnchantment, Runnable runnable) {
        IEnchantCap cap;
        if (entity != null && entity instanceof IEnchantCap && MobEnchantUtils.findMobEnchantFromHandler((cap = (IEnchantCap)entity).getEnchantCap().getMobEnchants(), mobEnchantment)) {
            runnable.run();
        }
    }

    public static void executeIfPresent(IEnchantCap cap, ResourceKey<MobEnchant> mobEnchantment, Runnable runnable) {
        if (MobEnchantUtils.findMobEnchantFromHandler(cap.getEnchantCap().getMobEnchants(), mobEnchantment)) {
            runnable.run();
        }
    }

    public static void executeIfPresent(Entity entity, Runnable runnable) {
        IEnchantCap cap;
        if (entity != null && entity instanceof IEnchantCap && (cap = (IEnchantCap)entity).getEnchantCap().hasEnchant()) {
            runnable.run();
        }
    }

    public static Optional<Holder.Reference<MobEnchant>> getEnchantFromNBT(@Nullable CompoundTag tag, RegistryAccess registryAccess) {
        if (tag != null && registryAccess.lookupOrThrow(MobEnchants.MOB_ENCHANT_REGISTRY).containsKey(ResourceLocation.tryParse((String)tag.getStringOr(TAG_MOBENCHANT, "")))) {
            return registryAccess.lookupOrThrow(MobEnchants.MOB_ENCHANT_REGISTRY).get(ResourceLocation.tryParse((String)tag.getStringOr(TAG_MOBENCHANT, "")));
        }
        return Optional.empty();
    }

    public static int getEnchantLevelFromNBT(@Nullable CompoundTag tag) {
        if (tag != null) {
            return tag.getIntOr(TAG_ENCHANT_LEVEL, 0);
        }
        return 0;
    }

    public static boolean hasMobEnchant(ItemStack stack) {
        @Nullable ItemMobEnchantments itemMobEnchantments = (ItemMobEnchantments)stack.get(ModDataCompnents.MOB_ENCHANTMENTS);
        return itemMobEnchantments != null;
    }

    public static ListTag getEnchantmentListForNBT(CompoundTag compoundnbt) {
        return compoundnbt != null ? compoundnbt.getListOrEmpty(TAG_STORED_MOBENCHANTS) : new ListTag();
    }

    public static ItemMobEnchantments getEnchantmentsForCrafting(ItemStack stack) {
        return (ItemMobEnchantments)stack.getOrDefault((DataComponentType)ModDataCompnents.MOB_ENCHANTMENTS.get(), (Object)ItemMobEnchantments.EMPTY);
    }

    public static void setEnchantments(ItemStack stack, ItemMobEnchantments p_332148_) {
        stack.set((DataComponentType)ModDataCompnents.MOB_ENCHANTMENTS.get(), (Object)p_332148_);
    }

    public static boolean canStoreEnchantments(ItemStack p_330666_) {
        return p_330666_.has((DataComponentType)ModDataCompnents.MOB_ENCHANTMENTS.get());
    }

    public static void enchant(Holder<MobEnchant> p_41664_, ItemStack stack, int p_41665_) {
        MobEnchantUtils.updateEnchantments(stack, p_330091_ -> p_330091_.upgrade((MobEnchant)p_41664_.value(), p_41665_));
    }

    public static ItemMobEnchantments updateEnchantments(ItemStack p_331034_, Consumer<ItemMobEnchantments.Mutable> p_332031_) {
        DataComponentType datacomponenttype = (DataComponentType)ModDataCompnents.MOB_ENCHANTMENTS.get();
        ItemMobEnchantments itemenchantments = (ItemMobEnchantments)p_331034_.getOrDefault(datacomponenttype, (Object)ItemMobEnchantments.EMPTY);
        ItemMobEnchantments.Mutable itemenchantments$mutable = new ItemMobEnchantments.Mutable(itemenchantments);
        p_332031_.accept(itemenchantments$mutable);
        ItemMobEnchantments itemenchantments1 = itemenchantments$mutable.toImmutable();
        p_331034_.set(datacomponenttype, (Object)itemenchantments1);
        return itemenchantments1;
    }

    public static boolean addItemMobEnchantToEntity(ItemStack itemIn, LivingEntity entity, LivingEntity user, IEnchantCap capability) {
        ItemMobEnchantments itemMobEnchantments = MobEnchantUtils.getEnchantmentsForCrafting(itemIn);
        boolean flag = false;
        for (Holder<MobEnchant> mobEnchant : itemMobEnchantments.keySet()) {
            int level = itemMobEnchantments.getLevel((MobEnchant)mobEnchant.value());
            if (!MobEnchantUtils.checkAllowMobEnchantFromMob(mobEnchant, entity, capability)) continue;
            capability.getEnchantCap().addMobEnchant(entity, mobEnchant, level);
            flag = true;
        }
        if (flag && !user.level().isClientSide()) {
            itemIn.hurtAndBreak(1, user, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
        }
        return flag;
    }

    public static boolean addUnstableItemMobEnchantToEntity(ItemStack itemIn, LivingEntity entity, LivingEntity owner, IEnchantCap capability) {
        ItemMobEnchantments itemMobEnchantments = MobEnchantUtils.getEnchantmentsForCrafting(itemIn);
        boolean flag = false;
        for (Holder<MobEnchant> mobEnchant : itemMobEnchantments.keySet()) {
            int level = itemMobEnchantments.getLevel((MobEnchant)mobEnchant.value());
            if (!MobEnchantUtils.checkAllowMobEnchantFromMob(mobEnchant, entity, capability)) continue;
            capability.getEnchantCap().addMobEnchantFromOwner(entity, mobEnchant, level, owner);
            flag = true;
        }
        if (flag && !owner.level().isClientSide()) {
            itemIn.hurtAndBreak(1, owner, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
        }
        return flag;
    }

    public static void removeMobEnchantToEntity(LivingEntity entity, IEnchantCap capability) {
        capability.getEnchantCap().removeAllMobEnchant(entity);
    }

    public static int getExperienceFromMob(IEnchantCap cap) {
        int l = 0;
        for (MobEnchantHandler list : cap.getEnchantCap().getMobEnchants()) {
            Holder<MobEnchant> enchantment = list.getMobEnchant();
            int integer = list.getEnchantLevel();
            l += ((MobEnchant)enchantment.value()).getMinEnchantability(integer);
        }
        return l;
    }

    public static boolean addEnchantmentToEntity(LivingEntity livingEntity, IEnchantCap capability, MobEnchantmentData data) {
        boolean flag = false;
        if (MobEnchantUtils.checkAllowMobEnchantFromMob(data.enchantment, livingEntity, capability)) {
            capability.getEnchantCap().addMobEnchant(livingEntity, data.enchantment, data.enchantmentLevel, false);
            flag = true;
        }
        return flag;
    }

    public static boolean addEnchantmentToEntity(LivingEntity livingEntity, IEnchantCap capability, MobEnchantmentData data, boolean ancient) {
        boolean flag = false;
        if (MobEnchantUtils.checkAllowMobEnchantFromMob(data.enchantment, livingEntity, capability)) {
            capability.getEnchantCap().addMobEnchant(livingEntity, data.enchantment, data.enchantmentLevel, ancient);
            flag = true;
        }
        return flag;
    }

    public static boolean addRandomEnchantmentToEntity(LivingEntity livingEntity, IEnchantCap capability, RandomSource random, int level, boolean ancient, TagKey<MobEnchant> mobEnchantTagKey) {
        List<MobEnchantmentData> list = MobEnchantUtils.getSpawnEnchantmentList(livingEntity.registryAccess(), random, level, mobEnchantTagKey);
        boolean flag = false;
        for (MobEnchantmentData enchantmentdata : list) {
            if (!MobEnchantUtils.checkAllowMobEnchantFromMob(enchantmentdata.enchantment, livingEntity, capability)) continue;
            capability.getEnchantCap().addMobEnchant(livingEntity, enchantmentdata.enchantment, enchantmentdata.enchantmentLevel, ancient);
            flag = true;
        }
        return flag;
    }

    public static boolean addRandomEnchantmentToEntity(LivingEntity livingEntity, IEnchantCap capability, RandomSource random, int level, boolean ancient) {
        return MobEnchantUtils.addRandomEnchantmentToEntity(livingEntity, capability, random, level, ancient, ModTags.MobEnchantTags.RANDOM_SPAWN);
    }

    public static boolean addUnstableRandomEnchantmentToEntity(LivingEntity livingEntity, LivingEntity ownerEntity, IEnchantCap capability, RandomSource random, int level, TagKey<MobEnchant> mobEnchantTagKey) {
        List<MobEnchantmentData> list = MobEnchantUtils.getSpawnEnchantmentList(livingEntity.registryAccess(), random, level, mobEnchantTagKey);
        boolean flag = false;
        for (MobEnchantmentData enchantmentdata : list) {
            if (!MobEnchantUtils.checkAllowMobEnchantFromMob(enchantmentdata.enchantment, livingEntity, capability)) continue;
            capability.getEnchantCap().addMobEnchantFromOwner(livingEntity, enchantmentdata.enchantment, enchantmentdata.enchantmentLevel, ownerEntity);
            flag = true;
        }
        return flag;
    }

    public static boolean addUnstableRandomEnchantmentToEntity(LivingEntity livingEntity, LivingEntity ownerEntity, IEnchantCap capability, RandomSource random, int level) {
        return MobEnchantUtils.addUnstableRandomEnchantmentToEntity(livingEntity, ownerEntity, capability, random, level, ModTags.MobEnchantTags.RANDOM_SPAWN);
    }

    public static List<MobEnchantmentData> getSpawnEnchantmentList(RegistryAccess registryAccess, RandomSource random, int cost, TagKey<MobEnchant> mobEnchantTagKey) {
        Optional optional = registryAccess.lookupOrThrow(MobEnchants.MOB_ENCHANT_REGISTRY).get(mobEnchantTagKey);
        if (optional.isEmpty()) {
            return List.of();
        }
        List<MobEnchantmentData> list = MobEnchantUtils.buildEnchantmentList(registryAccess, random, cost, ((HolderSet.Named)optional.get()).stream());
        return list;
    }

    public static ItemStack addRandomEnchantmentToItemStack(RandomSource random, RegistryAccess registryAccess, ItemStack stack, int level, Stream<Holder<MobEnchant>> possibleEnchantments) {
        List<MobEnchantmentData> list = MobEnchantUtils.buildEnchantmentList(registryAccess, random, level, possibleEnchantments);
        for (MobEnchantmentData enchantmentdata : list) {
            MobEnchantUtils.enchant(enchantmentdata.enchantment, stack, enchantmentdata.enchantmentLevel);
        }
        return stack;
    }

    public static boolean findMobEnchantHandler(List<MobEnchantHandler> list, Holder<MobEnchant> findMobEnchant) {
        for (MobEnchantHandler mobEnchant : list) {
            if (!mobEnchant.getMobEnchant().equals(findMobEnchant)) continue;
            return true;
        }
        return false;
    }

    public static boolean findMobEnchant(List<Holder<MobEnchant>> list, Holder<MobEnchant> findMobEnchant) {
        return list.contains(findMobEnchant);
    }

    public static boolean findMobEnchantFromHandler(List<MobEnchantHandler> list, ResourceKey<MobEnchant> findMobEnchant) {
        for (MobEnchantHandler mobEnchant : list) {
            if (mobEnchant == null || !mobEnchant.getMobEnchant().is(findMobEnchant)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkAllowMobEnchantFromMob(@Nullable Holder<MobEnchant> mobEnchant, LivingEntity livingEntity, IEnchantCap capability) {
        if (!((Boolean)EnchantConfig.COMMON.universalEnchant.get()).booleanValue()) {
            // empty if block
        }
        for (MobEnchantHandler enchantHandler : capability.getEnchantCap().getMobEnchants()) {
            if (!(mobEnchant == null || enchantHandler.getMobEnchant() == null || ((MobEnchant)enchantHandler.getMobEnchant().value()).isCompatibleWith((MobEnchant)mobEnchant.value()) && enchantHandler.getMobEnchant().value() != mobEnchant.value())) {
                return false;
            }
            if (mobEnchant != null && ((MobEnchant)mobEnchant.value()).isCompatibleMob(livingEntity)) continue;
        }
        return mobEnchant != null;
    }

    public static int getMobEnchantLevelFromHandler(List<MobEnchantHandler> list, ResourceKey<MobEnchant> findMobEnchant) {
        for (MobEnchantHandler mobEnchant : list) {
            if (mobEnchant == null || !mobEnchant.getMobEnchant().is(findMobEnchant)) continue;
            return mobEnchant.getEnchantLevel();
        }
        return 0;
    }

    public static List<MobEnchantmentData> buildEnchantmentList(RegistryAccess registry, RandomSource randomIn, int level, Stream<Holder<MobEnchant>> possibleEnchantments) {
        ArrayList list = Lists.newArrayList();
        int i = 1;
        if (i <= 0) {
            return list;
        }
        level = level + 1 + randomIn.nextInt(i / 4 + 1) + randomIn.nextInt(i / 4 + 1);
        float f = (randomIn.nextFloat() + randomIn.nextFloat() - 1.0f) * 0.15f;
        List<MobEnchantmentData> list1 = MobEnchantUtils.getAvailableEnchantmentResults(level = Mth.clamp((int)Math.round((float)level + (float)level * f), (int)1, (int)Integer.MAX_VALUE), possibleEnchantments);
        if (!list1.isEmpty()) {
            WeightedRandom.getRandomItem((RandomSource)randomIn, list1, MobEnchantmentData::weight).ifPresent(list::add);
            while (randomIn.nextInt(50) <= level) {
                if (!list.isEmpty()) {
                    MobEnchantUtils.removeIncompatible(list1, (MobEnchantmentData)Util.lastOf((List)list));
                }
                if (list1.isEmpty()) break;
                WeightedRandom.getRandomItem((RandomSource)randomIn, list1, MobEnchantmentData::weight).ifPresent(list::add);
                level /= 2;
            }
        }
        return list;
    }

    public static List<MobEnchantmentData> getAvailableEnchantmentResults(int level, Stream<Holder<MobEnchant>> possibleEnchantments) {
        ArrayList list = Lists.newArrayList();
        possibleEnchantments.forEach(p_344478_ -> {
            MobEnchant enchantment = (MobEnchant)p_344478_.value();
            for (int i = enchantment.getMaxLevel(); i >= enchantment.getMinLevel(); --i) {
                if (level < enchantment.getMinEnchantability(i) || level > enchantment.getMaxEnchantability(i)) continue;
                list.add(new MobEnchantmentData((Holder<MobEnchant>)p_344478_, i));
                break;
            }
        });
        return list;
    }

    private static void removeIncompatible(List<MobEnchantmentData> dataList, MobEnchantmentData data) {
        Iterator<MobEnchantmentData> iterator = dataList.iterator();
        while (iterator.hasNext()) {
            if (((MobEnchant)data.enchantment.value()).isCompatibleWith((MobEnchant)iterator.next().enchantment.value())) continue;
            iterator.remove();
        }
    }

    public static float modifyDamage(ServerLevel level, Entity entity, DamageSource damageSource, float damage) {
        MutableFloat mutablefloat = new MutableFloat(damage);
        MobEnchantUtils.runIterationOnEntity(entity, (p_344525_, p_344526_) -> ((MobEnchant)p_344525_.value()).modifyDamage(level, p_344526_, entity, damageSource, mutablefloat));
        return mutablefloat.floatValue();
    }

    public static float getDamageProtection(ServerLevel level, LivingEntity entity, DamageSource damageSource) {
        MutableFloat mutablefloat = new MutableFloat(0.0f);
        MobEnchantUtils.runIterationOnEntity((Entity)entity, (p_344604_, p_344605_) -> ((MobEnchant)p_344604_.value()).modifyDamageProtection(level, p_344605_, entity, damageSource, mutablefloat));
        return mutablefloat.floatValue();
    }

    public static void runIterationOnEntity(Entity entity, MobEnchantmentVisitor visitor) {
        if (entity instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)entity;
            for (MobEnchantHandler handler : cap.getEnchantCap().getMobEnchants()) {
                visitor.accept(handler.getMobEnchant(), handler.getEnchantLevel());
            }
        }
    }

    @FunctionalInterface
    public static interface MobEnchantmentVisitor {
        public void accept(Holder<MobEnchant> var1, int var2);
    }
}

