/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integratedtunnels.core.FluidStorageBlockWrapper;
import org.cyclops.integratedtunnels.core.TunnelHelpers;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicate;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicateFluidStackList;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicateFluidStackNbt;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicateFluidStackOperator;
import org.cyclops.integratedtunnels.part.aspect.ITunnelConnection;

public class TunnelFluidHelpers {
    public static final IngredientPredicate<FluidStack, Integer> MATCH_NONE = new IngredientPredicate<FluidStack, Integer>(IngredientComponent.FLUIDSTACK, FluidStack.EMPTY, Integer.valueOf(7), false, true, 0, false){

        @Override
        public boolean test(FluidStack input) {
            return false;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == MATCH_NONE;
        }

        @Override
        public int hashCode() {
            return 9991029;
        }
    };

    public static IngredientPredicate<FluidStack, Integer> matchAll(int amount, boolean exactAmount) {
        return new IngredientPredicate<FluidStack, Integer>(IngredientComponent.FLUIDSTACK, new FluidStack((Fluid)Fluids.WATER, amount), Integer.valueOf(exactAmount ? 4 : 0), false, false, amount, exactAmount){

            @Override
            public boolean test(FluidStack input) {
                return true;
            }
        };
    }

    protected static int getFluidStackMatchFlags(boolean checkFluid, boolean checkAmount, boolean checkNbt) {
        int matchFlags = 0;
        if (checkFluid) {
            matchFlags |= 1;
        }
        if (checkNbt) {
            matchFlags |= 2;
        }
        if (checkAmount) {
            matchFlags |= 4;
        }
        return matchFlags;
    }

    public static IngredientPredicate<FluidStack, Integer> matchFluidStack(final FluidStack fluidStack, final boolean checkFluid, final boolean checkAmount, final boolean checkNbt, final boolean blacklist, boolean exactAmount) {
        return new IngredientPredicate<FluidStack, Integer>(IngredientComponent.FLUIDSTACK, fluidStack != null ? fluidStack.copy() : null, Integer.valueOf(TunnelFluidHelpers.getFluidStackMatchFlags(checkFluid, checkAmount, checkNbt)), blacklist, fluidStack == null && !blacklist, IModHelpersNeoForge.get().getFluidHelpers().getAmount(fluidStack), exactAmount){

            @Override
            public boolean test(@Nullable FluidStack input) {
                boolean result = TunnelFluidHelpers.areFluidStackEqual(input, fluidStack, checkFluid, checkAmount, checkNbt);
                if (blacklist) {
                    result = !result;
                }
                return result;
            }
        };
    }

    public static IngredientPredicate<FluidStack, Integer> matchFluidStacks(IValueTypeListProxy<ValueObjectTypeFluidStack, ValueObjectTypeFluidStack.ValueFluidStack> fluidStacks, boolean checkFluid, boolean checkAmount, boolean checkNbt, boolean blacklist, int amount, boolean exactAmount) {
        return new IngredientPredicateFluidStackList(blacklist, amount, exactAmount, fluidStacks, TunnelFluidHelpers.getFluidStackMatchFlags(checkFluid, checkAmount, checkNbt), checkFluid, checkAmount, checkNbt);
    }

    public static IngredientPredicate<FluidStack, Integer> matchPredicate(PartTarget partTarget, IOperator predicate, int amount, boolean exactAmount) {
        return new IngredientPredicateFluidStackOperator(amount, exactAmount, predicate, partTarget);
    }

    public static IngredientPredicate<FluidStack, Integer> matchNbt(Optional<Tag> tag, boolean subset, boolean superset, boolean requireNbt, boolean recursive, boolean blacklist, int amount, boolean exactAmount) {
        return new IngredientPredicateFluidStackNbt(blacklist, amount, exactAmount, requireNbt, subset, tag, recursive, superset);
    }

    public static boolean areFluidStackEqual(FluidStack stackA, FluidStack stackB, boolean checkFluid, boolean checkAmount, boolean checkNbt) {
        if (stackA == null && stackB == null) {
            return true;
        }
        if (stackA != null && stackB != null) {
            if (checkAmount && stackA.getAmount() != stackB.getAmount()) {
                return false;
            }
            if (checkFluid && stackA.getFluid() != stackB.getFluid()) {
                return false;
            }
            return !checkNbt || Objects.equals(stackA.getComponents(), stackB.getComponents());
        }
        return false;
    }

    public static FluidStack placeFluids(INetwork network, IPositionedAddonsNetworkIngredients<FluidStack, Integer> ingredientsNetwork, int channel, ITunnelConnection connection, IIngredientComponentStorage<FluidStack, Integer> source, Level world, BlockPos pos, IngredientPredicate<FluidStack, Integer> fluidStackMatcher, boolean blockUpdate, boolean ignoreReplacable, boolean craftIfFailed) throws EvaluationException {
        BlockState destBlockState = world.getBlockState(pos);
        boolean isDestNonSolid = !destBlockState.isSolid();
        boolean isDestReplaceable = destBlockState.canBeReplaced(TunnelHelpers.createBlockItemUseContext(world, null, pos, Direction.UP, InteractionHand.MAIN_HAND));
        if (!(world.isEmptyBlock(pos) || isDestNonSolid && ignoreReplacable && isDestReplaceable && !destBlockState.liquid())) {
            return null;
        }
        FluidStorageBlockWrapper destination = new FluidStorageBlockWrapper((ServerLevel)world, pos, null, blockUpdate);
        return TunnelHelpers.moveSingleStateOptimized(network, ingredientsNetwork, channel, connection, source, -1, destination, -1, fluidStackMatcher, PartPos.of((Level)world, (BlockPos)pos, null), craftIfFailed);
    }

    public static FluidStack pickUpFluids(INetwork network, IPositionedAddonsNetworkIngredients<FluidStack, Integer> ingredientsNetwork, int channel, ITunnelConnection connection, Level world, BlockPos pos, Direction side, IIngredientComponentStorage<FluidStack, Integer> destination, IngredientPredicate<FluidStack, Integer> fluidStackMatcher) throws EvaluationException {
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof LiquidBlock) {
            FluidStorageBlockWrapper source = new FluidStorageBlockWrapper((ServerLevel)world, pos, side, false);
            return TunnelHelpers.moveSingleStateOptimized(network, ingredientsNetwork, channel, connection, source, -1, destination, -1, fluidStackMatcher, PartPos.of((Level)world, (BlockPos)pos, (Direction)side), false);
        }
        return null;
    }

    public static FluidStack prototypeWithCount(FluidStack prototype, int count) {
        if (prototype == null || prototype.getAmount() != count) {
            if (prototype == null) {
                return count == 0 ? null : new FluidStack((Fluid)Fluids.WATER, count);
            }
            prototype = new FluidStack(prototype.getFluidHolder(), count, prototype.getComponentsPatch());
        }
        return prototype;
    }
}

