/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core.part;

import com.google.common.collect.Lists;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonImage;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetNumberField;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.integrateddynamics.client.gui.image.Images;
import org.cyclops.integrateddynamics.core.client.gui.container.ContainerScreenPartSettings;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipartAspects;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerPartSettings;
import org.cyclops.integratedtunnels.core.part.ContainerInterfaceSettings;

public class ContainerScreenInterfaceSettings
extends ContainerScreenPartSettings<ContainerInterfaceSettings> {
    private WidgetNumberField numberFieldChannelInterface = null;

    public ContainerScreenInterfaceSettings(ContainerInterfaceSettings container, Inventory inventory, Component title) {
        super((ContainerPartSettings)container, inventory, title);
    }

    protected ResourceLocation constructGuiTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"integratedtunnels", (String)"textures/gui/part_interface_settings.png");
    }

    protected void onSave() {
        super.onSave();
        try {
            int channelInterface = this.numberFieldChannelInterface.getInt();
            ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.getMenu()), (int)((ContainerInterfaceSettings)this.getMenu()).getLastChannelInterfaceValueId(), (int)channelInterface);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void init() {
        this.clearWidgets();
        super.init();
        this.numberFieldChannelInterface = new WidgetNumberField(this.font, this.leftPos + 106, this.topPos + 109, 70, 14, true, (Component)Component.translatable((String)"gui.integratedtunnels.partsettings.channel.interface"), true);
        this.numberFieldChannelInterface.setPositiveOnly(false);
        this.numberFieldChannelInterface.setMaxLength(15);
        this.numberFieldChannelInterface.setVisible(true);
        this.numberFieldChannelInterface.setTextColor(0xFFFFFF);
        this.numberFieldChannelInterface.setCanLoseFocus(true);
        this.addRenderableWidget((GuiEventListener)new ButtonImage(this.leftPos - 20, this.topPos + 0, 18, 18, (Component)Component.translatable((String)"gui.integrateddynamics.part_offsets"), this.createServerPressable(ContainerMultipartAspects.BUTTON_OFFSETS, button -> {}), new IImage[]{Images.BUTTON_BACKGROUND_INACTIVE, Images.BUTTON_MIDDLE_OFFSET}, false, 0, 0));
        this.refreshValues();
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (!this.numberFieldChannelInterface.charTyped(typedChar, keyCode)) {
            return super.charTyped(typedChar, keyCode);
        }
        return true;
    }

    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        if (typedChar != 256 && this.numberFieldChannelInterface.keyPressed(typedChar, keyCode, modifiers)) {
            return true;
        }
        return super.keyPressed(typedChar, keyCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.numberFieldChannelInterface.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        guiGraphics.drawString(this.font, IModHelpers.get().getL10NHelpers().localize("gui.integratedtunnels.partsettings.channel.interface", new Object[0]), this.leftPos + 8, this.topPos + 112, IModHelpers.get().getBaseHelpers().RGBAToInt(0, 0, 0, 255), false);
        this.numberFieldChannelInterface.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        if (this.isHovering(-20, 0, 18, 18, mouseX, mouseY)) {
            this.drawTooltip(Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"gui.integrateddynamics.part_offsets")}), guiGraphics, mouseX, mouseY);
        }
    }

    protected int getBaseYSize() {
        return 216;
    }

    public void onUpdate(int valueId, CompoundTag value) {
        super.onUpdate(valueId, value);
        if (valueId == ((ContainerInterfaceSettings)this.getMenu()).getLastChannelInterfaceValueId()) {
            this.numberFieldChannelInterface.setValue(Integer.toString(((ContainerInterfaceSettings)this.getMenu()).getLastChannelInterfaceValue()));
        }
    }
}

