/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core.predicate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integratedtunnels.part.aspect.ITunnelTransfer;

public abstract class IngredientPredicate<T, M>
implements Predicate<T>,
ITunnelTransfer {
    private final IngredientComponent<T, M> ingredientComponent;
    private final Iterable<T> instances;
    private final M matchFlags;
    private final boolean blacklist;
    private final boolean empty;
    private final int maxQuantity;
    private final boolean exactQuantity;

    public IngredientPredicate(IngredientComponent<T, M> ingredientComponent, Iterable<T> instances, M matchFlags, boolean blacklist, boolean empty, int maxQuantity, boolean exactQuantity) {
        this.ingredientComponent = ingredientComponent;
        this.instances = instances;
        this.matchFlags = matchFlags;
        this.blacklist = blacklist;
        this.empty = empty;
        this.maxQuantity = maxQuantity;
        this.exactQuantity = exactQuantity;
    }

    public IngredientPredicate(IngredientComponent<T, M> ingredientComponent, T instance, M matchFlags, boolean blacklist, boolean empty, int maxQuantity, boolean exactQuantity) {
        this(ingredientComponent, Collections.singletonList(instance), matchFlags, blacklist, empty, maxQuantity, exactQuantity);
    }

    public IngredientPredicate(IngredientComponent<T, M> ingredientComponent, boolean blacklist, boolean empty, int maxQuantity, boolean exactQuantity) {
        this(ingredientComponent, ingredientComponent.getMatcher().getEmptyInstance(), null, blacklist, empty, maxQuantity, exactQuantity);
    }

    public IngredientComponent<T, M> getIngredientComponent() {
        return this.ingredientComponent;
    }

    @Nonnull
    public Iterable<T> getInstances() {
        return this.instances;
    }

    public M getMatchFlags() {
        return this.matchFlags;
    }

    public boolean hasMatchFlags() {
        return this.matchFlags != null && !this.blacklist;
    }

    public boolean isBlacklist() {
        return this.blacklist;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public int getMaxQuantity() {
        return this.maxQuantity;
    }

    public boolean isExactQuantity() {
        return this.exactQuantity;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IngredientPredicate)) {
            return false;
        }
        IngredientPredicate that = (IngredientPredicate)obj;
        if (this.ingredientComponent != that.ingredientComponent || !Objects.equals(this.matchFlags, that.matchFlags) || this.blacklist != that.blacklist || this.empty != that.empty || this.maxQuantity != that.maxQuantity || this.exactQuantity != that.exactQuantity) {
            return false;
        }
        ArrayList instances1 = Lists.newArrayList(this.instances);
        ArrayList instances2 = Lists.newArrayList(that.instances);
        if (instances1.size() != instances2.size()) {
            return false;
        }
        IIngredientMatcher matcher = this.ingredientComponent.getMatcher();
        for (int i = 0; i < instances1.size(); ++i) {
            if (matcher.matchesExactly(instances1.get(i), instances2.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.ingredientComponent.hashCode() ^ StreamSupport.stream(this.instances.spliterator(), false).map(instance -> this.ingredientComponent.getMatcher().hash(instance)).reduce(0, (a, b) -> a ^ b) ^ Objects.hashCode(this.matchFlags) ^ (this.blacklist ? 1 : 0) ^ (this.empty ? 2 : 4) ^ this.maxQuantity ^ (this.exactQuantity ? 8 : 16);
    }

    public static enum EmptyBehaviour {
        ANY,
        NONE;


        public static EmptyBehaviour fromBoolean(boolean emptyIsAny) {
            return emptyIsAny ? ANY : NONE;
        }
    }
}

