/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.core.block.IgnoredBlockStatus;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integratedtunnels.part.PartTypes;
import org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders;
import org.cyclops.integratedtunnels.part.aspect.TunnelAspects;

public class GameTestsPlayerSimulator {
    public static final String TEMPLATE_EMPTY = "integratedtunnels:empty10";
    public static final int TIMEOUT = 2000;
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 1, 2);

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testPlayerSimulatorMilkCow(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.PLAYER_SIMULATOR, (ItemStack)new ItemStack((ItemLike)PartTypes.PLAYER_SIMULATOR.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        helper.setBlock(POS.east().east(), Blocks.CHEST);
        helper.spawnWithNoFreeWill(EntityType.COW, POS.west());
        helper.setBlock(POS.west().below(), Blocks.STONE);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.east().east(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.WHITE_WOOL));
        chestIn.setItem(1, new ItemStack((ItemLike)Items.BUCKET));
        chestIn.setItem(2, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Player.CLICK_ITEM_ITEMSTACK, (ItemStack)GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_ITEMSTACK, (IValue)ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)new ItemStack((ItemLike)Items.BUCKET))));
        helper.succeedWhen(() -> {
            helper.assertContainerContains(POS.east().east(), Items.WHITE_WOOL);
            helper.assertContainerContains(POS.east().east(), Items.MILK_BUCKET);
            helper.assertContainerContains(POS.east().east(), Items.DIAMOND_PICKAXE);
            helper.assertTrue(chestIn.getItem(3).isEmpty(), (Component)Component.literal((String)"Chest contains too many items"));
            helper.assertEntityPresent(EntityType.COW);
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), (Component)Component.literal((String)"Importer is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypes.PLAYER_SIMULATOR.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)), Direction.WEST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status is incorrect"));
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), TunnelAspects.Write.Player.CLICK_ITEM_ITEMSTACK, (Component)Component.literal((String)"Active aspect is incorrect"));
            helper.assertTrue(partStateWriter.getErrors(TunnelAspects.Write.Player.CLICK_ITEM_ITEMSTACK).isEmpty(), (Component)Component.literal((String)"Active aspect has errors"));
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testPlayerSimulatorKillCow(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.PLAYER_SIMULATOR, (ItemStack)new ItemStack((ItemLike)PartTypes.PLAYER_SIMULATOR.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        helper.setBlock(POS.east().east(), Blocks.CHEST);
        helper.spawnWithNoFreeWill(EntityType.COW, POS.west());
        helper.setBlock(POS.west().below(), Blocks.STONE);
        helper.setBlock(POS.west().north(), Blocks.ACACIA_FENCE);
        helper.setBlock(POS.west().south(), Blocks.ACACIA_FENCE);
        helper.setBlock(POS.west().west().north(), Blocks.ACACIA_FENCE);
        helper.setBlock(POS.west().west(), Blocks.ACACIA_FENCE);
        helper.setBlock(POS.west().west().south(), Blocks.ACACIA_FENCE);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.east().east(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.DIAMOND_SWORD));
        PartPos posPlayerSimulator = PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)posPlayerSimulator, TunnelAspects.Write.Player.CLICK_ITEM_BOOLEAN, (ItemStack)GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.BOOLEAN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true)));
        PartHelpers.PartStateHolder partStateHolder = PartHelpers.getPart((PartPos)posPlayerSimulator);
        IAspectProperties properties = TunnelAspects.Write.Player.CLICK_ITEM_BOOLEAN.getProperties(partStateHolder.getPart(), PartTarget.fromCenter((PartPos)posPlayerSimulator), partStateHolder.getState());
        properties.setValue(TunnelAspectWriteBuilders.Player.PROP_RIGHT_CLICK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
        partStateHolder.getState().setAspectProperties(TunnelAspects.Write.Player.CLICK_ITEM_BOOLEAN, properties);
        helper.succeedWhen(() -> {
            helper.assertContainerContains(POS.east().east(), Items.DIAMOND_SWORD);
            helper.assertEntityNotPresent(EntityType.COW);
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testPlayerSimulatorFlipLever(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.PLAYER_SIMULATOR, (ItemStack)new ItemStack((ItemLike)PartTypes.PLAYER_SIMULATOR.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        helper.setBlock(POS.east().east(), Blocks.CHEST);
        helper.setBlock(POS.west(), Blocks.LEVER);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Player.CLICK_EMPTY_BOOLEAN, (ItemStack)new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE));
        helper.succeedWhen(() -> helper.assertBlockProperty(POS.west(), (Property)LeverBlock.POWERED, (Comparable)Boolean.valueOf(true)));
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testPlayerSimulatorPlaceWaterBucket(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.PLAYER_SIMULATOR, (ItemStack)new ItemStack((ItemLike)PartTypes.PLAYER_SIMULATOR.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        helper.setBlock(POS.east().east(), Blocks.CHEST);
        helper.setBlock(POS.west().west(), Blocks.STONE);
        helper.setBlock(POS.west().north(), Blocks.STONE);
        helper.setBlock(POS.west().south(), Blocks.STONE);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.east().east(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.WATER_BUCKET));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Player.CLICK_ITEM_BOOLEAN, (ItemStack)new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE));
        helper.succeedWhen(() -> {
            helper.assertContainerContains(POS.east().east(), Items.BUCKET);
            helper.assertBlockPresent(Blocks.WATER, POS.west());
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testPlayerSimulatorBreakBlockPickaxe(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.PLAYER_SIMULATOR, (ItemStack)new ItemStack((ItemLike)PartTypes.PLAYER_SIMULATOR.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        helper.setBlock(POS.west(), Blocks.STONE);
        helper.setBlock(POS.below().west(), Blocks.STONE);
        helper.setBlock(POS.east().east(), Blocks.CHEST);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.east().east(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        PartPos posPlayerSimulator = PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)posPlayerSimulator, TunnelAspects.Write.Player.CLICK_ITEM_BOOLEAN, (ItemStack)GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.BOOLEAN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true)));
        PartHelpers.PartStateHolder partStateHolder = PartHelpers.getPart((PartPos)posPlayerSimulator);
        IAspectProperties properties = TunnelAspects.Write.Player.CLICK_ITEM_BOOLEAN.getProperties(partStateHolder.getPart(), PartTarget.fromCenter((PartPos)posPlayerSimulator), partStateHolder.getState());
        properties.setValue(TunnelAspectWriteBuilders.Player.PROP_RIGHT_CLICK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
        partStateHolder.getState().setAspectProperties(TunnelAspects.Write.Player.CLICK_ITEM_BOOLEAN, properties);
        helper.succeedWhen(() -> {
            helper.assertContainerContains(POS.east().east(), Items.DIAMOND_PICKAXE);
            helper.assertItemEntityPresent(Items.COBBLESTONE);
            helper.assertBlockNotPresent(Blocks.STONE, POS.west());
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testPlayerSimulatorPlaceBlock(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.PLAYER_SIMULATOR, (ItemStack)new ItemStack((ItemLike)PartTypes.PLAYER_SIMULATOR.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        helper.setBlock(POS.east().east(), Blocks.CHEST);
        helper.setBlock(POS.west().west().west(), Blocks.STONE);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.east().east(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.DIRT));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Player.CLICK_ITEM_BOOLEAN, (ItemStack)new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE));
        helper.succeedWhen(() -> {
            helper.assertContainerEmpty(POS.east().east());
            helper.assertBlockPresent(Blocks.DIRT, POS.west().west());
        });
    }
}

