/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework;

import com.mrcrayfish.framework.Registration;
import com.mrcrayfish.framework.api.LogicalEnvironment;
import com.mrcrayfish.framework.api.event.FrameworkServerEvents;
import com.mrcrayfish.framework.api.registry.BlockRegistryEntry;
import com.mrcrayfish.framework.api.registry.IRegisterFunction;
import com.mrcrayfish.framework.api.util.TaskRunner;
import com.mrcrayfish.framework.config.FrameworkConfigManager;
import com.mrcrayfish.framework.platform.Services;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;

public class FrameworkSetup {
    private static boolean initialized;

    public static void run() {
        if (initialized) {
            return;
        }
        Registration.init();
        FrameworkConfigManager.getInstance();
        if (Services.PLATFORM.getPlatform().isFabric()) {
            Registration.getSortedRegistryEntries().forEach(entry -> entry.register(new IRegisterFunction(){

                @Override
                public <T> void call(Registry<T> registry, ResourceLocation name, Supplier<T> supplier) {
                    Registry.register(registry, (ResourceLocation)name, supplier.get());
                }
            }));
            Registration.get(Registries.BLOCK).forEach(entry -> {
                if (entry instanceof BlockRegistryEntry) {
                    BlockRegistryEntry blockEntry = (BlockRegistryEntry)entry;
                    blockEntry.item().ifPresent(item -> Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)entry.getId(), (Object)item));
                }
            });
        }
        initialized = true;
    }

    static void init() {
        FrameworkServerEvents.STARTED.register(server -> TaskRunner.setExecutor(LogicalEnvironment.SERVER, server));
        FrameworkServerEvents.STOPPED.register(server -> TaskRunner.setExecutor(LogicalEnvironment.SERVER, null));
    }
}

