/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.serialize;

import com.mrcrayfish.framework.api.serialize.DataBoolean;
import com.mrcrayfish.framework.api.serialize.DataEntry;
import com.mrcrayfish.framework.api.serialize.DataNumber;
import com.mrcrayfish.framework.api.serialize.DataObject;
import com.mrcrayfish.framework.api.serialize.DataString;
import com.mrcrayfish.framework.api.serialize.DataType;

public final class DataHelper {
    public static boolean getBooleanOrDefault(DataObject object, String key, boolean defaultValue) {
        DataEntry dataEntry = object.get(key);
        if (dataEntry instanceof DataBoolean) {
            DataBoolean entry = (DataBoolean)dataEntry;
            return entry.asBoolean();
        }
        return defaultValue;
    }

    public static int getIntOrDefault(DataObject object, String key, int defaultValue) {
        DataEntry dataEntry = object.get(key);
        if (dataEntry instanceof DataNumber) {
            DataNumber entry = (DataNumber)dataEntry;
            return entry.asInt();
        }
        return defaultValue;
    }

    public static long getLongOrDefault(DataObject object, String key, long defaultValue) {
        DataEntry dataEntry = object.get(key);
        if (dataEntry instanceof DataNumber) {
            DataNumber entry = (DataNumber)dataEntry;
            return entry.asLong();
        }
        return defaultValue;
    }

    public static float getFloatOrDefault(DataObject object, String key, float defaultValue) {
        DataEntry dataEntry = object.get(key);
        if (dataEntry instanceof DataNumber) {
            DataNumber entry = (DataNumber)dataEntry;
            return entry.asFloat();
        }
        return defaultValue;
    }

    public static double getDoubleOrDefault(DataObject object, String key, double defaultValue) {
        DataEntry dataEntry = object.get(key);
        if (dataEntry instanceof DataNumber) {
            DataNumber entry = (DataNumber)dataEntry;
            return entry.asDouble();
        }
        return defaultValue;
    }

    public static String getStringOrDefault(DataObject object, String key, String defaultValue) {
        DataEntry dataEntry = object.get(key);
        if (dataEntry instanceof DataString) {
            DataString entry = (DataString)dataEntry;
            return entry.asString();
        }
        return defaultValue;
    }

    public static DataObject getDataObjectFromPath(DataObject root, String ... path) {
        DataObject result = root;
        for (String s : path) {
            if (!result.has(s, DataType.OBJECT)) {
                return DataObject.EMPTY;
            }
            result = result.getDataObject(s);
        }
        return result != root || path.length == 0 ? result : DataObject.EMPTY;
    }
}

