/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.client;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mrcrayfish.framework.Registration;
import com.mrcrayfish.framework.api.LogicalEnvironment;
import com.mrcrayfish.framework.api.client.model.NeoForgeModelResource;
import com.mrcrayfish.framework.api.util.TaskRunner;
import com.mrcrayfish.framework.client.ClientNeoForgeEvents;
import com.mrcrayfish.framework.client.JsonDataManager;
import com.mrcrayfish.framework.client.model.FrameworkBlockStateModel;
import com.mrcrayfish.framework.client.model.FrameworkItemModel;
import com.mrcrayfish.framework.client.model.NeoForgeFrameworkBlockStateModel;
import com.mrcrayfish.framework.client.model.StandaloneModelManager;
import com.mrcrayfish.framework.platform.Services;
import com.mrcrayfish.framework.platform.network.NeoForgeNetwork;
import java.util.function.BiConsumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.AddClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterBlockStateModels;
import net.neoforged.neoforge.client.event.RegisterItemModelsEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterRenderPipelinesEvent;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelKey;
import net.neoforged.neoforge.client.model.standalone.UnbakedStandaloneModel;
import net.neoforged.neoforge.client.network.event.RegisterClientPayloadHandlersEvent;
import net.neoforged.neoforge.common.NeoForge;

@EventBusSubscriber(modid="framework", value={Dist.CLIENT})
public final class ClientFrameworkNeoForge {
    @SubscribeEvent
    private static void onClientSetup(FMLClientSetupEvent event) {
        TaskRunner.setExecutor(LogicalEnvironment.CLIENT, Minecraft.getInstance());
        NeoForge.EVENT_BUS.register((Object)new ClientNeoForgeEvents());
    }

    @SubscribeEvent
    private static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        Services.REGISTRATION.getRegistryObjects(KeyMapping.class).forEach(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }

    @SubscribeEvent
    private static void registerReloadListener(AddClientReloadListenersEvent event) {
        event.addListener(JsonDataManager.ID, (PreparableReloadListener)JsonDataManager.getInstance());
    }

    @SubscribeEvent
    private static void onRegisterAdditionalModels(ModelEvent.RegisterStandalone event) {
        StandaloneModelManager.getInstance().load(resource -> {
            resource.clearCache();
            ClientFrameworkNeoForge.registerStandaloneModel((arg_0, arg_1) -> ((ModelEvent.RegisterStandalone)event).register(arg_0, arg_1), (NeoForgeModelResource)resource);
        });
    }

    private static <T> void registerStandaloneModel(BiConsumer<StandaloneModelKey<T>, UnbakedStandaloneModel<T>> consumer, NeoForgeModelResource<T> key) {
        consumer.accept(key.standaloneKey(), key.unbakedModel());
    }

    @SubscribeEvent
    private static void onRegisterItemModels(RegisterItemModelsEvent event) {
        event.register(FrameworkItemModel.ID, FrameworkItemModel.Unbaked.MAP_CODEC);
    }

    @SubscribeEvent
    private static void onRegisterItemModels(RegisterBlockStateModels event) {
        event.registerModel(FrameworkBlockStateModel.ID, NeoForgeFrameworkBlockStateModel.Unbaked.MAP_CODEC);
    }

    @SubscribeEvent
    private static void onRegisterRenderPipelines(RegisterRenderPipelinesEvent event) {
        Services.REGISTRATION.getRegistryObjects(RenderPipeline.class).forEach(arg_0 -> ((RegisterRenderPipelinesEvent)event).registerPipeline(arg_0));
    }

    @SubscribeEvent
    private static void onRegisterClientPayloadHandler(RegisterClientPayloadHandlersEvent event) {
        Registration.getNetworks().forEach(network -> ((NeoForgeNetwork)network).registerClientPayloads(event));
    }
}

