/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.client.model;

import com.mrcrayfish.framework.api.serialize.DataObject;
import com.mrcrayfish.framework.client.model.IOpenModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class OpenModelHelper {
    public static DataObject getData(BlockState state) {
        DataObject dataObject;
        BlockStateModel model = Minecraft.getInstance().getModelManager().getBlockModelShaper().getBlockModel(state);
        if (model instanceof IOpenModel) {
            IOpenModel openModel = (IOpenModel)model;
            dataObject = openModel.getData();
        } else {
            dataObject = DataObject.EMPTY;
        }
        return dataObject;
    }

    public static DataObject getData(Item item) {
        ResourceLocation location = (ResourceLocation)item.components().get(DataComponents.ITEM_MODEL);
        if (location != null) {
            return OpenModelHelper.readDataFromTopLevelItemModel(location);
        }
        return DataObject.EMPTY;
    }

    public static DataObject getData(ItemStack stack) {
        ResourceLocation location = (ResourceLocation)stack.get(DataComponents.ITEM_MODEL);
        if (location != null) {
            return OpenModelHelper.readDataFromTopLevelItemModel(location);
        }
        return DataObject.EMPTY;
    }

    private static DataObject readDataFromTopLevelItemModel(ResourceLocation location) {
        ItemModel model = Minecraft.getInstance().getModelManager().getItemModel(location);
        if (model instanceof IOpenModel) {
            IOpenModel openModel = (IOpenModel)model;
            return openModel.getData();
        }
        return DataObject.EMPTY;
    }
}

