/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.network.message.configuration;

import com.mrcrayfish.framework.api.network.ConfigurationMessageContext;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.network.ConfigurationTask;

public record FinishedConfigurationTask(String id, Action action) {
    public static final StreamCodec<FriendlyByteBuf, FinishedConfigurationTask> STREAM_CODEC = StreamCodec.of((buf, task) -> {
        buf.writeUtf(task.id);
        buf.writeEnum((Enum)task.action);
    }, buf -> {
        String id = buf.readUtf();
        Action action = (Action)buf.readEnum(Action.class);
        return new FinishedConfigurationTask(id, action);
    });

    public FinishedConfigurationTask(ConfigurationTask.Type type, Action action) {
        this(type.id(), action);
    }

    public static void handle(FinishedConfigurationTask message, ConfigurationMessageContext context) {
        switch (message.action().ordinal()) {
            case 0: {
                context.reply(new FinishedConfigurationTask(message.id(), Action.COMPLETED));
                break;
            }
            case 1: {
                context.completeTask(message.id());
            }
        }
        context.setHandled(true);
    }

    public static enum Action {
        AWAIT,
        COMPLETED;

    }
}

