/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.platform;

import com.google.common.base.MoreObjects;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.mrcrayfish.framework.api.client.model.FrameworkBakedModel;
import com.mrcrayfish.framework.api.client.model.FrameworkModelBaker;
import com.mrcrayfish.framework.api.client.model.FrameworkModelResource;
import com.mrcrayfish.framework.api.client.model.NeoForgeModelResource;
import com.mrcrayfish.framework.platform.services.IClientHelper;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.NeoForgeModelProperties;

public class NeoForgeClientHelper
implements IClientHelper {
    private static final BlockElement.Deserializer BLOCK_PART_DESERIALIZER = new BlockElement.Deserializer();

    @Override
    public BlockElement deserializeBlockElement(JsonElement element, JsonDeserializationContext context) {
        return BLOCK_PART_DESERIALIZER.deserialize(element, BlockElement.class, context);
    }

    @Override
    public <T> T getStandaloneModel(FrameworkModelResource<T> resource) {
        return (T)Minecraft.getInstance().getModelManager().getStandaloneModel(((NeoForgeModelResource)resource).standaloneKey());
    }

    @Override
    public <T> FrameworkModelResource<T> createModelResource(ResourceLocation id, FrameworkModelBaker<T> baker) {
        return new NeoForgeModelResource<T>(id, baker);
    }

    @Override
    public ChunkSectionLayer getChunkSectionLayer(ResolvedModel model) {
        RenderTypeGroup group = (RenderTypeGroup)model.getTopAdditionalProperties().getOptional(NeoForgeModelProperties.RENDER_TYPE);
        return group != null && !group.isEmpty() ? group.block() : ChunkSectionLayer.SOLID;
    }

    @Override
    public ChunkSectionLayer getChunkSectionLayer(BlockModelPart part) {
        BlockModelPart blockModelPart = part;
        Objects.requireNonNull(blockModelPart);
        BlockModelPart blockModelPart2 = blockModelPart;
        int n = 0;
        return (ChunkSectionLayer)MoreObjects.firstNonNull(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SimpleModelWrapper.class, FrameworkBakedModel.class}, (Object)blockModelPart2, n)) {
            case 0 -> {
                SimpleModelWrapper wrapper = (SimpleModelWrapper)blockModelPart2;
                yield wrapper.renderType();
            }
            case 1 -> {
                FrameworkBakedModel model = (FrameworkBakedModel)blockModelPart2;
                yield model.layer();
            }
            default -> null;
        }, (Object)ChunkSectionLayer.SOLID);
    }
}

