/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.compat.mekanism;

import com.supermartijn642.trashcans.compat.Compatibility;
import com.supermartijn642.trashcans.filter.IFilterManager;
import com.supermartijn642.trashcans.filter.ItemFilter;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class GasFilterManager
implements IFilterManager {
    @Override
    public ItemFilter createFilter(ItemStack stack) {
        return new GasFilter(stack);
    }

    @Override
    public ItemFilter readFilter(ValueInput input) {
        return new GasFilter(input);
    }

    private static class GasFilter
    extends ItemFilter {
        ChemicalStack stack;

        public GasFilter(ItemStack stack) {
            this.stack = GasFilter.getGas(stack);
            if (this.stack != null) {
                this.stack = this.stack.copy();
            }
        }

        public GasFilter(ValueInput input) {
            this.stack = input.read("stack", ChemicalStack.CODEC).orElse(ChemicalStack.EMPTY);
        }

        @Override
        public boolean matches(Object stack) {
            ChemicalStack fluid = stack instanceof ChemicalStack ? (ChemicalStack)stack : (stack instanceof ItemStack ? GasFilter.getGas((ItemStack)stack) : null);
            return fluid != null && ChemicalStack.isSameChemical((ChemicalStack)fluid, (ChemicalStack)this.stack);
        }

        @Override
        public ItemStack getRepresentingItem() {
            return Compatibility.MEKANISM.getChemicalTankForGasStack(this.stack);
        }

        @Override
        public void write(ValueOutput output) {
            output.store("stack", ChemicalStack.CODEC, (Object)this.stack);
        }

        @Override
        public boolean isValid() {
            return this.stack != null && !this.stack.isEmpty();
        }

        private static ChemicalStack getGas(ItemStack stack) {
            IChemicalHandler gasHandler = (IChemicalHandler)stack.getCapability(Capabilities.CHEMICAL.item());
            return gasHandler == null || gasHandler.getChemicalTanks() != 1 || gasHandler.getChemicalInTank(0).isEmpty() ? null : gasHandler.getChemicalInTank(0);
        }
    }
}

