/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.compat.mekanism;

import com.supermartijn642.trashcans.TrashCansConfig;
import com.supermartijn642.trashcans.compat.mekanism.GasFilterManager;
import com.supermartijn642.trashcans.compat.mekanism.MekanismCompatOff;
import com.supermartijn642.trashcans.filter.ItemFilter;
import com.supermartijn642.trashcans.filter.LiquidTrashCanFilters;
import java.util.ArrayList;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.registries.MekanismBlocks;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.BlockCapability;

public class MekanismCompatOn
extends MekanismCompatOff {
    public MekanismCompatOn() {
        LiquidTrashCanFilters.register(new GasFilterManager(), "gas");
    }

    @Override
    public boolean isInstalled() {
        return true;
    }

    @Override
    public BlockCapability<Object, Direction> getGasHandlerCapability() {
        return Capabilities.CHEMICAL.block();
    }

    @Override
    public boolean doesItemHaveGasStored(ItemStack stack) {
        IChemicalHandler handler = (IChemicalHandler)stack.getCapability(Capabilities.CHEMICAL.item());
        if (handler == null) {
            return false;
        }
        for (int i = 0; i < handler.getChemicalTanks(); ++i) {
            if (handler.getChemicalInTank(i).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean drainGasFromItem(ItemStack stack) {
        IChemicalHandler handler = (IChemicalHandler)stack.getCapability(Capabilities.CHEMICAL.item());
        if (handler == null) {
            return false;
        }
        boolean changed = false;
        for (int tank = 0; tank < handler.getChemicalTanks(); ++tank) {
            if (handler.getChemicalInTank(tank).isEmpty()) continue;
            handler.extractChemical(handler.getChemicalInTank(tank), Action.EXECUTE);
            changed = true;
        }
        return changed;
    }

    @Override
    public Object getGasHandler(final ArrayList<ItemFilter> filters, final Supplier<Boolean> whitelist) {
        return new IChemicalHandler(){

            public int getChemicalTanks() {
                return 1;
            }

            public ChemicalStack getChemicalInTank(int i) {
                return ChemicalStack.EMPTY;
            }

            public void setChemicalInTank(int i, ChemicalStack gasStack) {
            }

            public long getChemicalTankCapacity(int i) {
                return Integer.MAX_VALUE;
            }

            public boolean isValid(int i, ChemicalStack gasStack) {
                if (gasStack.isRadioactive() && !TrashCansConfig.allowVoidingNuclearWaste.get().booleanValue()) {
                    return false;
                }
                for (ItemFilter filter : filters) {
                    if (filter == null || !filter.matches(gasStack)) continue;
                    return (Boolean)whitelist.get();
                }
                return (Boolean)whitelist.get() == false;
            }

            public ChemicalStack insertChemical(int i, ChemicalStack gasStack, Action action) {
                if (this.isValid(i, gasStack)) {
                    return ChemicalStack.EMPTY;
                }
                return gasStack;
            }

            public ChemicalStack extractChemical(int i, long l, Action action) {
                return ChemicalStack.EMPTY;
            }
        };
    }

    @Override
    public boolean isGasStack(Object obj) {
        return obj instanceof ChemicalStack;
    }

    @Override
    public ItemStack getChemicalTankForGasStack(Object gasStack) {
        ItemStack stack = new ItemStack((ItemLike)MekanismBlocks.CREATIVE_CHEMICAL_TANK);
        IChemicalHandler handler = (IChemicalHandler)stack.getCapability(Capabilities.CHEMICAL.item());
        ChemicalStack gas = ((ChemicalStack)gasStack).copy();
        gas.setAmount(handler.getChemicalTankCapacity(0));
        handler.setChemicalInTank(0, gas);
        return stack;
    }
}

