/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.screen;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.ObjectBaseContainerWidget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.trashcans.TrashCanBlockEntity;
import com.supermartijn642.trashcans.screen.TrashCanContainer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public abstract class TrashCanScreen<T extends TrashCanContainer>
extends ObjectBaseContainerWidget<TrashCanBlockEntity, T> {
    private final Component title;

    public TrashCanScreen(String title) {
        super(0, 0, 1, 1);
        this.title = TextComponents.translation((String)title).get();
    }

    protected Component getNarrationMessage(TrashCanBlockEntity object) {
        return this.title;
    }

    protected TrashCanBlockEntity getObject(TrashCanBlockEntity oldObject) {
        return ((TrashCanContainer)this.container).getBlockEntity();
    }

    protected boolean validateObject(TrashCanBlockEntity object) {
        return object != null && !object.isRemoved();
    }

    protected int width(TrashCanBlockEntity object) {
        return ((TrashCanContainer)this.container).width;
    }

    protected int height(TrashCanBlockEntity object) {
        return ((TrashCanContainer)this.container).height;
    }

    protected abstract ResourceLocation getBackground();

    protected void renderBackground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY, TrashCanBlockEntity entity) {
        super.renderBackground(context, graphics, mouseX, mouseY, (Object)entity);
        graphics.submitSprite(this.getBackground(), 0.0f, 0.0f, (float)this.width(), (float)this.height());
    }

    protected void renderForeground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY, TrashCanBlockEntity entity) {
        super.renderForeground(context, graphics, mouseX, mouseY, (Object)entity);
        graphics.submitText((FormattedText)this.title, (float)this.width() / 2.0f, 6.0f, p -> p.centerHorizontally());
        graphics.submitText((FormattedText)ClientUtils.getPlayer().getInventory().getName(), 21.0f, (float)(this.height() - 94));
        this.drawText(graphics, entity);
    }

    protected abstract void drawText(GuiGraphicsHelper var1, TrashCanBlockEntity var2);
}

