/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hoppergadgetry.data.client;

import fuzs.hoppergadgetry.HopperGadgetry;
import fuzs.hoppergadgetry.init.ModRegistry;
import fuzs.hoppergadgetry.world.level.block.DuctBlock;
import fuzs.puzzleslib.api.client.data.v2.AbstractModelProvider;
import fuzs.puzzleslib.api.client.data.v2.models.ModelLocationHelper;
import fuzs.puzzleslib.api.client.data.v2.models.ModelTemplateHelper;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.MultiPartGenerator;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class ModModelProvider
extends AbstractModelProvider {
    public static final ModelTemplate CHUTE_TEMPLATE = ModelTemplateHelper.createBlockModelTemplate((ResourceLocation)HopperGadgetry.id("template_chute"), (TextureSlot[])new TextureSlot[]{TextureSlot.TOP, TextureSlot.SIDE, TextureSlot.PARTICLE});
    public static final ModelTemplate DUCT_TEMPLATE = ModelTemplateHelper.createBlockModelTemplate((ResourceLocation)HopperGadgetry.id("template_duct"), (TextureSlot[])new TextureSlot[]{TextureSlot.TEXTURE, TextureSlot.PARTICLE});
    public static final ModelTemplate DUCT_INPUT_TEMPLATE = ModelTemplateHelper.createBlockModelTemplate((ResourceLocation)HopperGadgetry.id("template_duct_input"), (TextureSlot[])new TextureSlot[]{TextureSlot.TEXTURE, TextureSlot.PARTICLE});
    public static final ModelTemplate GRATE_TEMPLATE = ModelTemplateHelper.createBlockModelTemplate((ResourceLocation)HopperGadgetry.id("template_grate"), (TextureSlot[])new TextureSlot[]{TextureSlot.TEXTURE, TextureSlot.PARTICLE});

    public ModModelProvider(DataProviderContext context) {
        super(context);
    }

    public static TextureMapping createParticleTextureMapping(Block block) {
        return ModModelProvider.createParticleTextureMapping(block, "");
    }

    public static TextureMapping createParticleTextureMapping(Block block, String suffix) {
        ResourceLocation resourceLocation = TextureMapping.getBlockTexture((Block)block, (String)suffix);
        return new TextureMapping().put(TextureSlot.TEXTURE, resourceLocation).put(TextureSlot.PARTICLE, resourceLocation);
    }

    public void addBlockModels(BlockModelGenerators blockModelGenerators) {
        this.createDuct((Block)ModRegistry.DUCT_BLOCK.value(), blockModelGenerators);
        this.createChute((Block)ModRegistry.CHUTE_BLOCK.value(), blockModelGenerators);
        this.createGratedHopper((Block)ModRegistry.GRATED_HOPPER_BLOCK.value(), blockModelGenerators);
    }

    public final void createDuct(Block block, BlockModelGenerators blockModelGenerators) {
        MultiVariant blockModel = BlockModelGenerators.plainVariant((ResourceLocation)DUCT_TEMPLATE.create(block, ModModelProvider.createParticleTextureMapping(block), blockModelGenerators.modelOutput));
        MultiVariant poweredModel = BlockModelGenerators.plainVariant((ResourceLocation)DUCT_TEMPLATE.createWithSuffix(block, "_powered", ModModelProvider.createParticleTextureMapping(block, "_powered"), blockModelGenerators.modelOutput));
        MultiVariant inputModel = BlockModelGenerators.plainVariant((ResourceLocation)DUCT_INPUT_TEMPLATE.createWithSuffix(block, "_input", ModModelProvider.createParticleTextureMapping(block, "_input"), blockModelGenerators.modelOutput));
        blockModelGenerators.blockStateOutput.accept(MultiPartGenerator.multiPart((Block)block).with(BlockModelGenerators.condition().term(DuctBlock.FACING, (Comparable)Direction.NORTH).term((Property)DuctBlock.ENABLED, (Comparable)Boolean.FALSE), poweredModel).with(BlockModelGenerators.condition().term(DuctBlock.FACING, (Comparable)Direction.EAST).term((Property)DuctBlock.ENABLED, (Comparable)Boolean.FALSE), poweredModel.with(BlockModelGenerators.Y_ROT_90)).with(BlockModelGenerators.condition().term(DuctBlock.FACING, (Comparable)Direction.SOUTH).term((Property)DuctBlock.ENABLED, (Comparable)Boolean.FALSE), poweredModel.with(BlockModelGenerators.Y_ROT_180)).with(BlockModelGenerators.condition().term(DuctBlock.FACING, (Comparable)Direction.WEST).term((Property)DuctBlock.ENABLED, (Comparable)Boolean.FALSE), poweredModel.with(BlockModelGenerators.Y_ROT_270)).with(BlockModelGenerators.condition().term(DuctBlock.FACING, (Comparable)Direction.DOWN).term((Property)DuctBlock.ENABLED, (Comparable)Boolean.FALSE), poweredModel.with(BlockModelGenerators.X_ROT_90)).with(BlockModelGenerators.condition().term(DuctBlock.FACING, (Comparable)Direction.UP).term((Property)DuctBlock.ENABLED, (Comparable)Boolean.FALSE), poweredModel.with(BlockModelGenerators.X_ROT_270)).with(BlockModelGenerators.condition().term(DuctBlock.FACING, (Comparable)Direction.NORTH).term((Property)DuctBlock.ENABLED, (Comparable)Boolean.TRUE), blockModel).with(BlockModelGenerators.condition().term(DuctBlock.FACING, (Comparable)Direction.EAST).term((Property)DuctBlock.ENABLED, (Comparable)Boolean.TRUE), blockModel.with(BlockModelGenerators.Y_ROT_90)).with(BlockModelGenerators.condition().term(DuctBlock.FACING, (Comparable)Direction.SOUTH).term((Property)DuctBlock.ENABLED, (Comparable)Boolean.TRUE), blockModel.with(BlockModelGenerators.Y_ROT_180)).with(BlockModelGenerators.condition().term(DuctBlock.FACING, (Comparable)Direction.WEST).term((Property)DuctBlock.ENABLED, (Comparable)Boolean.TRUE), blockModel.with(BlockModelGenerators.Y_ROT_270)).with(BlockModelGenerators.condition().term(DuctBlock.FACING, (Comparable)Direction.DOWN).term((Property)DuctBlock.ENABLED, (Comparable)Boolean.TRUE), blockModel.with(BlockModelGenerators.X_ROT_90)).with(BlockModelGenerators.condition().term(DuctBlock.FACING, (Comparable)Direction.UP).term((Property)DuctBlock.ENABLED, (Comparable)Boolean.TRUE), blockModel.with(BlockModelGenerators.X_ROT_270)).with(BlockModelGenerators.condition().term((Property)DuctBlock.NORTH, (Comparable)Boolean.TRUE).negatedTerm(DuctBlock.FACING, (Comparable)Direction.NORTH), inputModel).with(BlockModelGenerators.condition().term((Property)DuctBlock.EAST, (Comparable)Boolean.TRUE).negatedTerm(DuctBlock.FACING, (Comparable)Direction.EAST), inputModel.with(BlockModelGenerators.Y_ROT_90)).with(BlockModelGenerators.condition().term((Property)DuctBlock.SOUTH, (Comparable)Boolean.TRUE).negatedTerm(DuctBlock.FACING, (Comparable)Direction.SOUTH), inputModel.with(BlockModelGenerators.Y_ROT_180)).with(BlockModelGenerators.condition().term((Property)DuctBlock.WEST, (Comparable)Boolean.TRUE).negatedTerm(DuctBlock.FACING, (Comparable)Direction.WEST), inputModel.with(BlockModelGenerators.Y_ROT_270)).with(BlockModelGenerators.condition().term((Property)DuctBlock.DOWN, (Comparable)Boolean.TRUE).negatedTerm(DuctBlock.FACING, (Comparable)Direction.DOWN), inputModel.with(BlockModelGenerators.X_ROT_90)).with(BlockModelGenerators.condition().term((Property)DuctBlock.UP, (Comparable)Boolean.TRUE).negatedTerm(DuctBlock.FACING, (Comparable)Direction.UP), inputModel.with(BlockModelGenerators.X_ROT_270)));
    }

    public final void createChute(Block block, BlockModelGenerators blockModelGenerators) {
        ResourceLocation resourceLocation = CHUTE_TEMPLATE.create(block, TextureMapping.logColumn((Block)Blocks.STRIPPED_OAK_LOG), blockModelGenerators.modelOutput);
        blockModelGenerators.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)resourceLocation)));
    }

    public final void createGratedHopper(Block block, BlockModelGenerators blockModelGenerators) {
        MultiVariant blockModel = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationHelper.getBlockModel((Block)Blocks.HOPPER));
        MultiVariant sideModel = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationHelper.getBlockModel((Block)Blocks.HOPPER, (String)"_side"));
        MultiVariant grateModel = BlockModelGenerators.plainVariant((ResourceLocation)GRATE_TEMPLATE.createWithSuffix(block, "_grate", ModModelProvider.createParticleTextureMapping(Blocks.IRON_BARS), blockModelGenerators.modelOutput));
        blockModelGenerators.blockStateOutput.accept(MultiPartGenerator.multiPart((Block)block).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.FACING_HOPPER, (Comparable)Direction.DOWN), blockModel).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.FACING_HOPPER, (Comparable)Direction.NORTH), sideModel).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.FACING_HOPPER, (Comparable)Direction.EAST), sideModel.with(BlockModelGenerators.Y_ROT_90)).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.FACING_HOPPER, (Comparable)Direction.SOUTH), sideModel.with(BlockModelGenerators.Y_ROT_180)).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.FACING_HOPPER, (Comparable)Direction.WEST), sideModel.with(BlockModelGenerators.Y_ROT_270)).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.FACING_HOPPER, (Comparable)Direction.DOWN), grateModel).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.FACING_HOPPER, (Comparable)Direction.NORTH), grateModel).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.FACING_HOPPER, (Comparable)Direction.EAST), grateModel.with(BlockModelGenerators.Y_ROT_90)).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.FACING_HOPPER, (Comparable)Direction.SOUTH), grateModel.with(BlockModelGenerators.Y_ROT_180)).with(BlockModelGenerators.condition().term((Property)BlockStateProperties.FACING_HOPPER, (Comparable)Direction.WEST), grateModel.with(BlockModelGenerators.Y_ROT_270)));
    }

    public void addItemModels(ItemModelGenerators builder) {
        builder.generateFlatItem((Item)ModRegistry.GRATED_HOPPER_ITEM.value(), ModelTemplates.FLAT_ITEM);
        builder.generateFlatItem((Item)ModRegistry.CHUTE_ITEM.value(), ModelTemplates.FLAT_ITEM);
        builder.generateFlatItem((Item)ModRegistry.DUCT_ITEM.value(), ModelTemplates.FLAT_ITEM);
        builder.generateFlatItem((Item)ModRegistry.GRATED_HOPPER_MINECART_ITEM.value(), ModelTemplates.FLAT_ITEM);
        builder.generateFlatItem((Item)ModRegistry.CHUTE_MINECART_ITEM.value(), ModelTemplates.FLAT_ITEM);
    }
}

