/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hoppergadgetry.world.entity.vehicle;

import fuzs.hoppergadgetry.init.ModRegistry;
import fuzs.hoppergadgetry.world.inventory.GratedHopperMenu;
import fuzs.hoppergadgetry.world.level.block.entity.GratedHopperBlockEntity;
import fuzs.puzzleslib.api.container.v1.ContainerMenuHelper;
import fuzs.puzzleslib.api.container.v1.ContainerSerializationHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.vehicle.MinecartHopper;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class MinecartGratedHopper
extends MinecartHopper {
    private final NonNullList<ItemStack> filterItems = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);

    public MinecartGratedHopper(EntityType<? extends MinecartHopper> entityType, Level level) {
        super(entityType, level);
    }

    public BlockState getDefaultDisplayBlockState() {
        return ((Block)ModRegistry.GRATED_HOPPER_BLOCK.value()).defaultBlockState();
    }

    public boolean suckInItems() {
        if (GratedHopperBlockEntity.suckInItems(this.level(), (Hopper)this)) {
            return true;
        }
        for (ItemEntity itemEntity : this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate(0.25, 0.0, 0.25), EntitySelector.ENTITY_STILL_ALIVE)) {
            ItemStack itemStack = itemEntity.getItem();
            if (!this.canPlaceItem(0, itemStack) || !HopperBlockEntity.addItem((Container)this, (ItemEntity)itemEntity)) continue;
            return true;
        }
        return false;
    }

    public boolean canPlaceItem(int slot, ItemStack itemStack) {
        return GratedHopperBlockEntity.canPlaceItem(itemStack, this.filterItems);
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        ContainerSerializationHelper.storeAsSlots(this.filterItems, (ValueOutput.TypedOutputList)valueOutput.list(GratedHopperBlockEntity.TAG_FILTER, ItemStackWithSlot.CODEC));
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        ContainerSerializationHelper.fromSlots(this.filterItems, (ValueInput.TypedInputList)valueInput.listOrEmpty(GratedHopperBlockEntity.TAG_FILTER, ItemStackWithSlot.CODEC));
    }

    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory) {
        return new GratedHopperMenu(containerId, playerInventory, (Container)this, (Container)ContainerMenuHelper.createListBackedContainer(this.filterItems, (Container)this));
    }

    protected Item getDropItem() {
        return (Item)ModRegistry.GRATED_HOPPER_MINECART_ITEM.value();
    }

    public ItemStack getPickResult() {
        return ((Item)ModRegistry.GRATED_HOPPER_MINECART_ITEM.value()).getDefaultInstance();
    }
}

