/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.datagen;

import com.mrcrayfish.goblintraders.core.ModEntities;
import com.mrcrayfish.goblintraders.datagen.TradeProvider;
import com.mrcrayfish.goblintraders.trades.TradeCost;
import com.mrcrayfish.goblintraders.trades.TradeRarity;
import com.mrcrayfish.goblintraders.trades.type.BasicTrade;
import com.mrcrayfish.goblintraders.trades.type.TreasureMapTrade;
import com.mrcrayfish.goblintraders.util.Utils;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;

public class GoblinTradeProvider
extends TradeProvider {
    public GoblinTradeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider);
    }

    @Override
    public void registerTrades(HolderLookup.Provider provider) {
        this.registerGoblinTraderTrades(provider);
        this.registerVeinGoblinTraderTrades(provider);
    }

    private void registerGoblinTraderTrades(HolderLookup.Provider provider) {
        Item[] sherds;
        Item[] armorTrims;
        Item[] musicDiscs;
        HolderLookup.RegistryLookup enchantmentLookup = provider.lookupOrThrow(Registries.ENCHANTMENT);
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.EMERALD)).setPaymentStack(new TradeCost((ItemLike)Items.APPLE, 8)).setPriceMultiplier(0.0f).setMaxTrades(24).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.IRON_INGOT, 2)).setPaymentStack(new TradeCost((ItemLike)Items.RAW_IRON)).setPriceMultiplier(0.0f).setMaxTrades(30).setExperience(6).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.GOLD_INGOT, 3)).setPaymentStack(new TradeCost((ItemLike)Items.RAW_GOLD, 2)).setPriceMultiplier(0.0f).setMaxTrades(30).setExperience(6).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.COPPER_INGOT, 2)).setPaymentStack(new TradeCost((ItemLike)Items.RAW_COPPER, 1)).setPriceMultiplier(0.0f).setMaxTrades(30).setExperience(6).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.COAL)).setPaymentStack(new TradeCost((ItemLike)Items.ROTTEN_FLESH, 4)).setPriceMultiplier(0.0f).setMaxTrades(24).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.FLINT, 2)).setPaymentStack(new TradeCost((ItemLike)Items.GRAVEL)).setPriceMultiplier(0.0f).setMaxTrades(32).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.EMERALD)).setPaymentStack(new TradeCost((ItemLike)Items.COBBLESTONE, 22, 32)).setPriceMultiplier(0.0f).setMaxTrades(128).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.GUNPOWDER, 2)).setPaymentStack(new TradeCost((ItemLike)Items.EMERALD)).setPriceMultiplier(0.0f).setMaxTrades(32).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.EMERALD, 6)).setPaymentStack(new TradeCost((ItemLike)Items.TURTLE_EGG)).setPriceMultiplier(0.0f).setExperience(10).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.EMERALD, 8)).setPaymentStack(new TradeCost((ItemLike)Items.PUFFERFISH_BUCKET)).setPriceMultiplier(0.0f).setMaxTrades(4).setExperience(10).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.SPONGE)).setPaymentStack(new TradeCost((ItemLike)Items.EMERALD, 8)).setPriceMultiplier(0.0f).setExperience(10).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.ANVIL)).setPaymentStack(new TradeCost((ItemLike)Items.DAMAGED_ANVIL)).setSecondaryPaymentStack(new TradeCost((ItemLike)Items.IRON_INGOT, 2)).setPriceMultiplier(0.0f).setMaxTrades(2).setExperience(10).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.ANVIL)).setPaymentStack(new TradeCost((ItemLike)Items.CHIPPED_ANVIL)).setSecondaryPaymentStack(new TradeCost((ItemLike)Items.IRON_INGOT, 1)).setPriceMultiplier(0.0f).setMaxTrades(2).setExperience(10).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.TERRACOTTA, 2)).setPaymentStack(new TradeCost((ItemLike)Items.CLAY)).setPriceMultiplier(0.0f).setMaxTrades(64).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.BOOK, 2)).setPaymentStack(new TradeCost((ItemLike)Items.LEATHER)).setSecondaryPaymentStack(new TradeCost((ItemLike)Items.PAPER, 2, 3)).setPriceMultiplier(0.0f).setMaxTrades(32).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.EMERALD)).setPaymentStack(new TradeCost((ItemLike)Items.AMETHYST_SHARD, 2)).setPriceMultiplier(0.0f).setMaxTrades(20).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE)).setPaymentStack(new TradeCost((ItemLike)Items.EMERALD, 2, 3)).setPriceMultiplier(0.0f).setMaxTrades(64).setExperience(10).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.NAME_TAG)).setPaymentStack(new TradeCost((ItemLike)Items.EMERALD, 16)).setSecondaryPaymentStack(new TradeCost((ItemLike)Items.PAPER, 6, 8)).setPriceMultiplier(0.0f).setMaxTrades(2).setExperience(10).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.BLUE_ICE)).setPaymentStack(new TradeCost((ItemLike)Items.PACKED_ICE, 4)).setPriceMultiplier(0.0f).setMaxTrades(64).setExperience(10).build());
        for (Item disc : musicDiscs = new Item[]{Items.MUSIC_DISC_11, Items.MUSIC_DISC_13, Items.MUSIC_DISC_CAT, Items.MUSIC_DISC_BLOCKS, Items.MUSIC_DISC_FAR, Items.MUSIC_DISC_MALL, Items.MUSIC_DISC_MELLOHI, Items.MUSIC_DISC_STAL, Items.MUSIC_DISC_STRAD, Items.MUSIC_DISC_WARD, Items.MUSIC_DISC_WAIT, Items.MUSIC_DISC_OTHERSIDE, Items.MUSIC_DISC_RELIC, Items.MUSIC_DISC_PRECIPICE, Items.MUSIC_DISC_CREATOR, Items.MUSIC_DISC_CREATOR_MUSIC_BOX}) {
            this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)disc, 1)).setPaymentStack(new TradeCost((ItemLike)Items.EMERALD, 16, 28)).setPriceMultiplier(0.0f).setMaxTrades(1).setExperience(100).build());
        }
        for (Item item : armorTrims = new Item[]{Items.WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE, Items.RAISER_ARMOR_TRIM_SMITHING_TEMPLATE, Items.SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE, Items.HOST_ARMOR_TRIM_SMITHING_TEMPLATE, Items.WARD_ARMOR_TRIM_SMITHING_TEMPLATE, Items.SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE, Items.EYE_ARMOR_TRIM_SMITHING_TEMPLATE, Items.BOLT_ARMOR_TRIM_SMITHING_TEMPLATE, Items.FLOW_ARMOR_TRIM_SMITHING_TEMPLATE}) {
            this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)item)).setPaymentStack(new TradeCost((ItemLike)Items.EMERALD, 16, 28)).setPriceMultiplier(0.0f).setMaxTrades(1).setExperience(100).build());
        }
        for (Item item : sherds = new Item[]{Items.ANGLER_POTTERY_SHERD, Items.ARCHER_POTTERY_SHERD, Items.ARMS_UP_POTTERY_SHERD, Items.BLADE_POTTERY_SHERD, Items.BREWER_POTTERY_SHERD, Items.BURN_POTTERY_SHERD, Items.DANGER_POTTERY_SHERD, Items.EXPLORER_POTTERY_SHERD, Items.FLOW_POTTERY_SHERD, Items.FRIEND_POTTERY_SHERD, Items.GUSTER_POTTERY_SHERD, Items.HEART_POTTERY_SHERD, Items.HEARTBREAK_POTTERY_SHERD, Items.HOWL_POTTERY_SHERD, Items.MINER_POTTERY_SHERD, Items.MOURNER_POTTERY_SHERD, Items.PLENTY_POTTERY_SHERD, Items.PRIZE_POTTERY_SHERD, Items.SCRAPE_POTTERY_SHERD, Items.SHEAF_POTTERY_SHERD, Items.SHELTER_POTTERY_SHERD, Items.SKULL_POTTERY_SHERD, Items.SNORT_POTTERY_SHERD}) {
            this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)item)).setPaymentStack(new TradeCost((ItemLike)Items.BRICK, 1)).setSecondaryPaymentStack(new TradeCost((ItemLike)Items.EMERALD, 2, 4)).setPriceMultiplier(0.0f).setMaxTrades(1).setExperience(100).build());
        }
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.EPIC, BasicTrade.Builder.create().setOfferStack(GoblinTradeProvider.tuned(GoblinTradeProvider.durable(GoblinTradeProvider.moreArmour(new ItemStack((ItemLike)Items.CHAINMAIL_HELMET), EquipmentSlotGroup.HEAD)))).setPaymentStack(new TradeCost((ItemLike)Items.IRON_INGOT, 1, 3)).setSecondaryPaymentStack(new TradeCost((ItemLike)Items.EMERALD, 6, 14)).setMaxTrades(1).setExperience(150).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.EPIC, BasicTrade.Builder.create().setOfferStack(GoblinTradeProvider.tuned(GoblinTradeProvider.durable(GoblinTradeProvider.moreArmour(new ItemStack((ItemLike)Items.CHAINMAIL_CHESTPLATE), EquipmentSlotGroup.CHEST)))).setPaymentStack(new TradeCost((ItemLike)Items.IRON_INGOT, 1, 3)).setSecondaryPaymentStack(new TradeCost((ItemLike)Items.EMERALD, 6, 14)).setMaxTrades(1).setExperience(150).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.EPIC, BasicTrade.Builder.create().setOfferStack(GoblinTradeProvider.tuned(GoblinTradeProvider.durable(GoblinTradeProvider.moreArmour(new ItemStack((ItemLike)Items.CHAINMAIL_LEGGINGS), EquipmentSlotGroup.LEGS)))).setPaymentStack(new TradeCost((ItemLike)Items.IRON_INGOT, 1, 3)).setSecondaryPaymentStack(new TradeCost((ItemLike)Items.EMERALD, 6, 14)).setMaxTrades(1).setExperience(150).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.EPIC, BasicTrade.Builder.create().setOfferStack(GoblinTradeProvider.tuned(GoblinTradeProvider.durable(GoblinTradeProvider.moreArmour(new ItemStack((ItemLike)Items.CHAINMAIL_BOOTS), EquipmentSlotGroup.FEET)))).setPaymentStack(new TradeCost((ItemLike)Items.IRON_INGOT, 1, 3)).setSecondaryPaymentStack(new TradeCost((ItemLike)Items.EMERALD, 6, 14)).setMaxTrades(1).setExperience(150).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.EPIC, BasicTrade.Builder.create().setOfferStack(GoblinTradeProvider.tuned(GoblinTradeProvider.durable(GoblinTradeProvider.gravity(GoblinTradeProvider.nameItem(GoblinTradeProvider.glint(new ItemStack((ItemLike)Items.LEATHER_BOOTS)), (Component)Component.translatable((String)"custom.goblintraders.moon_boots")))))).setPaymentStack(new TradeCost((ItemLike)Items.APPLE, 8)).setSecondaryPaymentStack(new TradeCost((ItemLike)Items.EMERALD, 8, 32)).setMaxTrades(1).setExperience(150).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.EPIC, TreasureMapTrade.Builder.create().setStructure((TagKey<Structure>)TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)Utils.resource("on_mystery_maps"))).setMapDecoration((Holder<MapDecorationType>)MapDecorationTypes.TARGET_X).setName((Component)Component.translatable((String)"custom.goblintraders.mystery_map")).setPaymentStack(new TradeCost((ItemLike)Items.EMERALD, 8, 14)).setMaxTrades(1).setExperience(100).build());
        BuiltInRegistries.POTION.stream().forEach(potion -> {
            if (!potion.getEffects().isEmpty() && potion.getEffects().stream().allMatch(instance -> ((MobEffect)instance.getEffect().value()).getCategory() == MobEffectCategory.BENEFICIAL && instance.getDuration() <= 3600)) {
                this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.EPIC, BasicTrade.Builder.create().setOfferStack(PotionContents.createItemStack((Item)Items.POTION, (Holder)BuiltInRegistries.POTION.wrapAsHolder(potion))).setPaymentStack(new TradeCost((ItemLike)Items.EMERALD, 2)).setSecondaryPaymentStack(new TradeCost((ItemLike)Items.GLASS_BOTTLE, 1)).setMaxTrades(4).setExperience(50).build());
            }
        });
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.LEGENDARY, BasicTrade.Builder.create().setOfferStack(GoblinTradeProvider.tuned(GoblinTradeProvider.durable(GoblinTradeProvider.increaseReach(GoblinTradeProvider.breakSpeed(new ItemStack((ItemLike)Items.DIAMOND_PICKAXE)))))).setPaymentStack(new TradeCost((ItemLike)Items.NETHER_STAR, 1)).setSecondaryPaymentStack(new TradeCost((ItemLike)Items.DRAGON_HEAD, 1)).setMaxTrades(1).setExperience(300).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.LEGENDARY, BasicTrade.Builder.create().setOfferStack(GoblinTradeProvider.tuned(GoblinTradeProvider.durable(GoblinTradeProvider.increaseReach(GoblinTradeProvider.breakSpeed(new ItemStack((ItemLike)Items.DIAMOND_SHOVEL)))))).setPaymentStack(new TradeCost((ItemLike)Items.NETHER_STAR, 1)).setSecondaryPaymentStack(new TradeCost((ItemLike)Items.DRAGON_HEAD, 1)).setMaxTrades(1).setExperience(300).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.LEGENDARY, BasicTrade.Builder.create().setOfferStack(GoblinTradeProvider.tuned(GoblinTradeProvider.durable(GoblinTradeProvider.increaseReach(GoblinTradeProvider.moreDamage(GoblinTradeProvider.breakSpeed(new ItemStack((ItemLike)Items.DIAMOND_AXE))))))).setPaymentStack(new TradeCost((ItemLike)Items.NETHER_STAR, 1)).setSecondaryPaymentStack(new TradeCost((ItemLike)Items.DRAGON_HEAD, 1)).setMaxTrades(1).setExperience(300).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.LEGENDARY, BasicTrade.Builder.create().setOfferStack(GoblinTradeProvider.tuned(GoblinTradeProvider.durable(GoblinTradeProvider.increaseReach(new ItemStack((ItemLike)Items.DIAMOND_HOE))))).setPaymentStack(new TradeCost((ItemLike)Items.NETHER_STAR, 1)).setSecondaryPaymentStack(new TradeCost((ItemLike)Items.DRAGON_HEAD, 1)).setMaxTrades(1).setExperience(300).build());
        this.addTrade((EntityType)ModEntities.GOBLIN_TRADER.get(), TradeRarity.LEGENDARY, BasicTrade.Builder.create().setOfferStack(GoblinTradeProvider.tuned(GoblinTradeProvider.durable(new ItemStack((ItemLike)Items.ELYTRA)))).setPaymentStack(new TradeCost((ItemLike)Items.ELYTRA, 1)).setSecondaryPaymentStack(new TradeCost((ItemLike)Items.EMERALD, 24, 36)).setMaxTrades(1).setExperience(500).build());
    }

    private void registerVeinGoblinTraderTrades(HolderLookup.Provider provider) {
        Item[] musicDiscs;
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.EMERALD)).setPaymentStack(new TradeCost((ItemLike)Items.CARROT, 8)).setPriceMultiplier(0.0f).setMaxTrades(16).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.GLOWSTONE_DUST, 4)).setPaymentStack(new TradeCost((ItemLike)Items.GLOWSTONE)).setPriceMultiplier(0.0f).setMaxTrades(32).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.EMERALD, 1)).setPaymentStack(new TradeCost((ItemLike)Items.NETHERRACK, 48, 64)).setPriceMultiplier(0.0f).setMaxTrades(64).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.COMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.NETHER_WART, 2)).setPaymentStack(new TradeCost((ItemLike)Items.EMERALD)).setPriceMultiplier(0.0f).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.TOTEM_OF_UNDYING)).setPaymentStack(new TradeCost((ItemLike)Items.NETHERITE_INGOT, 2)).setPriceMultiplier(0.0f).setExperience(10).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.NETHERITE_SCRAP, 5)).setPaymentStack(new TradeCost((ItemLike)Items.ANCIENT_DEBRIS, 4)).setPriceMultiplier(0.0f).setMaxTrades(20).setExperience(50).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.RED_NETHER_BRICKS, 1)).setPaymentStack(new TradeCost((ItemLike)Items.NETHER_WART)).setSecondaryPaymentStack(new TradeCost((ItemLike)Items.NETHER_BRICK)).setPriceMultiplier(0.0f).setMaxTrades(128).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.EMERALD, 2)).setPaymentStack(new TradeCost((ItemLike)Items.GOLDEN_CARROT)).setPriceMultiplier(0.0f).setMaxTrades(8).setExperience(4).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.UNCOMMON, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE)).setPaymentStack(new TradeCost((ItemLike)Items.NETHER_QUARTZ_ORE)).setPriceMultiplier(0.0f).setMaxTrades(32).setExperience(3).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.WITHER_SKELETON_SKULL)).setPaymentStack(new TradeCost((ItemLike)Items.GOLDEN_CARROT, 8, 24)).setExperience(200).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE)).setPaymentStack(new TradeCost((ItemLike)Items.DIAMOND, 3, 9)).setMaxTrades(1).setExperience(100).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)Items.RIB_ARMOR_TRIM_SMITHING_TEMPLATE)).setPaymentStack(new TradeCost((ItemLike)Items.EMERALD, 24, 32)).setMaxTrades(1).setExperience(100).build());
        for (Item disc : musicDiscs = new Item[]{Items.MUSIC_DISC_PIGSTEP}) {
            this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.RARE, BasicTrade.Builder.create().setOfferStack(new ItemStack((ItemLike)disc, 1)).setPaymentStack(new TradeCost((ItemLike)Items.EMERALD, 24, 32)).setPriceMultiplier(0.0f).setMaxTrades(1).setExperience(100).build());
        }
        BuiltInRegistries.POTION.stream().forEach(potion -> {
            if (!potion.getEffects().isEmpty() && potion.getEffects().stream().allMatch(instance -> ((MobEffect)instance.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL && instance.getDuration() <= 3600)) {
                this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.EPIC, BasicTrade.Builder.create().setOfferStack(PotionContents.createItemStack((Item)Items.POTION, (Holder)BuiltInRegistries.POTION.wrapAsHolder(potion))).setPaymentStack(new TradeCost((ItemLike)Items.EMERALD, 2)).setSecondaryPaymentStack(new TradeCost((ItemLike)Items.GLASS_BOTTLE, 1)).setMaxTrades(4).setExperience(50).build());
            }
        });
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.LEGENDARY, BasicTrade.Builder.create().setOfferStack(GoblinTradeProvider.tuned(GoblinTradeProvider.durable(GoblinTradeProvider.oxygenBoost(GoblinTradeProvider.moreArmour(new ItemStack((ItemLike)Items.NETHERITE_HELMET), EquipmentSlotGroup.HEAD))))).setPaymentStack(new TradeCost((ItemLike)Items.NETHER_STAR, 2)).setSecondaryPaymentStack(new TradeCost((ItemLike)Items.DRAGON_HEAD, 1)).setMaxTrades(1).setExperience(300).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.LEGENDARY, BasicTrade.Builder.create().setOfferStack(GoblinTradeProvider.tuned(GoblinTradeProvider.durable(GoblinTradeProvider.moreArmour(new ItemStack((ItemLike)Items.NETHERITE_CHESTPLATE), EquipmentSlotGroup.CHEST)))).setPaymentStack(new TradeCost((ItemLike)Items.NETHER_STAR, 2)).setSecondaryPaymentStack(new TradeCost((ItemLike)Items.DRAGON_HEAD, 1)).setMaxTrades(1).setExperience(300).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.LEGENDARY, BasicTrade.Builder.create().setOfferStack(GoblinTradeProvider.tuned(GoblinTradeProvider.durable(GoblinTradeProvider.moreArmour(new ItemStack((ItemLike)Items.NETHERITE_LEGGINGS), EquipmentSlotGroup.LEGS)))).setPaymentStack(new TradeCost((ItemLike)Items.NETHER_STAR, 2)).setSecondaryPaymentStack(new TradeCost((ItemLike)Items.DRAGON_HEAD, 1)).setMaxTrades(1).setExperience(300).build());
        this.addTrade((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get(), TradeRarity.LEGENDARY, BasicTrade.Builder.create().setOfferStack(GoblinTradeProvider.tuned(GoblinTradeProvider.durable(GoblinTradeProvider.movementSpeed(GoblinTradeProvider.moreArmour(GoblinTradeProvider.bigStep(new ItemStack((ItemLike)Items.NETHERITE_BOOTS)), EquipmentSlotGroup.FEET))))).setPaymentStack(new TradeCost((ItemLike)Items.NETHER_STAR, 2)).setSecondaryPaymentStack(new TradeCost((ItemLike)Items.DRAGON_HEAD, 1)).setMaxTrades(1).setExperience(300).build());
    }

    private static ItemStack glint(ItemStack stack) {
        stack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
        return stack;
    }

    private static ItemStack gravity(ItemStack stack) {
        ItemAttributeModifiers modifiers = GoblinTradeProvider.getModifiers(stack);
        modifiers = modifiers.withModifierAdded(Attributes.GRAVITY, new AttributeModifier(Utils.resource("goblins_gravity"), -((Attribute)Attributes.GRAVITY.value()).getDefaultValue() * 0.835, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.FEET);
        modifiers = modifiers.withModifierAdded(Attributes.FALL_DAMAGE_MULTIPLIER, new AttributeModifier(Utils.resource("goblins_fall_damage"), -((Attribute)Attributes.FALL_DAMAGE_MULTIPLIER.value()).getDefaultValue() * 0.835, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.FEET);
        modifiers = modifiers.withModifierAdded(Attributes.SAFE_FALL_DISTANCE, new AttributeModifier(Utils.resource("goblins_safe_fall"), ((Attribute)Attributes.SAFE_FALL_DISTANCE.value()).getDefaultValue() * 5.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.FEET);
        stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)modifiers);
        return stack;
    }

    private static ItemStack tuned(ItemStack stack) {
        stack.set(DataComponents.RARITY, (Object)Rarity.EPIC);
        stack.set(DataComponents.LORE, (Object)((ItemLore)stack.getOrDefault(DataComponents.LORE, (Object)ItemLore.EMPTY)).withLineAdded((Component)Component.translatable((String)"custom.goblintraders.tuned").withStyle(ChatFormatting.GREEN)).withLineAdded((Component)Component.translatable((String)"custom.goblintraders.lore").withStyle(ChatFormatting.GRAY)));
        return stack;
    }

    private static ItemStack durable(ItemStack stack) {
        stack.set(DataComponents.MAX_DAMAGE, (Object)(stack.getMaxDamage() * 10));
        return stack;
    }

    private static ItemAttributeModifiers getModifiers(ItemStack stack) {
        ItemAttributeModifiers modifiers = (ItemAttributeModifiers)stack.get(DataComponents.ATTRIBUTE_MODIFIERS);
        if (modifiers != null && !modifiers.modifiers().isEmpty()) {
            return modifiers;
        }
        return ItemAttributeModifiers.EMPTY;
    }

    private static ItemStack moreDamage(ItemStack stack) {
        ItemAttributeModifiers modifiers = GoblinTradeProvider.getModifiers(stack);
        modifiers = modifiers.withModifierAdded(Attributes.ATTACK_DAMAGE, new AttributeModifier(Utils.resource("goblins_damage"), 3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        modifiers = modifiers.withModifierAdded(Attributes.ATTACK_KNOCKBACK, new AttributeModifier(Utils.resource("goblins_knockback"), 2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)modifiers);
        return stack;
    }

    private static ItemStack breakSpeed(ItemStack stack) {
        ItemAttributeModifiers modifiers = GoblinTradeProvider.getModifiers(stack);
        modifiers = modifiers.withModifierAdded(Attributes.BLOCK_BREAK_SPEED, new AttributeModifier(Utils.resource("goblins_break_speed"), 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)modifiers);
        return stack;
    }

    private static ItemStack increaseReach(ItemStack stack) {
        ItemAttributeModifiers modifiers = GoblinTradeProvider.getModifiers(stack);
        modifiers = modifiers.withModifierAdded(Attributes.BLOCK_INTERACTION_RANGE, new AttributeModifier(Utils.resource("goblins_block_range"), 2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)modifiers);
        return stack;
    }

    private static ItemStack movementSpeed(ItemStack stack) {
        ItemAttributeModifiers modifiers = GoblinTradeProvider.getModifiers(stack);
        modifiers = modifiers.withModifierAdded(Attributes.MOVEMENT_SPEED, new AttributeModifier(Utils.resource("goblins_movement"), 0.02, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.FEET);
        stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)modifiers);
        return stack;
    }

    private static ItemStack moreArmour(ItemStack stack, EquipmentSlotGroup group) {
        ItemAttributeModifiers modifiers = GoblinTradeProvider.getModifiers(stack);
        modifiers = modifiers.withModifierAdded(Attributes.ARMOR, new AttributeModifier(Utils.resource("goblins_armour"), 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), group);
        stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)modifiers);
        return stack;
    }

    private static ItemStack oxygenBoost(ItemStack stack) {
        ItemAttributeModifiers modifiers = GoblinTradeProvider.getModifiers(stack);
        modifiers = modifiers.withModifierAdded(Attributes.OXYGEN_BONUS, new AttributeModifier(Utils.resource("goblins_oxygen_boost"), 5.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HEAD);
        stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)modifiers);
        return stack;
    }

    private static ItemStack bigStep(ItemStack stack) {
        ItemAttributeModifiers modifiers = GoblinTradeProvider.getModifiers(stack);
        modifiers = modifiers.withModifierAdded(Attributes.STEP_HEIGHT, new AttributeModifier(Utils.resource("goblins_big_step"), 0.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.FEET);
        modifiers = modifiers.withModifierAdded(Attributes.SAFE_FALL_DISTANCE, new AttributeModifier(Utils.resource("goblins_fall_distance"), 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), EquipmentSlotGroup.FEET);
        stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)modifiers);
        return stack;
    }

    private static ItemStack nameItem(ItemStack stack, Component name) {
        stack.set(DataComponents.ITEM_NAME, (Object)name);
        return stack;
    }

    private static ItemStack createEnchantedItem(ItemLike item, int count, Consumer<ItemEnchantments.Mutable> consumer) {
        ItemStack stack = new ItemStack(item, count);
        EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)GoblinTradeProvider.createItemEnchantments(consumer));
        return stack;
    }

    private static TradeCost createEnchantedBookCost(Consumer<ItemEnchantments.Mutable> consumer) {
        return new TradeCost((ItemLike)Items.ENCHANTED_BOOK, 1, GoblinTradeProvider.createComponentPredicate(builder -> builder.expect(DataComponents.STORED_ENCHANTMENTS, (Object)GoblinTradeProvider.createItemEnchantments(consumer))));
    }

    private static DataComponentExactPredicate createComponentPredicate(Consumer<DataComponentExactPredicate.Builder> consumer) {
        DataComponentExactPredicate.Builder builder = DataComponentExactPredicate.builder();
        consumer.accept(builder);
        return builder.build();
    }

    private static ItemEnchantments createItemEnchantments(Consumer<ItemEnchantments.Mutable> consumer) {
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        consumer.accept(mutable);
        return mutable.toImmutable();
    }
}

