/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.entity;

import com.mrcrayfish.goblintraders.Config;
import com.mrcrayfish.goblintraders.core.ModSounds;
import com.mrcrayfish.goblintraders.entity.GoblinRotationControl;
import com.mrcrayfish.goblintraders.entity.TraderCreatureEntity;
import com.mrcrayfish.goblintraders.entity.ai.goal.AttackRevengeTargetGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.EatFavouriteFoodGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.FindFavouriteFoodGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.FirePanicGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.FollowPotentialCustomerGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.GoblinTemptGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.LookAtCustomerGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.SitAndLookGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.TradeWithPlayerGoal;
import com.mrcrayfish.goblintraders.inventory.GoblinMerchantMenu;
import com.mrcrayfish.goblintraders.trades.GoblinOffers;
import com.mrcrayfish.goblintraders.trades.type.BaseTrade;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGoblinEntity
extends TraderCreatureEntity
implements Npc {
    public static final EntityDataAccessor<Boolean> STUNNED = SynchedEntityData.defineId(AbstractGoblinEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Float> STUN_ROTATION = SynchedEntityData.defineId(AbstractGoblinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(AbstractGoblinEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> CURIOUS = SynchedEntityData.defineId(AbstractGoblinEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @Nullable
    private Player customer;
    @Nullable
    private MerchantOffers offers;
    private final Set<UUID> tradedCustomers = new HashSet<UUID>();
    private int stunDelay;
    private int despawnDelay = -1;
    private int fallCounter;
    private int restockDelay;
    private float headTilt;
    private float headTiltO;
    private float armAngle;
    private float armAngleO;
    private int curiousTime;

    protected AbstractGoblinEntity(EntityType<? extends TraderCreatureEntity> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new FirePanicGoal(this, 1.3));
        this.goalSelector.addGoal(2, (Goal)new TradeWithPlayerGoal(this));
        this.goalSelector.addGoal(3, (Goal)new LookAtCustomerGoal(this));
        this.goalSelector.addGoal(4, (Goal)new AttackRevengeTargetGoal(this));
        this.goalSelector.addGoal(5, (Goal)new EatFavouriteFoodGoal(this));
        this.goalSelector.addGoal(6, (Goal)new FindFavouriteFoodGoal(this));
        this.goalSelector.addGoal(7, (Goal)new GoblinTemptGoal(this, 1.0, stack -> stack.is(this.getFavouriteFood().getItem()), false));
        this.goalSelector.addGoal(8, (Goal)new FollowPotentialCustomerGoal(this));
        this.goalSelector.addGoal(9, (Goal)new SitAndLookGoal(this));
        this.goalSelector.addGoal(10, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(11, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(12, (Goal)new InteractGoal((Mob)this, Player.class, 4.0f, 1.0f));
        this.goalSelector.addGoal(13, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    protected void updateControlFlags() {
        super.updateControlFlags();
        if (this.isStunned()) {
            this.goalSelector.setControlFlag(Goal.Flag.MOVE, true);
            this.goalSelector.setControlFlag(Goal.Flag.JUMP, true);
            this.goalSelector.setControlFlag(Goal.Flag.LOOK, true);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STUNNED, (Object)false);
        builder.define(STUN_ROTATION, (Object)Float.valueOf(0.0f));
        builder.define(SITTING, (Object)false);
        builder.define(CURIOUS, (Object)false);
    }

    public abstract ResourceLocation getTexture();

    public int getFallCounter() {
        return this.fallCounter;
    }

    public void baseTick() {
        this.headTiltO = this.headTilt;
        this.armAngleO = this.armAngle;
        if (this.despawnDelay > 0) {
            --this.despawnDelay;
        }
        super.baseTick();
        this.updateSwingTime();
        if (this.stunDelay > 0) {
            --this.stunDelay;
            if (this.stunDelay == 0 && this.isAlive()) {
                this.entityData.set(STUNNED, (Object)false);
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)ModSounds.ENTITY_GOBLIN_TRADER_ANNOYED_GRUNT.get(), SoundSource.NEUTRAL, 1.0f, 0.9f + this.getRandom().nextFloat() * 0.2f);
            }
        }
        if (((Boolean)this.entityData.get(STUNNED)).booleanValue()) {
            if (this.fallCounter < 10) {
                ++this.fallCounter;
            }
        } else {
            this.fallCounter = 0;
        }
        if (!this.level().isClientSide() && this.getMaxRestockDelay() != -1 && ++this.restockDelay >= this.getMaxRestockDelay()) {
            this.getOffers().forEach(MerchantOffer::resetUses);
            this.restockDelay = 0;
            this.resendOffers();
        }
        if (!this.level().isClientSide() && --this.curiousTime <= 0) {
            this.setCurious(false);
        }
        float targetTilt = this.isCurious() ? 20.0f : 0.0f;
        this.headTilt = Mth.lerp((float)0.35f, (float)this.headTilt, (float)targetTilt);
        float targetAngle = this.getTargetArmAngle();
        this.armAngle = Mth.lerp((float)0.35f, (float)this.armAngle, (float)targetAngle);
    }

    private void resendOffers() {
        MerchantOffers offers = this.getOffers();
        Player player = this.getTradingPlayer();
        if (player != null && !offers.isEmpty()) {
            player.sendMerchantOffers(player.containerMenu.containerId, offers, 0, 0, false, this.canRestock());
        }
    }

    public void setTradingPlayer(@Nullable Player player) {
        this.customer = player;
    }

    @Nullable
    public Player getTradingPlayer() {
        return this.customer;
    }

    public boolean hasCustomer() {
        return this.customer != null;
    }

    public MerchantOffers getOffers() {
        if (this.offers == null) {
            this.offers = new GoblinOffers();
            this.populateTradeData();
        }
        return this.offers;
    }

    protected abstract void populateTradeData();

    protected void addTrades(MerchantOffers offers, @Nullable List<BaseTrade> trades, int max, boolean shuffle) {
        if (trades == null) {
            return;
        }
        List randomIndexes = IntStream.range(0, trades.size()).boxed().collect(Collectors.toList());
        if (shuffle) {
            Collections.shuffle(randomIndexes);
        }
        randomIndexes = randomIndexes.subList(0, Math.min(trades.size(), max));
        for (Integer index : randomIndexes) {
            BaseTrade trade = trades.get(index);
            MerchantOffer offer = trade.createVanillaOffer(this, this.getRandom());
            if (offer == null) continue;
            offers.add((Object)offer);
        }
    }

    public void openTradingScreen(Player player, Component title, int level) {
        MerchantOffers offers;
        OptionalInt id = player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, player1) -> new GoblinMerchantMenu(windowId, playerInventory, this), title));
        if (id.isPresent() && !(offers = this.getOffers()).isEmpty()) {
            player.sendMerchantOffers(id.getAsInt(), offers, level, 0, false, this.canRestock());
        }
    }

    public boolean canRestock() {
        return true;
    }

    public void overrideOffers(@Nullable MerchantOffers offers) {
    }

    public void notifyTrade(MerchantOffer offer) {
        Level level;
        offer.increaseUses();
        if (this.customer != null) {
            this.tradedCustomers.add(this.customer.getUUID());
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ExperienceOrb.award((ServerLevel)serverLevel, (Vec3)this.getPosition(1.0f), (int)offer.getXp());
        }
    }

    public void notifyTradeUpdated(ItemStack stack) {
    }

    public boolean isClientSide() {
        return this.level().isClientSide();
    }

    public int getVillagerXp() {
        return 0;
    }

    public void overrideXp(int xpIn) {
    }

    public boolean showProgressBar() {
        return false;
    }

    public SoundEvent getNotifyTradeSound() {
        return SoundEvents.VILLAGER_YES;
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (heldItem.getItem() == Items.NAME_TAG) {
            InteractionResult result = heldItem.interactLivingEntity(player, (LivingEntity)this, hand);
            if (result.consumesAction()) {
                this.clearHome();
            }
            return result;
        }
        if (this.getFavouriteFood().is(heldItem.getItem())) {
            if (this.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty()) {
                this.setItemSlot(EquipmentSlot.MAINHAND, heldItem.copyWithCount(1));
                heldItem.shrink(1);
                return InteractionResult.SUCCESS;
            }
        } else if (!(!this.isAlive() || this.hasCustomer() || this.isBaby() || !this.fireImmune() && this.isOnFire() || this.isStunned())) {
            if (this.getOffers().isEmpty()) {
                return InteractionResult.PASS;
            }
            if (!(this.isClientSide() || this.getLastHurtByMob() != null && this.getLastHurtByMob() == player)) {
                this.setTradingPlayer(player);
                this.openTradingScreen(player, Objects.requireNonNull(this.getDisplayName()), 1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    protected void spawnFoodParticles(ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 frontPosition = Vec3.directionFromRotation((float)0.0f, (float)this.yBodyRot).scale(0.25);
            frontPosition = frontPosition.add(0.0, 0.35, 0.0);
            frontPosition = frontPosition.add(this.position());
            Vec3 motion = new Vec3(this.getRandom().nextDouble() * 0.2 - 0.1, 0.1, this.getRandom().nextDouble() * 0.2 - 0.1);
            this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), frontPosition.x, frontPosition.y, frontPosition.z, motion.x, motion.y + 0.05, motion.z);
        }
    }

    public boolean isPreviousCustomer(Player player) {
        return this.tradedCustomers.contains(player.getUUID());
    }

    public boolean hurtServer(ServerLevel level, DamageSource source, float amount) {
        boolean attacked = super.hurtServer(level, source, amount);
        if (attacked) {
            this.stopUsingItem();
            this.setCurious(false);
            this.setSitting(false);
            if (source.getEntity() instanceof Player) {
                this.getNavigation().stop();
                this.entityData.set(STUNNED, (Object)true);
                this.entityData.set(STUN_ROTATION, (Object)Float.valueOf(this.getStunRotation(source.getEntity())));
                this.goalSelector.getAvailableGoals().forEach(WrappedGoal::stop);
                this.stunDelay = 20;
            }
        }
        return attacked;
    }

    private float getStunRotation(@Nullable Entity entity) {
        return entity != null ? entity.getYRot() : 0.0f;
    }

    public void setDespawnDelay(int despawnDelay) {
        this.despawnDelay = despawnDelay;
    }

    public void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        input.read("Offers", GoblinOffers.CODEC).ifPresent(offers -> {
            this.offers = new GoblinOffers((MerchantOffers)offers);
        });
        input.getInt("DespawnDelay").ifPresent(delay -> {
            this.despawnDelay = delay;
        });
        input.getInt("RestockDelay").ifPresent(delay -> {
            this.restockDelay = delay;
        });
        input.list("TradedCustomers", UUIDUtil.CODEC).ifPresent(uuids -> {
            this.tradedCustomers.clear();
            uuids.forEach(this.tradedCustomers::add);
        });
    }

    public void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        MerchantOffers offers = this.getOffers();
        output.store("Offers", GoblinOffers.CODEC, (Object)offers);
        output.putInt("DespawnDelay", this.despawnDelay);
        output.putInt("RestockDelay", this.restockDelay);
        ValueOutput.TypedOutputList uuids = output.list("TradedCustomers", UUIDUtil.CODEC);
        this.tradedCustomers.forEach(arg_0 -> ((ValueOutput.TypedOutputList)uuids).add(arg_0));
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.ENTITY_GOBLIN_TRADER_IDLE_GRUNT.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)ModSounds.ENTITY_GOBLIN_TRADER_IDLE_GRUNT.get();
    }

    public abstract ItemStack getFavouriteFood();

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.TEMPT_RANGE, 10.0);
    }

    public boolean isStunned() {
        return (Boolean)this.entityData.get(STUNNED);
    }

    public float getStunRotation() {
        return ((Float)this.entityData.get(STUN_ROTATION)).floatValue();
    }

    protected abstract int getMaxRestockDelay();

    public abstract boolean canAttackBack();

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mob) {
        return null;
    }

    public void setSitting(boolean sitting) {
        this.entityData.set(SITTING, (Object)sitting);
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(SITTING);
    }

    public void setCurious(boolean curious) {
        this.entityData.set(CURIOUS, (Object)curious);
        this.curiousTime = curious ? 100 : 0;
    }

    public void resetCurious() {
        this.entityData.set(CURIOUS, (Object)false);
        this.curiousTime = 0;
    }

    public boolean isCurious() {
        return (Boolean)this.entityData.get(CURIOUS);
    }

    protected float getMaxHeadRotationRelativeToBody() {
        return 90.0f;
    }

    protected BodyRotationControl createBodyControl() {
        return new GoblinRotationControl(this);
    }

    public float getHeadTilt(float partial) {
        return Mth.lerp((float)partial, (float)this.headTiltO, (float)this.headTilt);
    }

    public double getEyeY() {
        return !this.isSitting() ? super.getEyeY() : super.getEyeY() - 0.17;
    }

    public float getArmAngle(float partial) {
        return Mth.lerp((float)partial, (float)this.armAngleO, (float)this.armAngle);
    }

    private float getTargetArmAngle() {
        if (this.isCurious() && !this.isSitting()) {
            return 110.0f;
        }
        if (!this.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty()) {
            return 80.0f;
        }
        return 0.0f;
    }

    public void die(DamageSource source) {
        super.die(source);
        this.setTradingPlayer(null);
    }

    @Nullable
    public Entity teleport(TeleportTransition transition) {
        this.setTradingPlayer(null);
        return super.teleport(transition);
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)this.getEyeHeight() - 0.25, 0.0);
    }

    public void setLeashedTo(Entity entity, boolean broadcast) {
        super.setLeashedTo(entity, broadcast);
        this.clearHome();
    }

    public boolean requiresCustomPersistence() {
        if (((Boolean)Config.ENTITIES.preventDespawnIfNamed.get()).booleanValue() && this.hasCustomName()) {
            return true;
        }
        if (this.hasCustomer() || this.despawnDelay != 0) {
            return true;
        }
        if (this.isLeashed()) {
            return true;
        }
        return super.requiresCustomPersistence();
    }

    public boolean stillValid(Player player) {
        return this.getTradingPlayer() == player && this.isAlive() && player.canInteractWithEntity((Entity)this, 4.0);
    }

    public void spawnItemParticles(ItemStack stack, int count) {
        this.spawnFoodParticles(stack, count);
    }
}

