/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen.noise;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.biome.Biome;
import terrablender.api.Region;
import terrablender.api.RegionType;
import terrablender.api.Regions;
import terrablender.util.WeightedEntry;
import terrablender.worldgen.noise.WeightedRandomLayer;

public class InitialLayer
extends WeightedRandomLayer<WeightedEntry.Wrapper<Region>> {
    private final RegionType regionType;

    public InitialLayer(RegistryAccess registryAccess, RegionType regionType) {
        super(InitialLayer.createEntries(registryAccess, regionType));
        this.regionType = regionType;
    }

    @Override
    protected int getEntryIndex(WeightedEntry.Wrapper<Region> entry) {
        return Regions.getIndex(this.regionType, entry.data().getName());
    }

    private static List<WeightedEntry.Wrapper<Region>> createEntries(RegistryAccess registryAccess, RegionType regionType) {
        Registry biomeRegistry = registryAccess.lookupOrThrow(Registries.BIOME);
        return (List)Regions.get(regionType).stream().filter(region -> {
            AtomicBoolean biomesAdded = new AtomicBoolean(false);
            region.addBiomes((Registry<Biome>)biomeRegistry, pair -> biomesAdded.set(true));
            return region.getType() == regionType && biomesAdded.get();
        }).map(region -> WeightedEntry.wrap(region, region.getWeight())).collect(ImmutableList.toImmutableList());
    }
}

