/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.networking;

import dev.architectury.extensions.network.EntitySpawnExtension;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class SpawnEntityPacket {
    private static final ResourceLocation PACKET_ID = ResourceLocation.fromNamespaceAndPath((String)"architectury", (String)"spawn_entity_packet");
    private static final CustomPacketPayload.Type<PacketPayload> PACKET_TYPE = new CustomPacketPayload.Type(PACKET_ID);
    private static final StreamCodec<RegistryFriendlyByteBuf, PacketPayload> PACKET_CODEC = CustomPacketPayload.codec(PacketPayload::write, PacketPayload::new);

    public static Packet<ClientGamePacketListener> create(Entity entity, ServerEntity serverEntity) {
        if (entity.level().isClientSide()) {
            throw new IllegalStateException("SpawnPacketUtil.create called on the logical client!");
        }
        return NetworkManager.toPacket(NetworkManager.s2c(), new PacketPayload(entity, serverEntity), entity.registryAccess());
    }

    public static void register() {
        NetworkManager.registerS2CPayloadType(PACKET_TYPE, PACKET_CODEC);
    }

    private record PacketPayload(EntityType<?> entityType, UUID uuid, int id, double x, double y, double z, float xRot, float yRot, float yHeadRot, double deltaX, double deltaY, double deltaZ, byte[] data) implements CustomPacketPayload
    {
        public PacketPayload(RegistryFriendlyByteBuf buf) {
            this((EntityType)ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE).decode((Object)buf), buf.readUUID(), buf.readVarInt(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readByteArray());
        }

        public PacketPayload(Entity entity, ServerEntity serverEntity) {
            this(entity.getType(), entity.getUUID(), entity.getId(), serverEntity.getPositionBase().x(), serverEntity.getPositionBase().y(), serverEntity.getPositionBase().z(), serverEntity.getLastSentXRot(), serverEntity.getLastSentYRot(), serverEntity.getLastSentYHeadRot(), serverEntity.getLastSentMovement().x, serverEntity.getLastSentMovement().y, serverEntity.getLastSentMovement().z, PacketPayload.saveExtra(entity));
        }

        public PacketPayload(Entity entity, BlockPos pos) {
            this(entity.getType(), entity.getUUID(), entity.getId(), pos.getX(), pos.getY(), pos.getZ(), entity.getXRot(), entity.getYRot(), entity.getYHeadRot(), entity.getDeltaMovement().x, entity.getDeltaMovement().y, entity.getDeltaMovement().z, PacketPayload.saveExtra(entity));
        }

        private static byte[] saveExtra(Entity entity) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            try {
                if (entity instanceof EntitySpawnExtension) {
                    EntitySpawnExtension ext = (EntitySpawnExtension)entity;
                    ext.saveAdditionalSpawnData(buf);
                }
                byte[] byArray = ByteBufUtil.getBytes((ByteBuf)buf);
                return byArray;
            }
            finally {
                buf.release();
            }
        }

        public void write(RegistryFriendlyByteBuf buf) {
            ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE).encode((Object)buf, this.entityType);
            buf.writeUUID(this.uuid);
            buf.writeVarInt(this.id);
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
            buf.writeFloat(this.xRot);
            buf.writeFloat(this.yRot);
            buf.writeFloat(this.yHeadRot);
            buf.writeDouble(this.deltaX);
            buf.writeDouble(this.deltaY);
            buf.writeDouble(this.deltaZ);
            buf.writeByteArray(this.data);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_TYPE;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client {
        @OnlyIn(value=Dist.CLIENT)
        public static void register() {
            NetworkManager.registerReceiver(NetworkManager.s2c(), PACKET_TYPE, PACKET_CODEC, Client::receive);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void receive(PacketPayload payload, NetworkManager.PacketContext context) {
            context.queue(() -> {
                if (Minecraft.getInstance().level == null) {
                    throw new IllegalStateException("Client world is null!");
                }
                Entity entity = payload.entityType().create((Level)Minecraft.getInstance().level, EntitySpawnReason.LOAD);
                if (entity == null) {
                    throw new IllegalStateException("Created entity is null!");
                }
                entity.setUUID(payload.uuid());
                entity.setId(payload.id());
                entity.syncPacketPositionCodec(payload.x(), payload.y(), payload.z());
                entity.snapTo(payload.x(), payload.y(), payload.z(), payload.xRot(), payload.yRot());
                entity.setYHeadRot(payload.yHeadRot());
                entity.setYBodyRot(payload.yHeadRot());
                if (entity instanceof EntitySpawnExtension) {
                    EntitySpawnExtension ext = (EntitySpawnExtension)entity;
                    RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])payload.data()), context.registryAccess());
                    ext.loadAdditionalSpawnData((FriendlyByteBuf)buf);
                    buf.release();
                }
                Minecraft.getInstance().level.addEntity(entity);
                entity.lerpMotion(payload.deltaX(), payload.deltaY(), payload.deltaZ());
            });
        }
    }
}

