/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.electricity.wire;

import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.antarcticgardens.cna.CNADataComponents;
import org.antarcticgardens.cna.config.CNAConfig;
import org.antarcticgardens.cna.content.electricity.connector.ElectricalConnectorBlockEntity;
import org.antarcticgardens.cna.content.electricity.wire.WireType;
import org.jetbrains.annotations.NotNull;

public class ElectricWireItem
extends Item {
    private final WireType wireType;

    public ElectricWireItem(Item.Properties properties, WireType wireType) {
        super(properties);
        this.wireType = wireType;
    }

    public static ElectricWireItem newCopperWire(Item.Properties properties) {
        return new ElectricWireItem(properties, WireType.COPPER);
    }

    public static ElectricWireItem newIronWire(Item.Properties properties) {
        return new ElectricWireItem(properties, WireType.OVERCHARGED_IRON);
    }

    public static ElectricWireItem newGoldenWire(Item.Properties properties) {
        return new ElectricWireItem(properties, WireType.OVERCHARGED_GOLD);
    }

    public static ElectricWireItem newDiamondWire(Item.Properties properties) {
        return new ElectricWireItem(properties, WireType.OVERCHARGED_DIAMOND);
    }

    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, InteractionHand usedHand) {
        ItemStack item = player.getItemInHand(usedHand);
        BlockPos boundToPos = this.getBoundConnector(item);
        if (boundToPos != null && player.isShiftKeyDown()) {
            this.playUnboundSound((Entity)player);
            player.displayClientMessage((Component)Component.translatable((String)"item.create_new_age.wire.message.unbound"), true);
            item.remove(CNADataComponents.BOUND_TO);
            return InteractionResultHolder.success((Object)item);
        }
        return InteractionResultHolder.pass((Object)item);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (isSelected) {
            BlockPos boundToPos = this.getBoundConnector(stack);
            if (boundToPos == null) {
                return;
            }
            if (!(level.getBlockEntity(boundToPos) instanceof ElectricalConnectorBlockEntity)) {
                stack.remove(CNADataComponents.BOUND_TO);
            }
            int maxLength = (Integer)CNAConfig.getCommon().maxWireLength.get();
            if (entity.distanceToSqr((double)boundToPos.getX(), (double)boundToPos.getY(), (double)boundToPos.getZ()) > (double)(maxLength * maxLength * 3)) {
                stack.remove(CNADataComponents.BOUND_TO);
                this.playUnboundSound(entity);
                if (entity instanceof Player) {
                    Player pl = (Player)entity;
                    pl.displayClientMessage((Component)Component.translatable((String)"item.create_new_age.wire.message.too_far", (Object[])new Object[]{maxLength}), true);
                }
            }
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity clickedEntity = context.getLevel().getBlockEntity(context.getClickedPos());
        BlockPos boundToPos = this.getBoundConnector(context.getItemInHand());
        if (clickedEntity instanceof ElectricalConnectorBlockEntity) {
            ElectricalConnectorBlockEntity clickedConnector = (ElectricalConnectorBlockEntity)clickedEntity;
            if (boundToPos == null) {
                this.setBoundConnector(context.getItemInHand(), clickedConnector);
                this.playBoundSound((Entity)context.getPlayer());
                return InteractionResult.SUCCESS;
            }
            BlockPos clickedPos = clickedConnector.getBlockPos();
            int maxLength = (Integer)CNAConfig.getCommon().maxWireLength.get();
            if (boundToPos.equals((Object)clickedPos)) {
                context.getPlayer().displayClientMessage((Component)Component.translatable((String)"item.create_new_age.wire.message.self_connect"), true);
                context.getItemInHand().remove(CNADataComponents.BOUND_TO);
                return InteractionResult.FAIL;
            }
            if (clickedPos.distSqr((Vec3i)boundToPos) > (double)Mth.square((int)maxLength)) {
                context.getPlayer().displayClientMessage((Component)Component.translatable((String)"item.create_new_age.wire.message.too_far", (Object[])new Object[]{maxLength}), true);
                return InteractionResult.FAIL;
            }
            if (clickedConnector.isConnected(boundToPos)) {
                context.getPlayer().displayClientMessage((Component)Component.translatable((String)"item.create_new_age.wire.message.already_connected"), true);
                context.getItemInHand().remove(CNADataComponents.BOUND_TO);
                return InteractionResult.FAIL;
            }
            BlockEntity boundToEntity = context.getLevel().getBlockEntity(boundToPos);
            if (boundToEntity instanceof ElectricalConnectorBlockEntity) {
                ElectricalConnectorBlockEntity boundToConnector = (ElectricalConnectorBlockEntity)boundToEntity;
                context.getItemInHand().remove(CNADataComponents.BOUND_TO);
                boundToConnector.connect(clickedConnector, this.wireType);
                if (!context.getPlayer().isCreative()) {
                    context.getItemInHand().shrink(1);
                }
                this.playBoundSound((Entity)context.getPlayer());
                context.getPlayer().displayClientMessage((Component)Component.translatable((String)"item.create_new_age.wire.message.connected"), true);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    private void playBoundSound(Entity entity) {
        entity.playSound(SoundEvents.LEASH_KNOT_PLACE, 1.0f, 1.0f);
    }

    private void playUnboundSound(Entity entity) {
        entity.playSound(SoundEvents.LEASH_KNOT_BREAK, 1.0f, 1.0f);
    }

    public BlockPos getBoundConnector(ItemStack stack) {
        return (BlockPos)stack.get(CNADataComponents.BOUND_TO);
    }

    public WireType getWireType() {
        return this.wireType;
    }

    private void setBoundConnector(ItemStack stack, ElectricalConnectorBlockEntity connector) {
        stack.set(CNADataComponents.BOUND_TO, (Object)connector.getBlockPos());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)CreateLang.translate((String)"tooltip.create_new_age.transfers", (Object[])new Object[0]).style(ChatFormatting.GRAY).component());
        tooltipComponents.add((Component)CreateLang.text((String)" ").translate("tooltip.create_new_age.energy_per_tick", new Object[]{String.format("%,d", this.wireType.getConductivity())}).style(ChatFormatting.AQUA).component());
    }
}

