/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.nuclear;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.antarcticgardens.cna.CNATags;
import org.antarcticgardens.cna.util.RaycastUtil;

public class NuclearUtil {
    public static void createRadiation(int length, Level world, BlockPos pos) {
        if (world.isClientSide()) {
            return;
        }
        List entities = world.getEntities(EntityTypeTest.forClass(LivingEntity.class), new AABB(pos).inflate((double)length), livingEntity -> !NuclearUtil.isResistant(livingEntity));
        block0: for (LivingEntity le : entities) {
            for (Direction dir : Direction.values()) {
                BlockHitResult bhr;
                Vec3 direction;
                HitResult hitResult;
                if (world.getBlockState(pos.relative(dir)).is(CNATags.Block.STOPS_RADIATION.blockTag)) continue;
                Vec3 start = pos.getCenter().relative(dir, 0.5);
                double distance = le.getEyePosition().distanceTo(start);
                if (distance > (double)length || (hitResult = RaycastUtil.pickFilteredBlockFromPos(world, start, direction = le.getEyePosition().subtract(start).normalize(), (float)Math.ceil(distance), bs -> bs.is(CNATags.Block.STOPS_RADIATION.blockTag))) instanceof BlockHitResult && (world.getBlockState((bhr = (BlockHitResult)hitResult).getBlockPos()).is(CNATags.Block.STOPS_RADIATION.blockTag) || bhr.getLocation().distanceTo(start) < distance)) continue;
                NuclearUtil.irradiate(le);
                continue block0;
            }
        }
    }

    private static boolean isResistant(LivingEntity entity) {
        Player pl;
        if (entity instanceof Player && ((pl = (Player)entity).isCreative() || pl.isSpectator())) {
            return true;
        }
        for (ItemStack piece : entity.getArmorSlots()) {
            if (piece.is(CNATags.Item.HAZMAT_SUIT.tag)) continue;
            return false;
        }
        return true;
    }

    private static void irradiate(LivingEntity entity) {
        entity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 400, 1));
        entity.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 1));
        entity.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 300, 1));
        entity.addEffect(new MobEffectInstance(MobEffects.WITHER, 80, 1));
    }
}

