/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.neoforge;

import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.antarcticgardens.cna.CNABlocks;
import org.antarcticgardens.cna.CNADataComponents;
import org.antarcticgardens.cna.CreateNewAge;
import org.antarcticgardens.cna.platform.PlatformRegistrar;

public class NeoForgeRegistrar
implements PlatformRegistrar {
    private static final DeferredRegister<CreativeModeTab> TAB_REGISTER = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"create_new_age");
    private static final DeferredRegister<RecipeType<?>> RECIPE_TYPE_REGISTER = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)"create_new_age");
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZER_REGISTER = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"create_new_age");

    @Override
    public void registerConfig(ModConfig.Type type, IConfigSpec spec) {
        ModLoadingContext.get().getActiveContainer().registerConfig(type, spec);
    }

    @Override
    public RecipeType<?> registerRecipe(String name, RecipeSerializer<?> serializer) {
        RecipeType type = new RecipeType(this){};
        RECIPE_TYPE_REGISTER.register(name, () -> type);
        RECIPE_SERIALIZER_REGISTER.register(name, () -> serializer);
        return type;
    }

    @Override
    public void beforeRegistration() {
        IEventBus eventBus = Objects.requireNonNull(ModLoadingContext.get().getActiveContainer().getEventBus());
        CreateNewAge.REGISTRATE.registerEventListeners(eventBus);
        DeferredHolder tab = TAB_REGISTER.register("tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"tab.create_new_age.tab")).icon(() -> CNABlocks.GENERATOR_COIL.asStack()).build());
        CreateNewAge.REGISTRATE.setCreativeTab(tab);
        TAB_REGISTER.register(eventBus);
        RECIPE_TYPE_REGISTER.register(eventBus);
        RECIPE_SERIALIZER_REGISTER.register(eventBus);
        CNADataComponents.DATA_COMPONENTS.register(eventBus);
    }

    @Override
    public void afterRegistration() {
        IEventBus eventBus = Objects.requireNonNull(ModLoadingContext.get().getActiveContainer().getEventBus());
    }
}

