/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.neoforge.data;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.antarcticgardens.cna.data.worldgen.CNAPlacedFeatures;

public class CNANeoForgeBiomeModifiers {
    public static ResourceKey<BiomeModifier> THORIUM_ORE = CNANeoForgeBiomeModifiers.key("thorium_ore");
    public static ResourceKey<BiomeModifier> MAGNETITE_BLOCK = CNANeoForgeBiomeModifiers.key("magnetite_block");

    public static void bootstrap(BootstrapContext<BiomeModifier> ctx) {
        HolderGetter biomeLookup = ctx.lookup(Registries.BIOME);
        HolderSet.Named overworld = biomeLookup.getOrThrow(BiomeTags.IS_OVERWORLD);
        HolderGetter featureLookup = ctx.lookup(Registries.PLACED_FEATURE);
        Holder.Reference thoriumOre = featureLookup.getOrThrow(CNAPlacedFeatures.THORIUM_ORE);
        Holder.Reference magnetiteBlock = featureLookup.getOrThrow(CNAPlacedFeatures.MAGNETITE_BLOCK);
        ctx.register(THORIUM_ORE, (Object)CNANeoForgeBiomeModifiers.addOre((HolderSet<Biome>)overworld, (Holder<PlacedFeature>)thoriumOre));
        ctx.register(MAGNETITE_BLOCK, (Object)CNANeoForgeBiomeModifiers.addOre((HolderSet<Biome>)overworld, (Holder<PlacedFeature>)magnetiteBlock));
    }

    private static ResourceKey<BiomeModifier> key(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"create_new_age", (String)name));
    }

    private static BiomeModifier addOre(HolderSet<Biome> biomes, Holder<PlacedFeature> feature) {
        return new BiomeModifiers.AddFeaturesBiomeModifier(biomes, (HolderSet)HolderSet.direct((Holder[])new Holder[]{feature}), GenerationStep.Decoration.UNDERGROUND_ORES);
    }
}

