/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.electricity.connector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.createmod.catnip.data.Pair;
import org.antarcticgardens.cna.config.CNAConfig;
import org.antarcticgardens.cna.content.electricity.connector.WireSection;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Wire {
    public static final float SAG_FACTOR = 0.9f;
    private static final Vector3f GLOBAL_UP = new Vector3f(0.0f, 1.0f, 0.0f);
    private final List<Pair<WireSection, Float>> sections = new ArrayList<Pair<WireSection, Float>>();
    private final Vector3f direction;
    private final Vector3f up;
    private final float sectionLength;

    public Wire(Vector3f direction, float distance, int sectionsAmount) {
        this.direction = direction;
        this.up = this.calculateUp(direction);
        this.sectionLength = distance / (float)sectionsAmount;
        float catenaryScalar = new Vector3f((Vector3fc)this.up).mul((Vector3fc)GLOBAL_UP).length();
        float lastCatenary = 0.0f;
        for (int i = 1; i <= sectionsAmount; ++i) {
            float catenary = this.catenary(i, distance, sectionsAmount) * catenaryScalar;
            WireSection section = WireSection.getOrCreate(this.sectionLength, ((Double)CNAConfig.getClient().wireThickness.get()).floatValue(), catenary - lastCatenary, i % 2 == 0 ? 0.5f : 0.0f);
            lastCatenary = catenary;
            this.sections.add((Pair<WireSection, Float>)Pair.of((Object)section, (Object)Float.valueOf(lastCatenary)));
        }
    }

    private Vector3f calculateUp(Vector3f direction) {
        Vector3f right = new Vector3f((Vector3fc)direction).cross((Vector3fc)GLOBAL_UP);
        if (right.equals((Vector3fc)new Vector3f(0.0f), 0.01f)) {
            return new Vector3f(1.0f, 0.0f, 0.0f);
        }
        return right.normalize().cross((Vector3fc)direction).normalize();
    }

    private float catenary(double x, double length, int sections) {
        double a = length / (double)((Integer)CNAConfig.getCommon().maxWireLength.get()).intValue() * (double)0.9f;
        x = x / (double)sections * 2.0 - 1.0;
        return (float)((Math.cosh(x) - Math.cosh(1.0)) * a);
    }

    public Vector3f getDirection() {
        return new Vector3f((Vector3fc)this.direction);
    }

    public Vector3f getUp() {
        return new Vector3f((Vector3fc)this.up);
    }

    public float getSectionLength() {
        return this.sectionLength;
    }

    public List<Pair<WireSection, Float>> getSections() {
        return Collections.unmodifiableList(this.sections);
    }
}

