/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.motor.extension;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.CreateLang;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.antarcticgardens.cna.content.motor.MotorBlock;
import org.antarcticgardens.cna.content.motor.MotorBlockEntity;
import org.antarcticgardens.cna.content.motor.extension.MotorExtensionBlockEntity;
import org.antarcticgardens.cna.content.motor.extension.variants.IMotorExtensionVariant;
import org.jetbrains.annotations.Nullable;

public class MotorExtensionBlock
extends Block
implements IBE<MotorExtensionBlockEntity>,
IWrenchable {
    protected static final VoxelShape DOWN_AABB = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    protected static final VoxelShape UP_AABB = Block.box((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape NORTH_AABB = Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)12.0);
    protected static final VoxelShape SOUTH_AABB = Block.box((double)2.0, (double)2.0, (double)4.0, (double)14.0, (double)14.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)0.0, (double)2.0, (double)2.0, (double)12.0, (double)14.0, (double)14.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)4.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    private final IMotorExtensionVariant variant;
    BlockEntityEntry<MotorExtensionBlockEntity> entry;

    public MotorExtensionBlock(BlockBehaviour.Properties properties, BlockEntityEntry<MotorExtensionBlockEntity> entry, IMotorExtensionVariant variant) {
        super(properties);
        this.variant = variant;
        this.entry = entry;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.FACING});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.create_new_age.motor_extension").withStyle(ChatFormatting.DARK_GRAY));
        tooltipComponents.add((Component)CreateLang.translate((String)"tooltip.create_new_age.stress_limit_multiplier", (Object[])new Object[0]).style(ChatFormatting.GRAY).component());
        tooltipComponents.add((Component)CreateLang.text((String)" ").add(CreateLang.number((double)((int)(this.variant.getMultiplier() * 100.0f))).text("%").style(ChatFormatting.AQUA)).component());
        tooltipComponents.add((Component)CreateLang.translate((String)"tooltip.create_new_age.additional_capacity", (Object[])new Object[0]).style(ChatFormatting.GRAY).component());
        tooltipComponents.add((Component)CreateLang.text((String)" ").add(CreateLang.number((double)this.variant.getExtraCapacity()).text("\u26a1").style(ChatFormatting.AQUA)).component());
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace().getOpposite();
        BlockPos pos = context.getClickedPos();
        if (context.getPlayer() != null && context.getPlayer().isCrouching()) {
            direction = direction.getOpposite();
        } else if (!(context.getLevel().getBlockState(pos.relative(direction)).getBlock() instanceof MotorBlock)) {
            for (Direction d : Direction.values()) {
                if (!(context.getLevel().getBlockState(pos.relative(d)).getBlock() instanceof MotorBlock)) continue;
                direction = d;
                break;
            }
        }
        BlockState blockState = (BlockState)super.getStateForPlacement(context).setValue((Property)BlockStateProperties.FACING, (Comparable)direction);
        return blockState;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (world instanceof ServerLevel) {
            if (player != null && !player.isCreative()) {
                Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.getBlockEntity(pos), (Entity)player, (ItemStack)context.getItemInHand()).forEach(itemStack -> player.getInventory().placeItemBackInInventory(itemStack));
            }
            state.spawnAfterBreak((ServerLevel)world, pos, ItemStack.EMPTY, true);
            world.destroyBlock(pos, false);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockEntity entity;
        if (state.hasBlockEntity() && (entity = context.getLevel().getBlockEntity(context.getClickedPos())) instanceof MotorBlockEntity) {
            MotorBlockEntity en = (MotorBlockEntity)entity;
            en.needsPower = !en.needsPower;
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public VoxelShape getShape(BlockState arg, BlockGetter arg2, BlockPos arg3, CollisionContext arg4) {
        return switch ((Direction)arg.getValue((Property)BlockStateProperties.FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> DOWN_AABB;
            case Direction.UP -> UP_AABB;
            case Direction.NORTH -> NORTH_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.WEST -> WEST_AABB;
            case Direction.EAST -> EAST_AABB;
        };
    }

    public Class<MotorExtensionBlockEntity> getBlockEntityClass() {
        return MotorExtensionBlockEntity.class;
    }

    public BlockEntityType<? extends MotorExtensionBlockEntity> getBlockEntityType() {
        return (BlockEntityType)this.entry.get();
    }
}

