/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.electricity.connector;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_4587;
import net.minecraft.class_4588;

public class WireSection {
    private static final Map<String, WireSection> cache = new HashMap<String, WireSection>();
    private final float thickness;
    private final float length;
    private final float endYOffset;
    private final float vOffset;

    public WireSection(float length, float thickness, float endYOffset, float vOffset) {
        this.thickness = thickness;
        this.length = length;
        this.endYOffset = endYOffset;
        this.vOffset = vOffset;
    }

    public void render(class_4588 consumer, class_4587 poseStack, int packedLight, float yOffset) {
        float ht = this.thickness / 2.0f;
        for (int i = -1; i <= 1; i += 2) {
            this.addVertex(consumer, ht, ht * (float)i + yOffset, 0.0f, 0.0f, 0.5f + this.vOffset, poseStack, packedLight);
            this.addVertex(consumer, -ht, -ht * (float)i + yOffset, 0.0f, 0.0f, 0.0f + this.vOffset, poseStack, packedLight);
            this.addVertex(consumer, -ht, -ht * (float)i + this.endYOffset + yOffset, this.length * 1.01f, 1.0f, 0.0f + this.vOffset, poseStack, packedLight);
            this.addVertex(consumer, ht, ht * (float)i + this.endYOffset + yOffset, this.length * 1.01f, 1.0f, 0.5f + this.vOffset, poseStack, packedLight);
        }
    }

    private void addVertex(class_4588 consumer, float x, float y, float z, float u, float v, class_4587 poseStack, int packedLight) {
        consumer.method_22918(poseStack.method_23760().method_23761(), x, y, z).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(u, v).method_22916(packedLight).method_22914(0.0f, 1.0f, 0.0f).method_1344();
    }

    public String name() {
        return this.thickness + "," + this.length + "," + this.endYOffset + "," + this.vOffset;
    }

    public static WireSection getOrCreate(float length, float thickness, float endYOffset, float vOffset) {
        return cache.computeIfAbsent(thickness + "," + length + "," + endYOffset + "," + vOffset, s -> new WireSection(length, thickness, endYOffset, vOffset));
    }
}

