/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.electricity.generation.coil;

import com.google.common.collect.Lists;
import com.simibubi.create.content.kinetics.KineticNetwork;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_6862;
import org.antarcticgardens.cna.CNATags;
import org.antarcticgardens.cna.CreateNewAge;
import org.antarcticgardens.cna.config.CNAConfig;
import org.antarcticgardens.cna.content.electricity.generation.magnet.IMagneticBlock;
import org.antarcticgardens.cna.util.RelativeBlockPos;
import org.antarcticgardens.cna.util.StringFormatUtil;

public class GeneratorCoilBlockEntity
extends KineticBlockEntity {
    public final List<class_2338> magnetPositions;
    private float lastStress = 0.0f;
    private int generatedEnergy = 0;
    private float plainStress;

    public GeneratorCoilBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
        RelativeBlockPos relativePosition = new RelativeBlockPos(this.field_11867, (class_2350.class_2351)state.method_11654((class_2769)RotatedPillarKineticBlock.AXIS));
        this.magnetPositions = Lists.newArrayList((Object[])new class_2338[]{relativePosition.up(2).right(1).getPos(), relativePosition.up(2).getPos(), relativePosition.up(2).left(1).getPos(), relativePosition.left(2).up(1).getPos(), relativePosition.left(2).getPos(), relativePosition.left(2).down(1).getPos(), relativePosition.down(2).left(1).getPos(), relativePosition.down(2).getPos(), relativePosition.down(2).right(1).getPos(), relativePosition.right(2).down(1).getPos(), relativePosition.right(2).getPos(), relativePosition.right(2).up(1).getPos()});
        this.setLazyTickRate(20);
    }

    protected class_238 createRenderBoundingBox() {
        return new class_238(this.field_11867).method_1014(1.0);
    }

    public float calculateStressApplied() {
        float stress = this.plainStress = super.calculateStressApplied();
        block2: for (class_2338 pos : this.magnetPositions) {
            class_2680 state = this.field_11863.method_8320(pos);
            if (!state.method_26164(CNATags.Block.MAGNET.blockTag)) continue;
            class_2248 class_22482 = state.method_26204();
            if (class_22482 instanceof IMagneticBlock) {
                IMagneticBlock magneticBlock = (IMagneticBlock)class_22482;
                stress += magneticBlock.getStrength();
                continue;
            }
            for (class_6862 blockTagKey : state.method_40144().toList()) {
                String path;
                if (!blockTagKey.comp_327().method_12836().equals("create_new_age") || !(path = blockTagKey.comp_327().method_12832()).startsWith("magnet/force_")) continue;
                try {
                    stress += (float)Integer.parseInt(path.substring(13));
                    continue block2;
                }
                catch (NumberFormatException e) {
                    CreateNewAge.LOGGER.error("BAD TAG " + blockTagKey + " on item " + state.method_26204(), (Throwable)e);
                }
            }
        }
        this.lastStressApplied = stress;
        return stress;
    }

    public void tick() {
        super.tick();
        this.generatedEnergy = (int)((double)((this.lastStressApplied - this.plainStress) * Math.abs(this.getSpeed())) * (Double)CNAConfig.getCommon().suToEnergy.get());
    }

    public void lazyTick() {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        float stress = this.calculateStressApplied();
        KineticNetwork network = this.getOrCreateNetwork();
        if (network != null && this.lastStress != stress) {
            network.updateStressFor((KineticBlockEntity)this, stress);
            network.updateStress();
            this.sendData();
            this.lastStress = stress;
        }
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"tooltip.create_new_age.efficiency", (Object[])new Object[0]).style(class_124.field_1080).forGoggles(tooltip, 1);
        CreateLang.translate((String)"tooltip.create_new_age.percent", (Object[])new Object[]{StringFormatUtil.formatPercentFloat((this.lastStressApplied - this.plainStress) / this.lastStressApplied)}).style(class_124.field_1075).forGoggles(tooltip, 2);
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    public int takeGeneratedEnergy() {
        int energy = this.generatedEnergy;
        this.generatedEnergy = 0;
        return energy;
    }
}

