/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.electricity.network;

import java.util.ArrayList;
import java.util.LinkedList;
import org.antarcticgardens.cna.config.CNAConfig;
import org.antarcticgardens.cna.content.electricity.connector.ElectricalConnectorBlockEntity;
import org.antarcticgardens.cna.content.electricity.network.NetworkPath;
import org.antarcticgardens.cna.content.electricity.network.NetworkPathConductivityContext;
import org.antarcticgardens.cna.util.HashSortedPair;

public class NetworkPathManager {
    private NetworkPathConductivityContext context = new NetworkPathConductivityContext();

    protected void addConnection(ElectricalConnectorBlockEntity node, ElectricalConnectorBlockEntity node1) {
        this.context.addConnection(node, node1);
    }

    protected NetworkPath findConductiblePath(ElectricalConnectorBlockEntity a, ElectricalConnectorBlockEntity b) {
        ArrayList<ElectricalConnectorBlockEntity> visited = new ArrayList<ElectricalConnectorBlockEntity>();
        LinkedList<QueueElement> queue = new LinkedList<QueueElement>();
        queue.add(new QueueElement(a, null, 0));
        visited.add(a);
        while (!queue.isEmpty()) {
            NetworkPath path;
            QueueElement element = (QueueElement)queue.poll();
            if (((Object)((Object)element.connector)).equals((Object)b) && (path = this.unwrapConductiblePath(element)) != null && this.context.calculatePathConductivity(path) > 0L) {
                return path;
            }
            for (ElectricalConnectorBlockEntity connector : element.connector.getConnectedConnectors().keySet()) {
                if (visited.contains((Object)connector) || element.depth >= (Integer)CNAConfig.getCommon().maxPathfindingDepth.get()) continue;
                visited.add(connector);
                queue.add(new QueueElement(connector, element, element.depth + 1));
            }
        }
        return null;
    }

    private NetworkPath unwrapConductiblePath(QueueElement element) {
        NetworkPath path = new NetworkPath();
        while (element != null) {
            if (path.getLength() != 0 && this.context.getConnectionConductivity(new HashSortedPair<ElectricalConnectorBlockEntity>(element.connector, path.getFirstNode())) <= 0L) {
                return null;
            }
            path.addNodeToBeginning(element.connector);
            element = element.parent;
        }
        if (path.getLength() < 2) {
            return null;
        }
        return path;
    }

    protected NetworkPathConductivityContext getConductivityContext() {
        return this.context;
    }

    protected void setConductivityContext(NetworkPathConductivityContext context) {
        this.context = context;
    }

    protected void tick() {
        this.context.updateConductivity();
    }

    private record QueueElement(ElectricalConnectorBlockEntity connector, QueueElement parent, int depth) {
    }
}

