/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.energising;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.antarcticgardens.cna.CNABlockEntityTypes;
import org.antarcticgardens.cna.CNABlocks;
import org.antarcticgardens.cna.content.energising.EnergiserBehaviour;
import org.antarcticgardens.cna.content.energising.EnergiserBlock;
import org.antarcticgardens.cna.util.RunnableUtil;
import org.antarcticgardens.cna.util.StringFormatUtil;
import org.antarcticgardens.esl.energy.EnergyStorage;
import org.antarcticgardens.esl.energy.SimpleEnergyStorage;

public class EnergiserBlockEntity
extends KineticBlockEntity {
    private final SimpleEnergyStorage storage;
    public int tier;
    public float size = 0.0f;
    private EnergiserBehaviour energisingBehaviour;
    public long lastCharged = -1L;

    public EnergiserBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.tier = state.method_26204().equals(CNABlocks.BASIC_ENERGISER.get()) ? 1 : (state.method_26204().equals(CNABlocks.ADVANCED_ENERGISER.get()) ? 2 : 3);
        this.storage = new SimpleEnergyStorage(EnergiserBlock.getCapacity(this.tier)).onFinalCommit(RunnableUtil.createBlockEntityUpdater((class_2586)this));
        EnergyStorage.registerForBlockEntity((blockEntity, direction) -> blockEntity.storage, (class_2591)((class_2591)CNABlockEntityTypes.ENERGISER.get()));
        this.energisingBehaviour.tier = this.tier;
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        compound.method_10544("Energy", this.storage.getStoredEnergy());
        super.write(compound, clientPacket);
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        this.storage.setStoredEnergy(compound.method_10537("Energy"));
        super.read(compound, clientPacket);
    }

    protected class_238 createRenderBoundingBox() {
        class_243 pos = new class_243((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260());
        return new class_238(pos.method_1023(1.0, 3.0, 1.0), pos.method_1031(1.0, 1.0, 1.0));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.energisingBehaviour = new EnergiserBehaviour(this);
        behaviours.add((BlockEntityBehaviour)this.energisingBehaviour);
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"tooltip.create_new_age.energy_stats", (Object[])new Object[0]).style(class_124.field_1068).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.create_new_age.energy_stored", (Object[])new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.create_new_age.energy_storage", (Object[])new Object[]{StringFormatUtil.formatLong(this.storage.getStoredEnergy()), StringFormatUtil.formatLong(this.storage.getCapacity())}).style(class_124.field_1075).forGoggles(tooltip, 1);
        if (this.lastCharged != -1L) {
            CreateLang.translate((String)"tooltip.create_new_age.energy_usage", (Object[])new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
            CreateLang.translate((String)"tooltip.create_new_age.energy_per_tick", (Object[])new Object[]{StringFormatUtil.formatLong(this.lastCharged)}).style(class_124.field_1075).forGoggles(tooltip, 1);
        }
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    public SimpleEnergyStorage getEnergyStorage() {
        return this.storage;
    }

    public float calculateStressApplied() {
        float impact = this.tier == 1 ? 4.0f : (this.tier == 2 ? 8.0f : 32.0f);
        this.lastStressApplied = impact;
        return impact;
    }
}

