/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.electricity.network;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.antarcticgardens.cna.content.electricity.connector.ElectricalConnectorBlockEntity;
import org.antarcticgardens.cna.content.electricity.network.ElectricalNetwork;
import org.antarcticgardens.cna.content.electricity.network.NetworkPathConductivityContext;
import org.antarcticgardens.cna.content.electricity.network.NetworkSnapshot;
import org.antarcticgardens.esl.energy.EnergyStorage;
import org.antarcticgardens.esl.transaction.SnapshotParticipant;
import org.antarcticgardens.esl.transaction.TransactionContext;

public class NetworkEnergyStorage
extends SnapshotParticipant<Object>
implements EnergyStorage {
    private final ElectricalConnectorBlockEntity connector;
    private ElectricalNetwork network;

    public NetworkEnergyStorage(ElectricalConnectorBlockEntity connector, ElectricalNetwork network) {
        this.connector = connector;
        this.network = network;
    }

    public ElectricalNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(ElectricalNetwork network) {
        this.network = network;
    }

    public long insert(long maxAmount, TransactionContext txn) {
        if (this.network == null) {
            return 0L;
        }
        this.updateSnapshots(txn);
        return this.network.insert(this.connector, maxAmount, txn);
    }

    public long extract(long maxAmount, TransactionContext txn) {
        return 0L;
    }

    public long getStoredEnergy() {
        return 0L;
    }

    public long getCapacity() {
        return Long.MAX_VALUE;
    }

    public Object createSnapshot() {
        if (this.network == null) {
            return null;
        }
        return new NetworkSnapshot(this.network);
    }

    public void restoreSnapshot(Object object) {
        if (object instanceof NetworkSnapshot) {
            NetworkSnapshot snapshot = (NetworkSnapshot)object;
            this.getNetwork().getPathManager().setConductivityContext(new NetworkPathConductivityContext(snapshot.getContext()));
            for (Map.Entry<ElectricalConnectorBlockEntity, Object> e : snapshot.getSnapshots().entrySet()) {
                EnergyStorage storage = EnergyStorage.findForBlock((Level)e.getKey().m_58904_(), (BlockPos)e.getKey().getSupportingBlockPos(), (Direction)((Direction)e.getKey().m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)));
                if (!(storage instanceof SnapshotParticipant)) continue;
                SnapshotParticipant sp = (SnapshotParticipant)storage;
                sp.restoreSnapshot(e.getValue());
            }
        }
    }
}

