/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.energising.recipe;

import com.google.gson.JsonObject;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import com.simibubi.create.content.processing.sequenced.IAssemblyRecipe;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.antarcticgardens.cna.CNABlocks;
import org.antarcticgardens.cna.CreateNewAge;
import org.antarcticgardens.cna.content.energising.recipe.EnergisingRecipeBuilder;
import org.antarcticgardens.cna.util.RecipeUtil;
import org.jetbrains.annotations.NotNull;

public class EnergisingRecipe
extends ProcessingRecipe<Container>
implements IAssemblyRecipe {
    public static IRecipeTypeInfo TYPE = RecipeUtil.createIRecipeTypeInfo("energising", new ProcessingRecipeSerializer(EnergisingRecipe::new));
    private int energyNeeded;

    public EnergisingRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super(TYPE, params);
        if (params instanceof EnergisingRecipeBuilder.EnergisingRecipeParams) {
            EnergisingRecipeBuilder.EnergisingRecipeParams p = (EnergisingRecipeBuilder.EnergisingRecipeParams)params;
            this.energyNeeded = p.energyNeeded;
        }
    }

    public void readAdditional(JsonObject json) {
        this.energyNeeded = json.get("energyNeeded").getAsInt();
    }

    public void readAdditional(FriendlyByteBuf buffer) {
        this.energyNeeded = buffer.readInt();
    }

    public void writeAdditional(JsonObject json) {
        json.addProperty("energyNeeded", (Number)this.energyNeeded);
    }

    public void writeAdditional(FriendlyByteBuf buffer) {
        buffer.writeInt(this.energyNeeded);
    }

    public int getEnergyNeeded() {
        return this.energyNeeded;
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 4;
    }

    public Component getDescriptionForAssembly() {
        return Component.m_237115_((String)"recipe.assembly.energising");
    }

    public void addRequiredMachines(Set<ItemLike> list) {
        list.add((ItemLike)CNABlocks.BASIC_ENERGISER.get());
    }

    public void addAssemblyIngredients(List<Ingredient> list) {
    }

    public Supplier<Supplier<SequencedAssemblySubCategory>> getJEISubCategory() {
        return (Supplier)CreateNewAge.getInstance().getPlatform().getEnergisingRecipeSubCategory();
    }

    public boolean m_5818_(Container container, @NotNull Level level) {
        if (container.m_7983_()) {
            return false;
        }
        return ((Ingredient)this.ingredients.get(0)).test(container.m_8020_(0));
    }

    public boolean test(ItemStack stack) {
        return ((Ingredient)this.ingredients.get(0)).test(stack);
    }

    public static void load() {
    }
}

