/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.electricity.network;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.antarcticgardens.cna.content.electricity.connector.ElectricalConnectorBlockEntity;
import org.antarcticgardens.cna.content.electricity.network.ElectricalNetwork;
import org.antarcticgardens.cna.content.electricity.network.NetworkEnergyStorage;
import org.antarcticgardens.cna.content.electricity.network.NetworkPathConductivityContext;
import org.antarcticgardens.esl.energy.EnergyStorage;
import org.antarcticgardens.esl.transaction.SnapshotParticipant;

public class NetworkSnapshot {
    private final Map<ElectricalConnectorBlockEntity, Object> snapshots = new HashMap<ElectricalConnectorBlockEntity, Object>();
    private final NetworkPathConductivityContext context;

    public NetworkSnapshot(ElectricalNetwork network) {
        this.context = new NetworkPathConductivityContext(network.getPathManager().getConductivityContext());
        for (ElectricalConnectorBlockEntity connector : network.getNodes()) {
            EnergyStorage storage = EnergyStorage.findForBlock((Level)connector.getLevel(), (BlockPos)connector.getSupportingBlockPos(), (Direction)((Direction)connector.getBlockState().getValue((Property)BlockStateProperties.FACING)));
            if (!(storage instanceof SnapshotParticipant)) continue;
            SnapshotParticipant snapshotParticipant = (SnapshotParticipant)storage;
            if (storage instanceof NetworkEnergyStorage) continue;
            this.snapshots.put(connector, snapshotParticipant.createSnapshot());
        }
    }

    public Map<ElectricalConnectorBlockEntity, Object> getSnapshots() {
        return this.snapshots;
    }

    public NetworkPathConductivityContext getContext() {
        return this.context;
    }
}

