/*
 * Decompiled with CFR 0.152.
 */
package com.anionianonion.onrespawncommands;

import com.anionianonion.onrespawncommands.Config;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="onrespawncommands", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventHandler {
    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent e) {
        ServerPlayer serverPlayer = (ServerPlayer)e.getEntity();
        EventHandler.executeServerCommands(serverPlayer, Config.commandsToExecuteByServer, false);
        EventHandler.executeServerCommands(serverPlayer, Config.commandsToExecuteAsPlayer, true);
    }

    public static void executeServerCommands(ServerPlayer player, List<String> commands, boolean needPerms) {
        MinecraftServer server = player.level().getServer();
        if (server == null) {
            return;
        }
        CommandDispatcher dispatcher = server.getCommands().getDispatcher();
        CommandSourceStack serverSource = needPerms ? player.createCommandSourceStack() : server.createCommandSourceStack();
        for (String commandString : commands) {
            try {
                if (commandString.contains("@s") && !needPerms) {
                    commandString = commandString.replaceAll("@s", player.getName().getString());
                }
                ParseResults parseResults = dispatcher.parse(commandString, (Object)serverSource);
                server.getCommands().performCommand(parseResults, commandString);
            }
            catch (Exception e) {
                server.sendSystemMessage((Component)Component.literal((String)("Failed to execute server command: " + commandString)));
            }
        }
    }
}

