/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.render;

import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Optional;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.client.gui.ChartingScreen;
import net.rasanovum.viaromana.client.gui.LinkSignScreen;
import net.rasanovum.viaromana.client.gui.TeleportMapScreen;
import net.rasanovum.viaromana.client.gui.WarpBlockScreen;
import net.rasanovum.viaromana.util.VersionUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ClientCursorHandler {
    private static long customCursorHandle = 0L;
    private static boolean isCustomCursorActive = false;
    private static boolean hasInitialized = false;
    private static final double CURSOR_SCALE = 2.0;
    private static final class_2960 CURSOR = VersionUtils.getLocation("via_romana:textures/screens/cursor.png");

    private static void loadCursor(class_310 mc) {
        block23: {
            if (customCursorHandle != 0L || hasInitialized) {
                return;
            }
            hasInitialized = true;
            try {
                Optional resource = mc.method_1478().method_14486(CURSOR);
                if (!resource.isPresent()) break block23;
                try (InputStream stream = ((class_3298)resource.get()).method_14482();
                     class_1011 image = class_1011.method_4309((InputStream)stream);
                     MemoryStack stack = MemoryStack.stackPush();){
                    int newWidth = (int)((double)image.method_4307() * 2.0);
                    int newHeight = (int)((double)image.method_4323() * 2.0);
                    ByteBuffer textureBuffer = MemoryUtil.memAlloc((int)(newWidth * newHeight * 4));
                    for (int y = 0; y < newHeight; ++y) {
                        for (int x = 0; x < newWidth; ++x) {
                            int srcX = Math.min((int)((double)x / 2.0), image.method_4307() - 1);
                            int srcY = Math.min((int)((double)y / 2.0), image.method_4323() - 1);
                            textureBuffer.putInt(image.method_4315(srcX, srcY));
                        }
                    }
                    textureBuffer.flip();
                    GLFWImage cursorImage = GLFWImage.malloc((MemoryStack)stack);
                    cursorImage.width(newWidth);
                    cursorImage.height(newHeight);
                    cursorImage.pixels(textureBuffer);
                    customCursorHandle = GLFW.glfwCreateCursor((GLFWImage)cursorImage, (int)0, (int)0);
                    MemoryUtil.memFree((Buffer)textureBuffer);
                }
            }
            catch (IOException e) {
                ViaRomana.LOGGER.warn("Custom Cursor allocation failed: {}", (Object)e.getMessage());
            }
        }
    }

    public static void onClientTick() {
        boolean shouldBeCustom;
        class_310 mc = class_310.method_1551();
        if (!hasInitialized) {
            ClientCursorHandler.loadCursor(mc);
            if (customCursorHandle == 0L) {
                return;
            }
        }
        long windowHandle = mc.method_22683().method_4490();
        boolean bl = shouldBeCustom = CommonConfig.enable_custom_cursor && (mc.field_1755 instanceof TeleportMapScreen || mc.field_1755 instanceof LinkSignScreen || mc.field_1755 instanceof ChartingScreen || mc.field_1755 instanceof WarpBlockScreen);
        if (shouldBeCustom && !isCustomCursorActive) {
            GLFW.glfwSetCursor((long)windowHandle, (long)customCursorHandle);
            isCustomCursorActive = true;
        } else if (!shouldBeCustom && isCustomCursorActive) {
            GLFW.glfwSetCursor((long)windowHandle, (long)0L);
            isCustomCursorActive = false;
        }
    }

    public static void destroy() {
        if (customCursorHandle != 0L) {
            GLFW.glfwDestroyCursor((long)customCursorHandle);
            customCursorHandle = 0L;
        }
    }
}

