/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_368;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.client.FadeManager;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.client.gui.LinkedSignToast;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.storage.player.PlayerData;
import net.rasanovum.viaromana.util.VersionUtils;

@Environment(value=EnvType.CLIENT)
public class LinkIndicationHandler {
    private static int tickCounter = 0;
    private static final int SCAN_INTERVAL = 10;
    private static final double RENDER_RADIUS = 12.0;
    private static final class_5819 RANDOM = class_5819.method_43047();
    private static final List<class_2338> CACHED_SIGNS = new ArrayList<class_2338>();
    private static final class_2561 TOOLTIP_TEXT = class_2561.method_43471((String)"gui.viaromana.left_click_hover_tip");
    private static final class_2960 CURSOR = VersionUtils.getLocation("via_romana:textures/screens/cursor.png");
    private static final int ICON_SIZE = 18;
    private static float currentOpacity = 0.0f;
    private static final float fadeSpeed = 0.25f;
    private static boolean isHovering = false;
    static final double driftRange = 0.5;

    public static void onClientTick() {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null || client.field_1724 == null || client.method_1493()) {
            return;
        }
        if (CommonConfig.enable_custom_cursor) {
            LinkIndicationHandler.handleLookTarget(client);
            LinkIndicationHandler.updateOpacity();
            if (isHovering && client.field_1724 != null && !PlayerData.hasSeenLinkedSignToast((class_1657)client.field_1724)) {
                client.method_1566().method_1999((class_368)new LinkedSignToast((class_2561)class_2561.method_43471((String)"toast.viaromana.linked_sign_hint.title"), (class_2561)class_2561.method_43471((String)"toast.viaromana.linked_sign_hint.description")));
                PlayerData.setSeenLinkedSignToast((class_1657)client.field_1724, true);
            }
        } else {
            currentOpacity = 0.0f;
            isHovering = false;
        }
        if (++tickCounter % 10 != 0) {
            return;
        }
        LinkIndicationHandler.updateCacheAndSpawnParticles(client);
    }

    public static float getCrosshairAlpha() {
        if (!CommonConfig.enable_custom_cursor) {
            return 1.0f;
        }
        float globalFade = 1.0f - FadeManager.getCurrentFadeAlpha();
        return (1.0f - currentOpacity) * globalFade;
    }

    public static void render(class_332 graphics, float tickDelta) {
        if (currentOpacity <= 0.05f) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1690.field_1842) {
            return;
        }
        int width = mc.method_22683().method_4486();
        int height = mc.method_22683().method_4502();
        float alpha = class_3532.method_15363((float)currentOpacity, (float)0.0f, (float)1.0f);
        float globalFade = 1.0f - FadeManager.getCurrentFadeAlpha();
        if ((alpha *= globalFade) <= 0.01f) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.enableBlend();
        graphics.method_25290(CURSOR, (width - 18) / 2, (height - 18) / 2, 0.0f, 0.0f, 18, 18, 18, 18);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
    }

    private static void updateOpacity() {
        if (isHovering) {
            if ((currentOpacity += 0.25f) > 1.0f) {
                currentOpacity = 1.0f;
            }
        } else if ((currentOpacity -= 0.25f) < 0.0f) {
            currentOpacity = 0.0f;
        }
    }

    private static void handleLookTarget(class_310 mc) {
        class_2338 hitPos;
        isHovering = false;
        if (Objects.requireNonNull(mc.field_1724).method_18276()) {
            return;
        }
        if (mc.field_1765 != null && mc.field_1765.method_17783() == class_239.class_240.field_1332 && CACHED_SIGNS.contains(hitPos = ((class_3965)mc.field_1765).method_17777())) {
            isHovering = true;
        }
    }

    private static void updateCacheAndSpawnParticles(class_310 client) {
        CACHED_SIGNS.clear();
        assert (client.field_1724 != null);
        class_2338 playerPos = client.field_1724.method_24515();
        List<Node> nearbyNodes = ClientPathData.getInstance().getNearbyNodes(playerPos, 12.0, false);
        for (Node node : nearbyNodes) {
            if (!node.isLinked()) continue;
            node.getSignPos().ifPresent(signPosLong -> {
                class_2338 signPos = class_2338.method_10092((long)signPosLong);
                if (signPos.method_10262((class_2382)playerPos) <= 144.0) {
                    CACHED_SIGNS.add(signPos);
                    LinkIndicationHandler.spawnLinkParticles((class_1937)client.field_1687, signPos);
                }
            });
        }
    }

    private static void spawnLinkParticles(class_1937 level, class_2338 pos) {
        if (!CommonConfig.enable_sign_particles) {
            return;
        }
        for (int i = 0; i < 1; ++i) {
            double startX = (double)pos.method_10263() + 0.5 + (RANDOM.method_43058() - 0.5) * 1.5;
            double startY = (double)pos.method_10264() + 0.5 + RANDOM.method_43058() * 0.8;
            double startZ = (double)pos.method_10260() + 0.5 + (RANDOM.method_43058() - 0.5) * 1.5;
            double endX = startX + (RANDOM.method_43058() - 0.5) * 0.5;
            double endZ = startZ + (RANDOM.method_43058() - 0.5) * 0.5;
            level.method_8406((class_2394)class_2398.field_11215, endX, startY, endZ, startX - endX, 0.0, startZ - endZ);
        }
    }
}

