/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.core;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.integration.IntegrationManager;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.path.PathDataManager;
import net.rasanovum.viaromana.tags.TagGenerator;
import net.rasanovum.viaromana.util.PathSyncUtils;

public class LinkHandler {
    public static boolean isSignBlock(class_1936 world, class_2338 blockPos) {
        class_2680 targetBlock = world.method_8320(blockPos);
        return targetBlock.method_26164(TagGenerator.WARP_BLOCK_TAG);
    }

    private static PathGraph getPathGraph(class_1936 level) {
        if (level instanceof class_1937) {
            class_1937 levelInstance = (class_1937)level;
            if (levelInstance.method_8608()) {
                ClientPathData clientData = ClientPathData.getInstance();
                return clientData.hasValidData() ? clientData.getGraph((class_5321<class_1937>)levelInstance.method_27983()) : null;
            }
            if (levelInstance instanceof class_3218) {
                class_3218 serverLevel = (class_3218)levelInstance;
                return PathGraph.getInstance(serverLevel);
            }
        }
        return null;
    }

    public static boolean linkSignToNode(class_3218 level, LinkData linkData) {
        if (!level.method_22340(linkData.signPos())) {
            level.method_22350(linkData.signPos());
        }
        if (!LinkHandler.isSignBlock((class_1936)level, linkData.signPos())) {
            ViaRomana.LOGGER.warn("linkSignToNode: Sign block entity not found at {} or chunk not loaded.", (Object)linkData.signPos());
            return false;
        }
        PathGraph graph = PathGraph.getInstance(level);
        Optional<Node> nodeOpt = graph.getNodeAt(linkData.nodePos());
        if (nodeOpt.isEmpty()) {
            ViaRomana.LOGGER.warn("linkSignToNode: Node not found at {}", (Object)linkData.nodePos());
            return false;
        }
        Node node = nodeOpt.get();
        graph.linkSignToNode(linkData.nodePos(), linkData.signPos(), linkData.linkType(), linkData.owner());
        node.setDestinationName(linkData.destinationName());
        node.setDestinationIcon(linkData.icon());
        PathDataManager.markDirty(level);
        PathSyncUtils.syncPathGraphToAllPlayers(level);
        IntegrationManager.addDestination(level, node);
        return true;
    }

    public static void unlinkSignFromNode(class_3218 level, class_2338 signPos) {
        if (!LinkHandler.isSignBlock((class_1936)level, signPos)) {
            return;
        }
        PathGraph graph = PathGraph.getInstance(level);
        Optional<Node> nodeOpt = graph.getNodeBySignPos(signPos);
        if (nodeOpt.isPresent()) {
            Node node = nodeOpt.get();
            graph.removeSignLink(signPos);
            PathDataManager.markDirty(level);
            PathSyncUtils.syncPathGraphToAllPlayers(level);
            IntegrationManager.removeDestination(level, node);
        }
    }

    public static void handleSignDestruction(class_3218 level, class_2338 signPos) {
        Node linkedNode;
        PathGraph graph = PathGraph.getInstance(level);
        Optional<Node> node = LinkHandler.getLinkedNode((class_1936)level, signPos);
        if (node.isPresent() && (linkedNode = node.get()).getSignPos().isPresent() && linkedNode.getSignPos().get().longValue() == signPos.method_10063()) {
            graph.removeSignLink(signPos);
            PathDataManager.markDirty(level);
            PathSyncUtils.syncPathGraphToAllPlayers(level);
            IntegrationManager.removeDestination(level, linkedNode);
        }
    }

    public static boolean isSignLinked(class_1936 world, class_2338 signPos) {
        return LinkHandler.getLinkedNode(world, signPos).isPresent();
    }

    public static Optional<Node> getLinkedNode(class_1936 level, class_2338 signPos) {
        PathGraph graph = LinkHandler.getPathGraph(level);
        if (graph == null) {
            return Optional.empty();
        }
        return graph.getNodeBySignPos(signPos);
    }

    public static boolean hasAccess(class_1297 player, Node node) {
        UUID playerUuid = player.method_5667();
        if (node == null) {
            return false;
        }
        if (node.getPrivateOwner().isEmpty()) {
            return true;
        }
        return playerUuid.equals(node.getPrivateOwner().get());
    }

    public static Optional<LinkData> getLinkData(class_1936 level, class_2338 signPos) {
        class_1937 levelInstance;
        Optional<Node> nodeOpt = LinkHandler.getLinkedNode(level, signPos);
        if (nodeOpt.isPresent()) {
            Node node = nodeOpt.get();
            return Optional.of(new LinkData(signPos, node.getBlockPos(), node.getLinkType(), node.getDestinationIcon().orElse(Node.Icon.SIGNPOST), node.getDestinationName().orElse("Travel Destination"), node.getPrivateOwner().orElse(null)));
        }
        if (level instanceof class_1937 && (levelInstance = (class_1937)level).method_8608()) {
            ClientPathData clientData = ClientPathData.getInstance();
            return clientData.getTemporarySignLink(signPos);
        }
        return Optional.empty();
    }

    public record LinkData(class_2338 signPos, class_2338 nodePos, Node.LinkType linkType, Node.Icon icon, String destinationName, UUID owner) {
    }
}

