/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.map;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.map.MapBaker;
import net.rasanovum.viaromana.map.MapInfo;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.level.LevelDataManager;

public final class ServerMapCache {
    private static final String MAP_DIR_NAME = "data/via_romana/network";
    private static final Map<UUID, MapInfo> cache = new ConcurrentHashMap<UUID, MapInfo>();
    private static final Map<UUID, Set<class_1923>> dirtyNetworks = new ConcurrentHashMap<UUID, Set<class_1923>>();
    private static final Set<UUID> modifiedForSaving = ConcurrentHashMap.newKeySet();
    private static final Set<UUID> pseudoNetworkIds = ConcurrentHashMap.newKeySet();
    private static ScheduledExecutorService scheduler;
    private static ExecutorService mapBakingExecutor;
    private static MinecraftServer minecraftServer;

    private ServerMapCache() {
    }

    public static void init(MinecraftServer server) {
        minecraftServer = server;
        ServerMapCache.shutdown();
        scheduler = Executors.newScheduledThreadPool(2);
        mapBakingExecutor = Executors.newFixedThreadPool(Math.max(1, Runtime.getRuntime().availableProcessors() / 4));
        ViaRomana.LOGGER.info("Starting Via Romana schedulers...");
        if (CommonConfig.map_refresh_interval > 0) {
            scheduler.scheduleAtFixedRate(() -> ServerMapCache.runSafe(ServerMapCache::processAllDirtyNetworks, "Error during scheduled map refreshing."), CommonConfig.map_refresh_interval, CommonConfig.map_refresh_interval, TimeUnit.SECONDS);
            ViaRomana.LOGGER.info("Scheduled map refreshing every {} seconds.", (Object)CommonConfig.map_refresh_interval);
        } else {
            ViaRomana.LOGGER.info("Map refreshing disabled by config.");
        }
        if (CommonConfig.map_refresh_interval > 0 || CommonConfig.map_save_interval > 0) {
            scheduler.scheduleAtFixedRate(() -> ServerMapCache.runSafe(() -> ServerMapCache.saveAllToDisk(false), "Error during scheduled map cache saving"), CommonConfig.map_save_interval, CommonConfig.map_save_interval, TimeUnit.MINUTES);
            ViaRomana.LOGGER.info("Scheduled map saving every {} minutes.", (Object)CommonConfig.map_save_interval);
        } else {
            ViaRomana.LOGGER.info("Map file saving disabled by config.");
        }
    }

    public static void shutdown() {
        if (scheduler != null && !scheduler.isShutdown()) {
            scheduler.shutdown();
            try {
                if (!scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    scheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                scheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        if (mapBakingExecutor != null && !mapBakingExecutor.isShutdown()) {
            mapBakingExecutor.shutdown();
            try {
                if (!mapBakingExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    mapBakingExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                mapBakingExecutor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        if (scheduler != null && scheduler.isShutdown() || mapBakingExecutor != null && mapBakingExecutor.isShutdown()) {
            ViaRomana.LOGGER.info("Via Romana schedulers shut down.");
        }
    }

    public static ExecutorService getMapBakingExecutor() {
        return mapBakingExecutor;
    }

    public static UUID getPseudoNetworkId(UUID playerUUID) {
        String pseudoKey = "pseudonet_" + playerUUID.toString();
        return UUID.nameUUIDFromBytes(pseudoKey.getBytes());
    }

    public static void markAsPseudoNetwork(UUID networkId) {
        pseudoNetworkIds.add(networkId);
        if (CommonConfig.logging_enum.ordinal() > 1) {
            ViaRomana.LOGGER.info("Marked network {} as pseudonetwork.", (Object)networkId);
        }
    }

    public static void invalidatePseudoNetwork(UUID networkId) {
        if (pseudoNetworkIds.remove(networkId)) {
            ServerMapCache.invalidate(networkId);
            if (CommonConfig.logging_enum.ordinal() > 1) {
                ViaRomana.LOGGER.info("Invalidated pseudonetwork {}.", (Object)networkId);
            }
        }
    }

    public static boolean isPseudoNetwork(UUID networkId) {
        return pseudoNetworkIds.contains(networkId);
    }

    public static void markChunkDirty(class_3218 level, class_1923 pos, List<PathGraph.NetworkCache> networks) {
        LevelDataManager.clearPixelBytes(level, pos);
        for (PathGraph.NetworkCache network : networks) {
            UUID networkId = network.id();
            Optional<MapInfo> existingMap = ServerMapCache.getMapData(networkId);
            if (existingMap.isPresent() && CommonConfig.use_biome_fallback_for_lowres && existingMap.get().scaleFactor() >= 4) continue;
            dirtyNetworks.computeIfAbsent(networkId, uuid -> ConcurrentHashMap.newKeySet()).add(pos);
        }
    }

    public static void processAllDirtyNetworks() {
        ServerMapCache.processAllDirtyNetworks(false);
    }

    public static void processAllDirtyNetworks(boolean forceRefresh) {
        if (dirtyNetworks.isEmpty()) {
            return;
        }
        if (!forceRefresh && CommonConfig.map_refresh_threshold > 0 && dirtyNetworks.values().stream().mapToInt(Set::size).sum() < CommonConfig.map_refresh_threshold) {
            return;
        }
        if (CommonConfig.logging_enum.ordinal() > 0) {
            ViaRomana.LOGGER.info("Processing {} dirty networks.", (Object)dirtyNetworks.size());
        }
        ConcurrentHashMap<UUID, Set<class_1923>> toProcess = new ConcurrentHashMap<UUID, Set<class_1923>>(dirtyNetworks);
        dirtyNetworks.clear();
        toProcess.forEach((networkId, chunks) -> {
            if (chunks != null && !chunks.isEmpty()) {
                minecraftServer.execute(() -> ServerMapCache.updateOrGenerateMapAsync(networkId, chunks));
            }
        });
    }

    private static CompletableFuture<MapInfo> updateOrGenerateMapAsync(UUID networkId, Collection<class_1923> chunksToUpdate) {
        return ServerMapCache.findLevelForNetwork(networkId).map(level -> {
            CompletableFuture<MapInfo> bakeFuture;
            PathGraph.NetworkCache network;
            PathGraph graph = PathGraph.getInstance(level);
            PathGraph.NetworkCache networkCache = network = graph != null ? graph.getNetworkCache(networkId) : null;
            if (network == null) {
                ViaRomana.LOGGER.warn("Could not find network cache for network {}, aborting update.", (Object)networkId);
                return CompletableFuture.completedFuture(null);
            }
            MapInfo previousResult = cache.get(networkId);
            if (previousResult != null && previousResult.hasImageData()) {
                if (CommonConfig.logging_enum.ordinal() > 0) {
                    ViaRomana.LOGGER.info("Performing incremental update for network {}.", (Object)networkId);
                }
                bakeFuture = CompletableFuture.supplyAsync(() -> {
                    MapBaker worker = new MapBaker();
                    return worker.updateMap(previousResult, (Set<class_1923>)new HashSet<class_1923>(chunksToUpdate), (class_3218)level);
                }, mapBakingExecutor);
            } else {
                bakeFuture = MapBaker.bakeAsync(networkId, level, mapBakingExecutor);
            }
            return ((CompletableFuture)bakeFuture.thenApply(newResult -> {
                cache.put(networkId, (MapInfo)newResult);
                if (!ServerMapCache.isPseudoNetwork(networkId)) {
                    modifiedForSaving.add(networkId);
                }
                return newResult;
            })).exceptionally(ex -> {
                ViaRomana.LOGGER.error("Failed during map update for network {}", (Object)networkId, ex);
                return null;
            });
        }).orElseGet(() -> {
            ViaRomana.LOGGER.warn("Could not find level for network {}, aborting update.", (Object)networkId);
            return CompletableFuture.completedFuture(null);
        });
    }

    private static Optional<class_3218> findLevelForNetwork(UUID networkId) {
        for (class_3218 level : minecraftServer.method_3738()) {
            PathGraph graph = PathGraph.getInstance(level);
            if (graph == null || graph.getNetworkCache(networkId) == null) continue;
            return Optional.of(level);
        }
        return Optional.empty();
    }

    public static Optional<MapInfo> getMapData(UUID networkId) {
        MapInfo result = cache.get(networkId);
        if (result != null) {
            return Optional.of(result);
        }
        return ServerMapCache.loadFromDisk(networkId);
    }

    public static CompletableFuture<MapInfo> generateMapIfNeeded(UUID networkId, class_3218 level) {
        return ServerMapCache.getMapData(networkId).map(CompletableFuture::completedFuture).orElseGet(() -> {
            PathGraph.NetworkCache network;
            ViaRomana.LOGGER.debug("Generating initial map for network {}.", (Object)networkId);
            PathGraph graph = PathGraph.getInstance(level);
            if (graph != null && (network = graph.getNetworkCache(networkId)) != null) {
                Set<class_1923> allChunks = graph.getNodesAsInfo(network).stream().map(node -> new class_1923(node.position)).collect(Collectors.toSet());
                return ServerMapCache.updateOrGenerateMapAsync(networkId, allChunks);
            }
            ViaRomana.LOGGER.warn("Could not find network to generate map for networkId {}.", (Object)networkId);
            return CompletableFuture.completedFuture(null);
        });
    }

    private static Optional<MapInfo> loadFromDisk(UUID networkId) {
        long startTime = System.nanoTime();
        try {
            InputStream pixelsStream;
            int worldMaxZ;
            int worldMaxX;
            int worldMinZ;
            int worldMinX;
            int pixelHeight;
            int pixelWidth;
            int scaleFactor;
            byte[] chunkPixels;
            byte[] biomePixels;
            Path chunkPixelsPath;
            block29: {
                class_2487 tag;
                Path mapDir = ServerMapCache.getMapDirectory();
                String base = "network-" + String.valueOf(networkId);
                Path metaPath = mapDir.resolve(base + ".nbt");
                Path biomePixelsPath = mapDir.resolve(base + "-biome.pixels");
                chunkPixelsPath = mapDir.resolve(base + "-chunk.pixels");
                biomePixels = null;
                chunkPixels = null;
                try (InputStream metaStream = Files.newInputStream(metaPath, new OpenOption[0]);){
                    tag = class_2507.method_10629((InputStream)metaStream, (class_2505)new class_2505(Long.MAX_VALUE, Integer.MAX_VALUE));
                }
                catch (NoSuchFileException e) {
                    return Optional.empty();
                }
                scaleFactor = tag.method_10550("scale");
                pixelWidth = tag.method_10550("pixelWidth");
                pixelHeight = tag.method_10550("pixelHeight");
                worldMinX = tag.method_10550("worldMinX");
                worldMinZ = tag.method_10550("worldMinZ");
                worldMaxX = tag.method_10550("worldMaxX");
                worldMaxZ = tag.method_10550("worldMaxZ");
                if (Files.exists(biomePixelsPath, new LinkOption[0])) {
                    try {
                        pixelsStream = Files.newInputStream(biomePixelsPath, new OpenOption[0]);
                        try {
                            biomePixels = pixelsStream.readAllBytes();
                            break block29;
                        }
                        finally {
                            if (pixelsStream != null) {
                                pixelsStream.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        ViaRomana.LOGGER.error("Failed to load biome pixels for {}", (Object)networkId, (Object)e);
                        return Optional.empty();
                    }
                }
                ViaRomana.LOGGER.warn("No biome pixel data found for network {}", (Object)networkId);
                return Optional.empty();
            }
            if (Files.exists(chunkPixelsPath, new LinkOption[0])) {
                try {
                    pixelsStream = Files.newInputStream(chunkPixelsPath, new OpenOption[0]);
                    try {
                        chunkPixels = pixelsStream.readAllBytes();
                    }
                    finally {
                        if (pixelsStream != null) {
                            pixelsStream.close();
                        }
                    }
                }
                catch (IOException e) {
                    ViaRomana.LOGGER.warn("Failed to load chunk pixels for {} (optional)", (Object)networkId, (Object)e);
                }
            }
            MapInfo info = MapInfo.fromServer(networkId, biomePixels, chunkPixels, pixelWidth, pixelHeight, scaleFactor, worldMinX, worldMinZ, worldMaxX, worldMaxZ, List.of(), List.of());
            cache.put(networkId, info);
            long loadTime = System.nanoTime() - startTime;
            ViaRomana.LOGGER.debug("Loaded map {} from disk: {}ms, biomeSize={}KB, chunkSize={}KB", (Object)networkId, (Object)((double)loadTime / 1000000.0), (Object)((double)biomePixels.length / 1024.0), (Object)(chunkPixels != null ? (double)chunkPixels.length / 1024.0 : 0.0));
            return Optional.of(info);
        }
        catch (IOException e) {
            ViaRomana.LOGGER.error("Failed to load map {} from disk", (Object)networkId, (Object)e);
            return Optional.empty();
        }
    }

    public static void invalidate(UUID networkId) {
        try {
            dirtyNetworks.remove(networkId);
            cache.remove(networkId);
            modifiedForSaving.remove(networkId);
            try {
                Path mapDir = ServerMapCache.getMapDirectory();
                String base = "network-" + String.valueOf(networkId);
                boolean pngDeleted = Files.deleteIfExists(mapDir.resolve(base + ".png"));
                boolean nbtDeleted = Files.deleteIfExists(mapDir.resolve(base + ".nbt"));
                boolean pixelsDeleted = Files.deleteIfExists(mapDir.resolve(base + ".pixels"));
                if (pngDeleted || nbtDeleted || pixelsDeleted) {
                    ViaRomana.LOGGER.debug("Deleted map files from disk for network {}", (Object)networkId);
                }
            }
            catch (IOException e) {
                ViaRomana.LOGGER.error("Failed to delete map files from disk for network {}", (Object)networkId, (Object)e);
            }
        }
        catch (Exception e) {
            ViaRomana.LOGGER.warn("Failed to invalidate ServerMapCache for network {}: {}", (Object)networkId, (Object)e.getMessage());
        }
    }

    public static void clear() {
        cache.clear();
        dirtyNetworks.clear();
        modifiedForSaving.clear();
        pseudoNetworkIds.clear();
    }

    public static void saveAllToDisk(boolean forceSave) {
        if (modifiedForSaving.isEmpty() && !forceSave) {
            return;
        }
        HashSet<UUID> networksToSave = forceSave ? new HashSet<UUID>(cache.keySet()) : new HashSet<UUID>(modifiedForSaving);
        networksToSave.removeAll(pseudoNetworkIds);
        if (networksToSave.isEmpty()) {
            return;
        }
        long startTime = System.nanoTime();
        ViaRomana.LOGGER.debug("Saving {} maps to disk...", (Object)networksToSave.size());
        try {
            Path mapDir = ServerMapCache.getMapDirectory();
            Files.createDirectories(mapDir, new FileAttribute[0]);
            int savedCount = 0;
            long totalBytes = 0L;
            for (UUID id : networksToSave) {
                MapInfo info = cache.get(id);
                if (info == null || info.biomePixels() == null || info.pixelWidth() == 0 || info.pixelHeight() == 0) {
                    ServerMapCache.invalidate(id);
                    continue;
                }
                String base = "network-" + String.valueOf(id);
                Path nbtPath = mapDir.resolve(base + ".nbt");
                Path biomePixelsPath = mapDir.resolve(base + "-biome.pixels");
                Path chunkPixelsPath = mapDir.resolve(base + "-chunk.pixels");
                class_2487 tag = new class_2487();
                tag.method_10569("scale", info.scaleFactor());
                tag.method_10569("pixelWidth", info.pixelWidth());
                tag.method_10569("pixelHeight", info.pixelHeight());
                tag.method_10569("worldMinX", info.worldMinX());
                tag.method_10569("worldMinZ", info.worldMinZ());
                tag.method_10569("worldMaxX", info.worldMaxX());
                tag.method_10569("worldMaxZ", info.worldMaxZ());
                if (info.createdAtMs() != null) {
                    tag.method_10544("createdAt", info.createdAtMs().longValue());
                }
                try {
                    OutputStream nbtOut = Files.newOutputStream(nbtPath, new OpenOption[0]);
                    try {
                        OutputStream biomePixelsOut = Files.newOutputStream(biomePixelsPath, new OpenOption[0]);
                        try {
                            OutputStream chunkPixelsOut = Files.newOutputStream(chunkPixelsPath, new OpenOption[0]);
                            try {
                                class_2507.method_10634((class_2487)tag, (OutputStream)nbtOut);
                                biomePixelsOut.write(info.biomePixels());
                                if (info.chunkPixels() != null) {
                                    chunkPixelsOut.write(info.chunkPixels());
                                }
                                ++savedCount;
                                totalBytes += (long)(info.biomePixels().length + (info.chunkPixels() != null ? info.chunkPixels().length : 0));
                            }
                            finally {
                                if (chunkPixelsOut == null) continue;
                                chunkPixelsOut.close();
                            }
                        }
                        finally {
                            if (biomePixelsOut == null) continue;
                            biomePixelsOut.close();
                        }
                    }
                    finally {
                        if (nbtOut == null) continue;
                        nbtOut.close();
                    }
                }
                catch (IOException e) {
                    ViaRomana.LOGGER.error("Failed to write map files for network {}", (Object)id, (Object)e);
                }
            }
            long saveTime = System.nanoTime() - startTime;
            if (savedCount > 0) {
                ViaRomana.LOGGER.debug("Saved {} maps to disk: {}ms, total={}KB, avg={}KB/map", (Object)savedCount, (Object)((double)saveTime / 1000000.0), (Object)((double)totalBytes / 1024.0), (Object)((double)(totalBytes / (long)savedCount) / 1024.0));
            }
            modifiedForSaving.removeAll(networksToSave);
        }
        catch (IOException e) {
            ViaRomana.LOGGER.error("Failed to save map cache to disk.", (Throwable)e);
        }
    }

    public static void deleteAllMapsFromDisk() {
        block8: {
            ServerMapCache.clear();
            try {
                Path mapDir = ServerMapCache.getMapDirectory();
                if (!Files.exists(mapDir, new LinkOption[0])) break block8;
                try (Stream<Path> stream = Files.walk(mapDir, new FileVisitOption[0]);){
                    stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
                ViaRomana.LOGGER.info("Deleted all map files from disk.");
            }
            catch (IOException e) {
                ViaRomana.LOGGER.error("Failed to delete map directory from disk.", (Throwable)e);
            }
        }
    }

    public static void regenerateAllChunkPixelData() {
        long startTime = System.nanoTime();
        int totalChunks = 0;
        for (class_3218 level : minecraftServer.method_3738()) {
            PathGraph graph = PathGraph.getInstance(level);
            if (graph == null) continue;
            HashSet<class_1923> allChunks = new HashSet<class_1923>();
            for (Map.Entry<UUID, Set<class_1923>> entry : dirtyNetworks.entrySet()) {
                PathGraph.FoWCache fowCache;
                UUID networkId = entry.getKey();
                PathGraph.NetworkCache network = graph.getNetworkCache(networkId);
                if (network == null || (fowCache = graph.getOrComputeFoWCache(network)) == null) continue;
                allChunks.addAll(fowCache.allowedChunks());
            }
            if (allChunks.isEmpty()) continue;
            LevelDataManager.regeneratePixelBytesForChunks(level, allChunks);
            totalChunks += allChunks.size();
        }
        long totalTime = System.nanoTime() - startTime;
        if (CommonConfig.logging_enum.ordinal() > 0) {
            ViaRomana.LOGGER.info("Regenerated all chunk pixel data: {} chunks in {}ms", (Object)totalChunks, (Object)((double)totalTime / 1000000.0));
        }
    }

    private static Path getMapDirectory() {
        return minecraftServer.method_27050(class_5218.field_24188).resolve(MAP_DIR_NAME);
    }

    private static void runSafe(Runnable task, String errorMessage) {
        try {
            task.run();
        }
        catch (Exception e) {
            ViaRomana.LOGGER.error(errorMessage, (Throwable)e);
        }
    }
}

