/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.map;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;

public final class ServerMapUtils {
    public static final float MAP_BOUNDS_PADDING_PERCENTAGE = 0.1f;
    public static final int MAP_BOUNDS_MIN_PADDING = 16;

    private ServerMapUtils() {
    }

    public static int calculateUniformPadding(int contentWidth, int contentHeight) {
        ViaRomana.LOGGER.debug("Calculating uniform padding for content bounds: {}x{}", (Object)contentWidth, (Object)contentHeight);
        int maxDim = Math.max(contentWidth, contentHeight);
        return Math.max(16, (int)((float)maxDim * 0.1f));
    }

    public static Set<class_1923> calculateFogOfWarChunks(Set<Long> nodeLongs, class_1923 minChunk, class_1923 maxChunk, boolean isPseudo) {
        HashSet<class_1923> allowedChunks = new HashSet<class_1923>();
        if (nodeLongs == null || nodeLongs.isEmpty()) {
            ViaRomana.LOGGER.warn("No nodes provided for Fog of War calculation, returning empty set");
            return allowedChunks;
        }
        int FOG_OF_WAR_DISTANCE = CommonConfig.fog_of_war_distance;
        int radiusSq = FOG_OF_WAR_DISTANCE * FOG_OF_WAR_DISTANCE;
        for (Long nodeLong : nodeLongs) {
            for (int dx = -FOG_OF_WAR_DISTANCE; dx <= FOG_OF_WAR_DISTANCE; ++dx) {
                for (int dz = -FOG_OF_WAR_DISTANCE; dz <= FOG_OF_WAR_DISTANCE; ++dz) {
                    if (dx * dx + dz * dz > radiusSq) continue;
                    int tx = (class_2338.method_10061((long)nodeLong) >> 4) + dx;
                    int tz = (class_2338.method_10083((long)nodeLong) >> 4) + dz;
                    if (!isPseudo && (tx < minChunk.field_9181 || tx > maxChunk.field_9181 || tz < minChunk.field_9180 || tz > maxChunk.field_9180)) continue;
                    allowedChunks.add(new class_1923(tx, tz));
                }
            }
        }
        return allowedChunks;
    }
}

