/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_167;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_8779;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.init.StatInit;
import net.rasanovum.viaromana.map.ServerMapCache;
import net.rasanovum.viaromana.network.AbstractPacket;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.path.PathDataManager;
import net.rasanovum.viaromana.util.PathSyncUtils;
import net.rasanovum.viaromana.util.VersionUtils;

public record ChartedPathC2S(List<Node.NodeData> chartedNodes) implements AbstractPacket
{
    public ChartedPathC2S(List<Node.NodeData> chartedNodes) {
        this.chartedNodes = chartedNodes != null ? List.copyOf(chartedNodes) : List.of();
    }

    public ChartedPathC2S(class_2540 buf) {
        this(ChartedPathC2S.readNodes(buf));
    }

    private static List<Node.NodeData> readNodes(class_2540 buf) {
        int nodeCount = buf.readInt();
        ArrayList<Node.NodeData> nodes = new ArrayList<Node.NodeData>(nodeCount);
        for (int i = 0; i < nodeCount; ++i) {
            class_2338 pos = buf.method_10811();
            float quality = buf.readFloat();
            float clearance = buf.readFloat();
            nodes.add(new Node.NodeData(pos, quality, clearance));
        }
        return nodes;
    }

    public void write(class_2540 buf) {
        buf.method_53002(this.chartedNodes.size());
        for (Node.NodeData nodeData : this.chartedNodes) {
            buf.method_10807(nodeData.pos());
            buf.method_52941(nodeData.quality());
            buf.method_52941(nodeData.clearance());
        }
    }

    public void handle(class_1937 level, class_1657 player) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                PathGraph graph = PathGraph.getInstance(serverLevel);
                UUID playerUUID = serverPlayer.method_5667();
                if (this.chartedNodes.isEmpty()) {
                    ViaRomana.LOGGER.warn("Received empty charted path from player {}", (Object)serverPlayer.method_5477().getString());
                    return;
                }
                try {
                    double totalDistance = 0.0;
                    for (int i = 1; i < this.chartedNodes.size(); ++i) {
                        class_2338 prev = this.chartedNodes.get(i - 1).pos();
                        class_2338 curr = this.chartedNodes.get(i).pos();
                        totalDistance += Math.sqrt(prev.method_10262((class_2382)curr));
                    }
                    serverPlayer.method_7342(class_3468.field_15419.method_14956((Object)StatInit.DISTANCE_CHARTED), (int)(totalDistance * 100.0));
                    graph.createConnectedPath(this.chartedNodes);
                    PathDataManager.markDirty(serverLevel);
                    PathSyncUtils.syncPathGraphToAllPlayers(serverLevel);
                    ChartedPathC2S.awardChartingAdvancements(serverPlayer);
                    UUID pseudoNetworkId = ServerMapCache.getPseudoNetworkId(playerUUID);
                    ServerMapCache.invalidatePseudoNetwork(pseudoNetworkId);
                    int totalCharted = serverPlayer.method_14248().method_15025(class_3468.field_15419.method_14956((Object)StatInit.DISTANCE_CHARTED));
                    ViaRomana.LOGGER.debug("Created charted path with {} nodes for player {} ({}m charted, {}m total), cleaned up pseudonetwork {}", (Object)this.chartedNodes.size(), (Object)serverPlayer.method_5477().getString(), (Object)((int)totalDistance), (Object)totalCharted, (Object)pseudoNetworkId);
                }
                catch (Exception e) {
                    ViaRomana.LOGGER.error("Failed to create charted path for player {}: {}", (Object)serverPlayer.method_5477().getString(), (Object)e.getMessage());
                }
            }
        }
    }

    private static void awardChartingAdvancements(class_3222 player) {
        ChartedPathC2S.awardAdvancement(player, "via_romana:story/a_strand_type_game");
        int totalCharted = player.method_14248().method_15025(class_3468.field_15419.method_14956((Object)StatInit.DISTANCE_CHARTED));
        if (totalCharted >= 500000) {
            ChartedPathC2S.awardAdvancement(player, "via_romana:story/straight_up_pathing_it");
        }
    }

    private static void awardAdvancement(class_3222 player, String advancementId) {
        try {
            class_167 advancementProgress;
            class_2960 id = VersionUtils.getLocation(advancementId);
            class_8779 advancement = player.field_13995.method_3851().method_12896(id);
            if (advancement != null && !(advancementProgress = player.method_14236().method_12882(advancement)).method_740()) {
                boolean grantedAny = false;
                for (String criterion : advancementProgress.method_731()) {
                    boolean granted = player.method_14236().method_12878(advancement, criterion);
                    if (!granted) continue;
                    grantedAny = true;
                }
                if (grantedAny) {
                    player.method_14236().method_12876(player);
                }
            }
        }
        catch (Exception e) {
            ViaRomana.LOGGER.warn("Failed to award advancement {} to player {}: {}", (Object)advancementId, (Object)player.method_5477().getString(), (Object)e.getMessage());
        }
    }
}

