/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.path;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.LongPredicate;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;

public class Node {
    private final long pos;
    private final float quality;
    private final int clearance;
    private final LongSet connectedNodes = new LongOpenHashSet();
    private DestinationInfo destinationInfo = null;

    public Node(long pos, float quality, float clearance) {
        int rounded;
        this.pos = pos;
        this.quality = quality;
        if (!Float.isFinite(clearance)) {
            clearance = 0.0f;
        }
        if ((rounded = Math.round(clearance)) < 0) {
            rounded = 0;
        } else if (rounded > 255) {
            rounded = 255;
        }
        this.clearance = rounded;
    }

    public Node(class_2487 tag) {
        this(tag.method_10537("pos"), tag.method_10573("quality", 5) ? tag.method_10583("quality") : 1.0f, tag.method_10573("clearance", 5) ? tag.method_10583("clearance") : (tag.method_10573("clearance", 1) ? (float)Byte.toUnsignedInt(tag.method_10571("clearance")) : 0.0f));
        long[] connections;
        for (long c : connections = tag.method_10565("connections")) {
            this.addConnection(c);
        }
        if (tag.method_10573("destination", 10)) {
            class_2487 destTag = tag.method_10562("destination");
            DestinationInfo dest = this.getOrCreateDestinationInfo();
            dest.linkType = Node.safeEnum(LinkType.class, destTag.method_10558("linkType"), LinkType.NONE);
            dest.signPos = destTag.method_10537("signPos");
            dest.teleportPos = destTag.method_10537("teleportPos");
            if (destTag.method_25928("owner")) {
                dest.privateOwner = destTag.method_25926("owner");
            }
            if (destTag.method_10573("name", 8)) {
                dest.name = destTag.method_10558("name");
            }
            if (destTag.method_10573("icon", 8)) {
                dest.icon = Node.safeEnum(Icon.class, destTag.method_10558("icon"), null);
            }
        }
    }

    public class_2487 serialize(class_2487 tag) {
        tag.method_10544("pos", this.pos);
        tag.method_10567("clearance", (byte)(this.clearance & 0xFF));
        tag.method_10564("connections", this.connectedNodes.toLongArray());
        if (this.destinationInfo != null) {
            class_2487 destTag = new class_2487();
            destTag.method_10582("linkType", this.destinationInfo.linkType.name());
            destTag.method_10544("signPos", this.destinationInfo.signPos);
            destTag.method_10544("teleportPos", this.destinationInfo.teleportPos);
            if (this.destinationInfo.privateOwner != null) {
                destTag.method_25927("owner", this.destinationInfo.privateOwner);
            }
            if (this.destinationInfo.name != null) {
                destTag.method_10582("name", this.destinationInfo.name);
            }
            if (this.destinationInfo.icon != null) {
                destTag.method_10582("icon", this.destinationInfo.icon.name());
            }
            tag.method_10566("destination", (class_2520)destTag);
        }
        return tag;
    }

    public long getPos() {
        return this.pos;
    }

    public class_2338 getBlockPos() {
        return class_2338.method_10092((long)this.pos);
    }

    public float getQuality() {
        return this.quality;
    }

    public float getClearance() {
        return this.clearance;
    }

    @NotNull
    private DestinationInfo getOrCreateDestinationInfo() {
        if (this.destinationInfo == null) {
            this.destinationInfo = new DestinationInfo(this.pos);
        }
        return this.destinationInfo;
    }

    public boolean isLinked() {
        return this.destinationInfo != null;
    }

    public void unlink() {
        this.destinationInfo = null;
    }

    public LinkType getLinkType() {
        return Optional.ofNullable(this.destinationInfo).map(d -> d.linkType).orElse(LinkType.NONE);
    }

    public void setLinkType(LinkType linkType) {
        if (linkType == LinkType.NONE) {
            this.unlink();
            return;
        }
        this.getOrCreateDestinationInfo().linkType = linkType;
        if (linkType != LinkType.PRIVATE) {
            this.getOrCreateDestinationInfo().privateOwner = null;
        }
    }

    public Optional<Long> getSignPos() {
        return Optional.ofNullable(this.destinationInfo).map(d -> d.signPos);
    }

    public void setSignPos(long signPos) {
        this.getOrCreateDestinationInfo().signPos = signPos;
    }

    public long getTeleportPos() {
        return Optional.ofNullable(this.destinationInfo).map(d -> d.teleportPos).orElse(this.pos);
    }

    public void setTeleportPos(long teleportPos) {
        this.getOrCreateDestinationInfo().teleportPos = teleportPos;
    }

    public Optional<UUID> getPrivateOwner() {
        return Optional.ofNullable(this.destinationInfo).map(d -> d.privateOwner);
    }

    public void setPrivateOwner(UUID owner) {
        DestinationInfo dest = this.getOrCreateDestinationInfo();
        dest.privateOwner = owner;
        dest.linkType = owner != null ? LinkType.PRIVATE : LinkType.DESTINATION;
    }

    public Optional<String> getDestinationName() {
        return Optional.ofNullable(this.destinationInfo).map(d -> d.name);
    }

    public void setDestinationName(String name) {
        this.getOrCreateDestinationInfo().name = name;
    }

    public Optional<Icon> getDestinationIcon() {
        return Optional.ofNullable(this.destinationInfo).map(d -> d.icon);
    }

    public void setDestinationIcon(Icon icon) {
        this.getOrCreateDestinationInfo().icon = icon;
    }

    public boolean isAccessibleBy(UUID playerId) {
        if (!this.isLinked()) {
            return false;
        }
        return switch (this.destinationInfo.linkType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> false;
            case 2 -> true;
            case 3 -> Objects.equals(playerId, this.destinationInfo.privateOwner);
        };
    }

    public LongSet getConnectedNodes() {
        return this.connectedNodes;
    }

    public void connect(Node other) {
        if (other == null || other == this) {
            return;
        }
        this.connectedNodes.add(other.pos);
        other.connectedNodes.add(this.pos);
    }

    public void disconnect(Node other) {
        if (other == null) {
            return;
        }
        this.connectedNodes.remove(other.pos);
        other.connectedNodes.remove(this.pos);
    }

    public void addConnection(long otherPos) {
        if (otherPos != this.pos) {
            this.connectedNodes.add(otherPos);
        }
    }

    public void removeConnection(long otherPos) {
        this.connectedNodes.remove(otherPos);
    }

    void removeConnectionIf(LongPredicate predicate) {
        this.connectedNodes.removeIf(predicate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Node{pos=").append(class_2338.method_10092((long)this.pos));
        sb.append(", quality=").append(this.quality);
        sb.append(", neighbors=").append(this.connectedNodes.size());
        if (this.isLinked()) {
            sb.append(", linkType=").append((Object)this.destinationInfo.linkType);
            if (this.destinationInfo.name != null) {
                sb.append(", name=").append(this.destinationInfo.name);
            }
        }
        sb.append("}");
        return sb.toString();
    }

    private static <E extends Enum<E>> E safeEnum(Class<E> type, String name, E fallback) {
        if (name == null || name.isEmpty()) {
            return fallback;
        }
        try {
            return Enum.valueOf(type, name);
        }
        catch (IllegalArgumentException e) {
            return fallback;
        }
    }

    private static class DestinationInfo {
        LinkType linkType = LinkType.NONE;
        long signPos;
        long teleportPos;
        UUID privateOwner = null;
        String name = null;
        Icon icon = null;

        DestinationInfo(long nodePos) {
            this.signPos = nodePos;
            this.teleportPos = nodePos;
        }
    }

    public static enum LinkType {
        NONE,
        ACCESS,
        DESTINATION,
        PRIVATE;

    }

    public static enum Icon {
        SIGNPOST,
        HOUSE,
        SHOP,
        TOWER,
        CAVE,
        CROP,
        PORTAL,
        BOOK;

    }

    public record NodeData(class_2338 pos, float quality, float clearance) {
    }
}

