/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.path;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1767;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.map.ServerMapCache;
import net.rasanovum.viaromana.map.ServerMapUtils;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.storage.path.PathDataManager;
import org.jetbrains.annotations.Nullable;

public final class PathGraph {
    private final ObjectArrayList<Node> nodes = new ObjectArrayList();
    private final Long2IntOpenHashMap posToIndex = new Long2IntOpenHashMap();
    private final Long2IntOpenHashMap signPosToIndex = new Long2IntOpenHashMap();
    private final Long2ObjectOpenHashMap<List<Node>> nodesByChunk = new Long2ObjectOpenHashMap();
    private final Map<UUID, NetworkCache> networkCacheById = new HashMap<UUID, NetworkCache>();
    private final Long2ObjectOpenHashMap<UUID> nodeToNetworkId = new Long2ObjectOpenHashMap();
    private final Map<UUID, FoWCache> fowCacheById = new HashMap<UUID, FoWCache>();
    private final Long2ObjectOpenHashMap<Set<UUID>> chunkToNetworkIds = new Long2ObjectOpenHashMap();
    private final LongOpenHashSet dirtyNodePositions = new LongOpenHashSet();
    private static final class_1767[] NETWORK_COLORS = new class_1767[]{class_1767.field_7966, class_1767.field_7964, class_1767.field_7942, class_1767.field_7945, class_1767.field_7955, class_1767.field_7946, class_1767.field_7961, class_1767.field_7954, class_1767.field_7958, class_1767.field_7947};

    public static PathGraph getInstance(class_3218 level) {
        return PathDataManager.getOrCreatePathGraph(level);
    }

    public NetworkCache getNetworkCacheForNode(Node startNode) {
        NetworkCache cached;
        UUID networkId = (UUID)this.nodeToNetworkId.get(startNode.getPos());
        if (networkId != null && (cached = this.networkCacheById.get(networkId)) != null) {
            return cached;
        }
        return this.discoverAndCacheNetwork(startNode);
    }

    private NetworkCache discoverAndCacheNetwork(Node startNode) {
        List<Node> networkNodes = this.getNetwork(startNode);
        long[] positionsArr = new long[networkNodes.size()];
        for (int i = 0; i < networkNodes.size(); ++i) {
            positionsArr[i] = networkNodes.get(i).getPos();
        }
        UUID networkId = this.generateDeterministicUUID(positionsArr);
        NetworkCache existingCache = this.networkCacheById.get(networkId);
        if (existingCache != null) {
            this.nodeToNetworkId.put(startNode.getPos(), (Object)networkId);
            this.dirtyNodePositions.remove(startNode.getPos());
            return existingCache;
        }
        BoundingBox bounds = this.calculateBoundsFor(networkNodes);
        List<Node> destinations = networkNodes.stream().filter(n -> n.getLinkType() == Node.LinkType.DESTINATION || n.getLinkType() == Node.LinkType.PRIVATE).toList();
        LongOpenHashSet positionsSet = new LongOpenHashSet(positionsArr);
        NetworkCache newCache = new NetworkCache(networkId, (LongSet)positionsSet, bounds, destinations);
        this.networkCacheById.put(networkId, newCache);
        for (long pos : positionsArr) {
            this.nodeToNetworkId.put(pos, (Object)networkId);
            this.dirtyNodePositions.remove(pos);
        }
        this.fowCacheById.remove(networkId);
        this.getOrComputeFoWCache(newCache);
        return newCache;
    }

    private void invalidateNetworksContaining(Node ... nodesToInvalidate) {
        for (Node node : nodesToInvalidate) {
            NetworkCache removedCache;
            List<Node> component = this.getNetwork(node);
            if (component.isEmpty()) continue;
            long[] posArr = new long[component.size()];
            for (int i = 0; i < component.size(); ++i) {
                posArr[i] = component.get(i).getPos();
            }
            UUID componentId = this.generateDeterministicUUID(posArr);
            FoWCache fow = this.fowCacheById.get(componentId);
            if (fow != null) {
                this.removeNetworkFromChunkMap(componentId, fow);
            }
            if ((removedCache = this.networkCacheById.remove(componentId)) != null) {
                this.dirtyNodePositions.addAll((LongCollection)removedCache.nodePositions());
            }
            this.fowCacheById.remove(componentId);
            for (Node n : component) {
                this.nodeToNetworkId.remove(n.getPos());
            }
            ServerMapCache.invalidate(componentId);
        }
    }

    private void refreshNetworkDestinations(Node startNode) {
        NetworkCache existing = this.getNetworkCacheForNode(startNode);
        List<Node> destinations = this.getNetwork(startNode).stream().filter(n -> n.getLinkType() == Node.LinkType.DESTINATION || n.getLinkType() == Node.LinkType.PRIVATE).toList();
        NetworkCache updated = new NetworkCache(existing.id(), existing.nodePositions(), existing.bounds(), destinations);
        this.networkCacheById.put(updated.id(), updated);
    }

    private UUID generateDeterministicUUID(long[] sortedPositions) {
        if (sortedPositions.length == 0) {
            return UUID.randomUUID();
        }
        LongArrays.quickSort((long[])sortedPositions);
        ByteBuffer bb = ByteBuffer.allocate(sortedPositions.length * 8);
        for (long pos : sortedPositions) {
            bb.putLong(pos);
        }
        return UUID.nameUUIDFromBytes(bb.array());
    }

    public class_1767 getNetworkColor(Node node) {
        NetworkCache cache = this.getNetworkCacheForNode(node);
        int colorIndex = Math.abs(cache.id().hashCode() % NETWORK_COLORS.length);
        return NETWORK_COLORS[colorIndex];
    }

    public List<Node> nodesView() {
        return Collections.unmodifiableList(this.nodes);
    }

    public int size() {
        return this.nodes.size();
    }

    public Optional<Node> getNodeAt(class_2338 pos) {
        int idx = this.posToIndex.getOrDefault(pos.method_10063(), -1);
        return idx != -1 ? Optional.of((Node)this.nodes.get(idx)) : Optional.empty();
    }

    public int getOrCreateNode(class_2338 pos, float quality, float clearance) {
        long packedPos = pos.method_10063();
        return this.posToIndex.computeIfAbsent(packedPos, k -> {
            int newIndex = this.nodes.size();
            Node newNode = new Node(packedPos, quality, clearance);
            this.nodes.add((Object)newNode);
            long chunkPos = class_1923.method_8331((int)class_4076.method_18675((int)pos.method_10263()), (int)class_4076.method_18675((int)pos.method_10260()));
            ((List)this.nodesByChunk.computeIfAbsent(chunkPos, c -> new ArrayList())).add(newNode);
            this.dirtyNodePositions.add(packedPos);
            return newIndex;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void createConnectedPath(List<Node.NodeData> pathData) {
        void var4_8;
        if (pathData == null || pathData.size() < 2) {
            return;
        }
        ArrayList<Node> pathNodes = new ArrayList<Node>(pathData.size());
        for (Node.NodeData nodeData : pathData) {
            Node currentNode = (Node)this.nodes.get(this.getOrCreateNode(nodeData.pos(), nodeData.quality(), nodeData.clearance()));
            pathNodes.add(currentNode);
        }
        HashSet<UUID> networksToInvalidate = new HashSet<UUID>();
        for (Node node : pathNodes) {
            UUID networkId = (UUID)this.nodeToNetworkId.get(node.getPos());
            if (networkId == null) continue;
            networksToInvalidate.add(networkId);
        }
        for (UUID networkId : networksToInvalidate) {
            NetworkCache cache;
            FoWCache fow = this.fowCacheById.get(networkId);
            if (fow != null) {
                this.removeNetworkFromChunkMap(networkId, fow);
            }
            if ((cache = this.networkCacheById.remove(networkId)) == null) continue;
            this.fowCacheById.remove(networkId);
            this.dirtyNodePositions.addAll((LongCollection)cache.nodePositions());
            for (Long pos : cache.nodePositions()) {
                this.nodeToNetworkId.remove(pos.longValue());
            }
            ServerMapCache.invalidate(networkId);
        }
        boolean bl = true;
        while (var4_8 < pathNodes.size()) {
            ((Node)pathNodes.get((int)(var4_8 - true))).connect((Node)pathNodes.get((int)var4_8));
            ++var4_8;
        }
        for (Node node : pathNodes) {
            this.dirtyNodePositions.add(node.getPos());
        }
    }

    public void createOrUpdatePseudoNetwork(UUID pseudoNetworkId, List<Node.NodeData> tempNodes) {
        if (tempNodes == null || tempNodes.size() < 2) {
            return;
        }
        NetworkCache existing = this.networkCacheById.remove(pseudoNetworkId);
        if (existing != null) {
            FoWCache fow = this.fowCacheById.get(pseudoNetworkId);
            if (fow != null) {
                this.removeNetworkFromChunkMap(pseudoNetworkId, fow);
            }
            LongIterator longIterator = existing.nodePositions.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                this.nodeToNetworkId.remove(pos);
            }
            this.fowCacheById.remove(pseudoNetworkId);
        }
        LongOpenHashSet nodePositions = new LongOpenHashSet();
        ArrayList<class_2338> posList = new ArrayList<class_2338>(tempNodes.size());
        for (Node.NodeData data : tempNodes) {
            nodePositions.add(data.pos().method_10063());
            posList.add(data.pos());
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (class_2338 pos : posList) {
            minX = Math.min(minX, pos.method_10263());
            minY = Math.min(minY, pos.method_10264());
            minZ = Math.min(minZ, pos.method_10260());
            maxX = Math.max(maxX, pos.method_10263());
            maxY = Math.max(maxY, pos.method_10264());
            maxZ = Math.max(maxZ, pos.method_10260());
        }
        BoundingBox bounds = new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
        NetworkCache pseudoCache = new NetworkCache(pseudoNetworkId, (LongSet)nodePositions, bounds, List.of());
        this.networkCacheById.put(pseudoNetworkId, pseudoCache);
        LongIterator longIterator = nodePositions.iterator();
        while (longIterator.hasNext()) {
            long pos = (Long)longIterator.next();
            this.nodeToNetworkId.put(pos, (Object)pseudoNetworkId);
        }
        this.getOrComputeFoWCache(pseudoCache);
        ViaRomana.LOGGER.debug("Created/updated pseudonetwork {} with {} nodes", (Object)pseudoNetworkId, (Object)tempNodes.size());
    }

    public void removeNode(Node node) {
        this.removeNode(node.getBlockPos());
    }

    public void removeNode(class_2338 pos) {
        long packedPos = pos.method_10063();
        int idx = this.posToIndex.getOrDefault(packedPos, -1);
        if (idx == -1) {
            return;
        }
        Node removedNode = (Node)this.nodes.get(idx);
        this.invalidateNetworksContaining(removedNode);
        LongIterator longIterator = removedNode.getConnectedNodes().iterator();
        while (longIterator.hasNext()) {
            long neighborPos = (Long)longIterator.next();
            this.getNodeAt(class_2338.method_10092((long)neighborPos)).ifPresent(neighbor -> neighbor.removeConnection(packedPos));
        }
        this.removeNodeFromSpatialIndex(removedNode);
        int lastIdx = this.nodes.size() - 1;
        Node lastNode = (Node)this.nodes.get(lastIdx);
        this.nodes.set(idx, (Object)lastNode);
        this.nodes.remove(lastIdx);
        this.posToIndex.remove(packedPos);
        this.dirtyNodePositions.remove(packedPos);
        removedNode.getSignPos().ifPresent(signPos -> this.signPosToIndex.remove(signPos.longValue()));
        if (idx < lastIdx) {
            this.posToIndex.put(lastNode.getPos(), idx);
            lastNode.getSignPos().ifPresent(signPos -> this.signPosToIndex.put(signPos.longValue(), idx));
        }
    }

    public void removeBranch(Node startNode) {
        Set<Node> branchNodes = this.findBranchNodes(startNode);
        if (branchNodes.isEmpty()) {
            return;
        }
        this.invalidateNetworksContaining(startNode);
        LongOpenHashSet branchPositions = new LongOpenHashSet();
        for (Node n : branchNodes) {
            branchPositions.add(n.getPos());
        }
        for (Node node : branchNodes) {
            LongIterator longIterator = node.getConnectedNodes().iterator();
            while (longIterator.hasNext()) {
                long neighborPos = (Long)longIterator.next();
                if (branchPositions.contains(neighborPos)) continue;
                this.getNodeAt(class_2338.method_10092((long)neighborPos)).ifPresent(neighbor -> neighbor.removeConnection(node.getPos()));
            }
            this.removeNodeWithoutNeighborUpdates(node);
        }
    }

    private void removeNodeWithoutNeighborUpdates(Node node) {
        long packedPos = node.getPos();
        int idx = this.posToIndex.getOrDefault(packedPos, -1);
        if (idx == -1) {
            return;
        }
        this.removeNodeFromSpatialIndex(node);
        int lastIdx = this.nodes.size() - 1;
        Node lastNode = (Node)this.nodes.get(lastIdx);
        this.nodes.set(idx, (Object)lastNode);
        this.nodes.remove(lastIdx);
        this.posToIndex.remove(packedPos);
        this.dirtyNodePositions.remove(packedPos);
        node.getSignPos().ifPresent(signPos -> this.signPosToIndex.remove(signPos.longValue()));
        if (idx < lastIdx) {
            this.posToIndex.put(lastNode.getPos(), idx);
            lastNode.getSignPos().ifPresent(signPos -> this.signPosToIndex.put(signPos.longValue(), idx));
        }
    }

    private void removeNodeFromSpatialIndex(Node node) {
        class_2338 p = node.getBlockPos();
        long chunkPos = class_1923.method_8331((int)class_4076.method_18675((int)p.method_10263()), (int)class_4076.method_18675((int)p.method_10260()));
        List chunkNodes = (List)this.nodesByChunk.get(chunkPos);
        if (chunkNodes != null) {
            chunkNodes.remove(node);
            if (chunkNodes.isEmpty()) {
                this.nodesByChunk.remove(chunkPos);
            }
        }
    }

    public void removeAllNodes() {
        for (NetworkCache cache : this.networkCacheById.values()) {
            try {
                ServerMapCache.invalidate(cache.id());
            }
            catch (Exception e) {
                ViaRomana.LOGGER.warn("Failed to invalidate ServerMapCache during clear for {}: {}", (Object)cache.id(), (Object)e.getMessage());
            }
        }
        this.nodes.clear();
        this.posToIndex.clear();
        this.signPosToIndex.clear();
        this.nodesByChunk.clear();
        this.networkCacheById.clear();
        this.nodeToNetworkId.clear();
        this.fowCacheById.clear();
        this.chunkToNetworkIds.clear();
        this.dirtyNodePositions.clear();
    }

    public void linkSignToNode(class_2338 nodePos, class_2338 signPos, Node.LinkType linkType, UUID owner) {
        this.getNodeAt(nodePos).map(node -> {
            node.setSignPos(signPos.method_10063());
            node.setLinkType(linkType);
            if (linkType == Node.LinkType.PRIVATE && owner != null) {
                node.setPrivateOwner(owner);
            }
            this.signPosToIndex.put(signPos.method_10063(), this.posToIndex.get(nodePos.method_10063()));
            this.refreshNetworkDestinations((Node)node);
            return true;
        });
    }

    public void removeSignLink(class_2338 signPos) {
        this.getNodeBySignPos(signPos).map(node -> {
            node.unlink();
            this.signPosToIndex.remove(signPos.method_10063());
            if (CommonConfig.logging_enum.ordinal() > 0) {
                ViaRomana.LOGGER.info("Successfully unlinked sign at {}", (Object)signPos);
            }
            this.refreshNetworkDestinations((Node)node);
            return true;
        });
    }

    public Optional<Node> getNodeBySignPos(class_2338 signPos) {
        int idx = this.signPosToIndex.getOrDefault(signPos.method_10063(), -1);
        return idx != -1 ? Optional.of((Node)this.nodes.get(idx)) : Optional.empty();
    }

    public Optional<Node> getNearestNode(class_2338 origin, double maxDistance) {
        return this.getNearestNode(origin, maxDistance, maxDistance, node -> true);
    }

    public Optional<Node> getNearestNode(class_2338 origin, double maxDistance, Predicate<Node> filter) {
        return this.getNearestNode(origin, maxDistance, maxDistance, filter);
    }

    public Optional<Node> getNearestNode(class_2338 origin, double maxDistance, double maxYDistance, Predicate<Node> filter) {
        int originX = origin.method_10263();
        int originY = origin.method_10264();
        int originZ = origin.method_10260();
        double minDistanceSq = maxDistance * maxDistance;
        int chunkRadius = (int)Math.ceil(maxDistance / 16.0);
        int centerChunkX = class_4076.method_18675((int)originX);
        int centerChunkZ = class_4076.method_18675((int)originZ);
        Node bestNode = null;
        for (int x = -chunkRadius; x <= chunkRadius; ++x) {
            for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                int absChunkX = centerChunkX + x;
                int absChunkZ = centerChunkZ + z;
                long chunkKey = class_1923.method_8331((int)absChunkX, (int)absChunkZ);
                List chunkNodes = (List)this.nodesByChunk.get(chunkKey);
                if (chunkNodes == null || chunkNodes.isEmpty()) continue;
                int chunkMinX = absChunkX << 4;
                int chunkMinZ = absChunkZ << 4;
                int chunkMaxX = chunkMinX + 15;
                int chunkMaxZ = chunkMinZ + 15;
                double dX = 0.0;
                if (originX < chunkMinX) {
                    dX = chunkMinX - originX;
                } else if (originX > chunkMaxX) {
                    dX = originX - chunkMaxX;
                }
                double dZ = 0.0;
                if (originZ < chunkMinZ) {
                    dZ = chunkMinZ - originZ;
                } else if (originZ > chunkMaxZ) {
                    dZ = originZ - chunkMaxZ;
                }
                if (dX * dX + dZ * dZ > minDistanceSq) continue;
                for (Node node : chunkNodes) {
                    class_2338 nodePos;
                    int dy;
                    if (!filter.test(node) || (double)(dy = Math.abs((nodePos = node.getBlockPos()).method_10264() - originY)) > maxYDistance) continue;
                    double dXCentered = (double)nodePos.method_10263() + 0.5 - ((double)originX + 0.5);
                    double dZCentered = (double)nodePos.method_10260() + 0.5 - ((double)originZ + 0.5);
                    double dYCentered = (double)nodePos.method_10264() + 0.5 - ((double)originY + 0.5);
                    double distSq = dXCentered * dXCentered + dYCentered * dYCentered + dZCentered * dZCentered;
                    if (!(distSq <= minDistanceSq)) continue;
                    minDistanceSq = distSq;
                    bestNode = node;
                }
            }
        }
        return Optional.ofNullable(bestNode);
    }

    public List<Node> getNetwork(Node start) {
        ArrayList<Node> network = new ArrayList<Node>();
        LongOpenHashSet visited = new LongOpenHashSet();
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        visited.add(start.getPos());
        queue.add(start);
        while (!queue.isEmpty()) {
            Node current = (Node)queue.poll();
            network.add(current);
            LongIterator longIterator = current.getConnectedNodes().iterator();
            while (longIterator.hasNext()) {
                long neighborPos = (Long)longIterator.next();
                if (!visited.add(neighborPos)) continue;
                this.getNodeAt(class_2338.method_10092((long)neighborPos)).ifPresent(queue::add);
            }
        }
        return network;
    }

    private Set<Node> findBranchNodes(Node start) {
        HashSet<Node> branch = new HashSet<Node>();
        if (start.getConnectedNodes().size() >= 3) {
            branch.add(start);
            return branch;
        }
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        HashSet<Node> visited = new HashSet<Node>();
        queue.add(start);
        visited.add(start);
        while (!queue.isEmpty()) {
            Node current = (Node)queue.poll();
            branch.add(current);
            LongIterator longIterator = current.getConnectedNodes().iterator();
            while (longIterator.hasNext()) {
                long neighborPos = (Long)longIterator.next();
                this.getNodeAt(class_2338.method_10092((long)neighborPos)).ifPresent(neighbor -> {
                    if (visited.add((Node)neighbor) && neighbor.getConnectedNodes().size() < 3) {
                        queue.add((Node)neighbor);
                    }
                });
            }
        }
        return branch;
    }

    public List<Node> getCachedTeleportDestinationsFor(UUID playerId, Node sourceNode) {
        NetworkCache cache = this.getNetworkCacheForNode(sourceNode);
        return cache.destinationNodes().stream().filter(node -> node.getPos() != sourceNode.getPos()).filter(node -> node.isAccessibleBy(playerId)).toList();
    }

    private BoundingBox calculateBoundsFor(List<Node> networkNodes) {
        if (networkNodes.isEmpty()) {
            return BoundingBox.ZERO;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (Node node : networkNodes) {
            class_2338 pos = node.getBlockPos();
            minX = Math.min(minX, pos.method_10263());
            minY = Math.min(minY, pos.method_10264());
            minZ = Math.min(minZ, pos.method_10260());
            maxX = Math.max(maxX, pos.method_10263());
            maxY = Math.max(maxY, pos.method_10264());
            maxZ = Math.max(maxZ, pos.method_10260());
        }
        return new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Nullable
    public NetworkCache getNetworkCache(UUID id) {
        return this.networkCacheById.get(id);
    }

    public NetworkCache getNetworkCache(Node startNode) {
        return this.getNetworkCacheForNode(startNode);
    }

    public List<NetworkCache> findNetworksForChunk(class_1923 chunkPos) {
        this.processDirtyNodes();
        Set networkIds = (Set)this.chunkToNetworkIds.get(chunkPos.method_8324());
        if (networkIds == null || networkIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NetworkCache> result = new ArrayList<NetworkCache>(networkIds.size());
        for (UUID uuid : networkIds) {
            NetworkCache cache = this.networkCacheById.get(uuid);
            if (cache == null) continue;
            result.add(cache);
        }
        return result;
    }

    private void processDirtyNodes() {
        if (this.dirtyNodePositions.isEmpty()) {
            return;
        }
        long[] toProcess = this.dirtyNodePositions.toLongArray();
        this.dirtyNodePositions.clear();
        for (long pos : toProcess) {
            int idx;
            if (this.nodeToNetworkId.containsKey(pos) || (idx = this.posToIndex.getOrDefault(pos, -1)) == -1) continue;
            Node node = (Node)this.nodes.get(idx);
            this.discoverAndCacheNetwork(node);
        }
    }

    public FoWCache getOrComputeFoWCache(NetworkCache network) {
        boolean isPseudo = ServerMapCache.isPseudoNetwork(network.id());
        return this.fowCacheById.computeIfAbsent(network.id(), id -> {
            FoWCache fow = PathGraph.calculateFoWData(network.nodePositions(), isPseudo);
            if (fow != null) {
                this.addNetworkToChunkMap((UUID)id, fow);
            }
            return fow;
        });
    }

    private void addNetworkToChunkMap(UUID networkId, FoWCache fow) {
        for (class_1923 chunk : fow.allowedChunks()) {
            ((Set)this.chunkToNetworkIds.computeIfAbsent(chunk.method_8324(), c -> new HashSet())).add(networkId);
        }
    }

    private void removeNetworkFromChunkMap(UUID networkId, FoWCache fow) {
        for (class_1923 chunk : fow.allowedChunks()) {
            Set ids = (Set)this.chunkToNetworkIds.get(chunk.method_8324());
            if (ids == null) continue;
            ids.remove(networkId);
            if (!ids.isEmpty()) continue;
            this.chunkToNetworkIds.remove(chunk.method_8324());
        }
    }

    public static FoWCache calculateFoWData(LongSet nodeLongs, boolean isPseudo) {
        if (nodeLongs.isEmpty()) {
            return null;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        LongIterator it = nodeLongs.iterator();
        while (it.hasNext()) {
            long nodeLong = it.nextLong();
            int x = class_2338.method_10061((long)nodeLong);
            int y = class_2338.method_10071((long)nodeLong);
            int z = class_2338.method_10083((long)nodeLong);
            minX = Math.min(minX, x);
            minY = Math.min(minY, y);
            minZ = Math.min(minZ, z);
            maxX = Math.max(maxX, x);
            maxY = Math.max(maxY, y);
            maxZ = Math.max(maxZ, z);
        }
        int cacheWidth = maxX - minX;
        int cacheHeight = maxZ - minZ;
        int padding = ServerMapUtils.calculateUniformPadding(cacheWidth, cacheHeight);
        class_2338 paddedMin = new class_2338(minX - padding, minY, minZ - padding);
        class_2338 paddedMax = new class_2338(maxX + padding, maxY, maxZ + padding);
        class_1923 minChunk = new class_1923(paddedMin);
        class_1923 maxChunk = new class_1923(paddedMax);
        Set<class_1923> allowedChunks = ServerMapUtils.calculateFogOfWarChunks((Set<Long>)nodeLongs, minChunk, maxChunk, isPseudo);
        return new FoWCache(minChunk, maxChunk, paddedMin, paddedMax, allowedChunks);
    }

    public List<Node> queryNearby(class_2338 center, double radius) {
        double radiusSquared = radius * radius;
        ArrayList<Node> results = new ArrayList<Node>();
        int chunkRadius = (int)Math.ceil(radius / 16.0);
        int centerChunkX = class_4076.method_18675((int)center.method_10263());
        int centerChunkZ = class_4076.method_18675((int)center.method_10260());
        for (int x = -chunkRadius; x <= chunkRadius; ++x) {
            for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                long chunkKey = class_1923.method_8331((int)(centerChunkX + x), (int)(centerChunkZ + z));
                List chunkNodes = (List)this.nodesByChunk.get(chunkKey);
                if (chunkNodes == null) continue;
                for (Node node : chunkNodes) {
                    if (!(node.getBlockPos().method_10262((class_2382)center) <= radiusSquared)) continue;
                    results.add(node);
                }
            }
        }
        return results;
    }

    public class_2487 serialize(class_2487 root) {
        class_2499 list = new class_2499();
        for (Node node : this.nodes) {
            list.add((Object)node.serialize(new class_2487()));
        }
        root.method_10566("nodes", (class_2520)list);
        return root;
    }

    public void deserialize(class_2487 root) {
        this.removeAllNodes();
        class_2499 list = root.method_10554("nodes", 10);
        for (class_2520 raw : list) {
            class_2487 nodeTag = (class_2487)raw;
            long pos = nodeTag.method_10537("pos");
            if (pos == class_2338.field_10980.method_10063()) continue;
            this.nodes.add((Object)new Node(nodeTag));
        }
        this.rebuildIndices();
    }

    public void rebuildIndices() {
        this.posToIndex.clear();
        this.signPosToIndex.clear();
        this.dirtyNodePositions.clear();
        this.chunkToNetworkIds.clear();
        this.nodesByChunk.clear();
        int i = 0;
        while (i < this.nodes.size()) {
            Node node = (Node)this.nodes.get(i);
            this.posToIndex.put(node.getPos(), i);
            int finalI = i++;
            node.getSignPos().ifPresent(sp -> this.signPosToIndex.put(sp.longValue(), finalI));
            this.dirtyNodePositions.add(node.getPos());
            long chunkPos = class_1923.method_8331((int)class_4076.method_18675((int)node.getBlockPos().method_10263()), (int)class_4076.method_18675((int)node.getBlockPos().method_10260()));
            ((List)this.nodesByChunk.computeIfAbsent(chunkPos, k -> new ArrayList())).add(node);
        }
    }

    public List<DestinationResponseS2C.NodeNetworkInfo> getNodesAsInfo(NetworkCache cache) {
        return cache.getNodesAsInfo(this.posToIndex, this.nodes);
    }

    public List<DestinationResponseS2C.DestinationInfo> getNodesAsDestinationInfo(List<Node> nodes, class_2338 origin) {
        return nodes.stream().map(dest -> {
            double distance = Math.sqrt(origin.method_10262((class_2382)dest.getBlockPos()));
            return new DestinationResponseS2C.DestinationInfo(dest.getBlockPos(), dest.getDestinationName().orElse("Unknown"), distance, dest.getDestinationIcon().orElse(Node.Icon.SIGNPOST));
        }).toList();
    }

    public record NetworkCache(UUID id, LongSet nodePositions, BoundingBox bounds, List<Node> destinationNodes) {
        public NetworkCache {
            if (nodePositions != null) {
                nodePositions = LongSets.unmodifiable((LongSet)nodePositions);
            }
        }

        public List<DestinationResponseS2C.NodeNetworkInfo> getNodesAsInfo(Long2IntOpenHashMap posToIndex, ObjectArrayList<Node> allNodes) {
            ArrayList<DestinationResponseS2C.NodeNetworkInfo> list = new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(this.nodePositions.size());
            LongIterator it = this.nodePositions.iterator();
            while (it.hasNext()) {
                long pos = it.nextLong();
                int index = posToIndex.getOrDefault(pos, -1);
                if (index != -1) {
                    Node node = (Node)allNodes.get(index);
                    ArrayList<class_2338> connections = new ArrayList<class_2338>(node.getConnectedNodes().size());
                    LongIterator longIterator = node.getConnectedNodes().iterator();
                    while (longIterator.hasNext()) {
                        long conn = (Long)longIterator.next();
                        connections.add(class_2338.method_10092((long)conn));
                    }
                    list.add(new DestinationResponseS2C.NodeNetworkInfo(class_2338.method_10092((long)pos), node.getClearance(), connections));
                    continue;
                }
                list.add(new DestinationResponseS2C.NodeNetworkInfo(class_2338.method_10092((long)pos), 0.0f, Collections.emptyList()));
            }
            return list;
        }
    }

    public record BoundingBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        public static final BoundingBox ZERO = new BoundingBox(0, 0, 0, 0, 0, 0);
    }

    public record FoWCache(class_1923 minChunk, class_1923 maxChunk, class_2338 minBlock, class_2338 maxBlock, Set<class_1923> allowedChunks) {
    }
}

