/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.speed;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_5134;
import net.rasanovum.viaromana.speed.SpeedHandler;

public class FieldOfViewHelper {
    public static boolean shouldIgnoreProximitySpeed(class_1657 player) {
        if (class_310.method_1551().field_1690.method_31044().method_31034() && player.method_31550()) {
            return false;
        }
        class_1324 attribute = player.method_5996(class_5134.field_23719);
        return attribute != null && attribute.method_6199(SpeedHandler.PROXIMITY_SPEED_ID) != null;
    }

    public static float getProximityFovCorrection(class_1657 player) {
        class_1324 attribute = player.method_5996(class_5134.field_23719);
        if (attribute == null) {
            return 1.0f;
        }
        double walkSpeed = player.method_31549().method_7253();
        if (walkSpeed == 0.0) {
            return 1.0f;
        }
        double currentSpeed = attribute.method_6194();
        double cleanSpeed = FieldOfViewHelper.calculateAttributeValueSkipping(attribute);
        float currentFactor = (float)((currentSpeed / walkSpeed + 1.0) / 2.0);
        float cleanFactor = (float)((cleanSpeed / walkSpeed + 1.0) / 2.0);
        if (currentFactor == 0.0f) {
            return 1.0f;
        }
        return cleanFactor / currentFactor;
    }

    private static double calculateAttributeValueSkipping(class_1324 attribute) {
        double baseValue = attribute.method_6201();
        Map<class_1322.class_1323, Set> operationToModifiers = Stream.of(class_1322.class_1323.values()).collect(Collectors.toMap(op -> op, op -> Sets.newHashSet()));
        for (class_1322 modifier : attribute.method_6195()) {
            if (modifier.comp_2447().equals((Object)SpeedHandler.PROXIMITY_SPEED_ID)) continue;
            operationToModifiers.get(modifier.comp_2450()).add(modifier);
        }
        for (class_1322 mod : operationToModifiers.get(class_1322.class_1323.field_6328)) {
            baseValue += mod.comp_2449();
        }
        double value = baseValue;
        for (class_1322 mod : operationToModifiers.get(class_1322.class_1323.field_6330)) {
            value += baseValue * mod.comp_2449();
        }
        for (class_1322 mod : operationToModifiers.get(class_1322.class_1323.field_6331)) {
            value *= 1.0 + mod.comp_2449();
        }
        return ((class_1320)attribute.method_6198().comp_349()).method_6165(value);
    }
}

