/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client;

import dev.corgitaco.dataanchor.network.Packet;
import dev.corgitaco.dataanchor.network.broadcast.PacketBroadcaster;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1011;
import net.minecraft.class_2338;
import net.minecraft.class_3620;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.map.MapInfo;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;
import net.rasanovum.viaromana.network.packets.MapRequestC2S;
import net.rasanovum.viaromana.network.packets.MapResponseS2C;

public class MapClient {
    private static CompletableFuture<MapInfo> pendingRequest = null;

    public static CompletableFuture<MapInfo> requestMap(UUID networkId, class_2338 minBounds, class_2338 maxBounds, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes) {
        CompletableFuture<MapInfo> future = new CompletableFuture<MapInfo>();
        pendingRequest = future;
        MapRequestC2S packet = MapRequestC2S.create(networkId, minBounds, maxBounds, networkNodes);
        PacketBroadcaster.C2S.sendToServer((Packet)packet);
        return future;
    }

    public static void handleMapInfo(MapResponseS2C packet) {
        if (CommonConfig.logging_enum.ordinal() > 1) {
            ViaRomana.LOGGER.info("Pending Request: {}", (Object)(pendingRequest != null ? 1 : 0));
        }
        if (pendingRequest != null) {
            pendingRequest.complete(packet.mapInfo());
            pendingRequest = null;
        }
    }

    public static MapTexture createTexture(MapInfo mapInfo) {
        if (mapInfo == null || mapInfo.biomePixels() == null || mapInfo.pixelWidth() == 0 || mapInfo.pixelHeight() == 0) {
            return null;
        }
        try {
            int argb;
            int packedId;
            int idx;
            int x;
            int y;
            long startTime = System.nanoTime();
            int width = mapInfo.pixelWidth();
            int height = mapInfo.pixelHeight();
            byte[] biomePixels = mapInfo.biomePixels();
            byte[] chunkPixels = mapInfo.chunkPixels() != null ? mapInfo.chunkPixels() : new byte[biomePixels.length];
            long createImageStart = System.nanoTime();
            class_1011 biomeImage = new class_1011(width, height, false);
            class_1011 chunkImage = new class_1011(width, height, false);
            long createImageTime = System.nanoTime() - createImageStart;
            long convertStart = System.nanoTime();
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    idx = x + y * width;
                    packedId = biomePixels[idx] & 0xFF;
                    argb = class_3620.method_38480((int)packedId);
                    biomeImage.method_4305(x, y, argb);
                }
            }
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    idx = x + y * width;
                    packedId = chunkPixels[idx] & 0xFF;
                    if (packedId != 0) {
                        argb = class_3620.method_38480((int)packedId);
                        chunkImage.method_4305(x, y, argb);
                        continue;
                    }
                    chunkImage.method_4305(x, y, 0);
                }
            }
            long convertTime = System.nanoTime() - convertStart;
            long totalTime = System.nanoTime() - startTime;
            if (CommonConfig.logging_enum.ordinal() > 1) {
                ViaRomana.LOGGER.info("MapClient: Created raw map images for network {}: total={}ms, create={}ms, convert={}ms, dimensions={}x{}, pixels={}", (Object)mapInfo.networkId(), (Object)((double)totalTime / 1000000.0), (Object)((double)createImageTime / 1000000.0), (Object)((double)convertTime / 1000000.0), (Object)width, (Object)height, (Object)biomePixels.length);
            }
            return new MapTexture(mapInfo, biomeImage, chunkImage);
        }
        catch (Exception e) {
            ViaRomana.LOGGER.error("MapClient: Failed to create texture for network {}: {}", (Object)mapInfo.networkId(), (Object)e.getMessage());
            return null;
        }
    }

    public record MapTexture(MapInfo mapInfo, class_1011 biomeImage, class_1011 chunkImage) implements AutoCloseable
    {
        @Override
        public void close() {
            if (this.biomeImage != null) {
                this.biomeImage.close();
            }
            if (this.chunkImage != null) {
                this.chunkImage.close();
            }
        }
    }
}

