/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.corgitaco.dataanchor.network.Packet;
import dev.corgitaco.dataanchor.network.broadcast.PacketBroadcaster;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.rasanovum.viaromana.client.ClientConfigCache;
import net.rasanovum.viaromana.client.core.PathRecord;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.client.gui.elements.MapActionButton;
import net.rasanovum.viaromana.client.gui.elements.MapSquareButton;
import net.rasanovum.viaromana.network.packets.RoutedActionC2S;
import net.rasanovum.viaromana.storage.player.PlayerData;
import net.rasanovum.viaromana.util.PathUtils;
import net.rasanovum.viaromana.util.VersionUtils;

@Environment(value=EnvType.CLIENT)
public class ChartingScreen
extends class_437 {
    private static final int BACKGROUND_WIDTH = 256;
    private static final int BACKGROUND_HEIGHT = 256;
    private static final int USABLE_WIDTH = 230;
    private static final int USABLE_HEIGHT = 180;
    private static final int PADDING = 10;
    private static final int SMALL_BUTTON_SIZE = 64;
    private static final int LARGE_BUTTON_SIZE = 80;
    private ScreenState currentScreenState = ScreenState.IDLE;
    private int tutorialPage = 0;
    private MapSquareButton severPathButton;
    private MapSquareButton deleteBranchButton;
    private MapSquareButton chartStartButton;
    private MapSquareButton chartFinishButton;
    private MapSquareButton sealApproveButton;
    private MapSquareButton sealCancelButton;
    private MapActionButton cancelChartingButton;
    private MapActionButton exitTutorialButton;
    private MapActionButton tutorialButton;
    private MapActionButton tutorialBackButton;
    private MapActionButton tutorialNextButton;
    private int panelX;
    private int panelY;
    private int usableX;
    private int usableY;
    private int textBoundsTopY;
    private int textBoundsHeight;
    private boolean isNearNode = false;
    private boolean hasGoodInfrastructure = false;
    private float currentInfrastructureQuality = 0.0f;

    public ChartingScreen(class_2561 title) {
        super(title);
    }

    protected void method_25426() {
        super.method_25426();
        this.calculateLayout();
        this.createWidgets();
        this.updateNearNodeStatus();
        this.updateInfrastructureStatus();
        this.syncScreenState();
    }

    public void renderBackground(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackgroundTexture(guiGraphics);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.renderHeader(guiGraphics);
        if (this.currentScreenState == ScreenState.TUTORIAL) {
            this.renderTutorialContent(guiGraphics);
        } else if (this.currentScreenState == ScreenState.DELETE_APPROVAL) {
            this.field_22787.method_1522().method_1235(false);
            guiGraphics.method_25296(0, 0, this.field_22789, this.field_22790, Integer.MIN_VALUE, Integer.MIN_VALUE);
            this.renderApprovalText(guiGraphics);
            this.withSealButtonsVisible(() -> {
                this.sealApproveButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                this.sealCancelButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            });
        }
        if (this.currentScreenState == ScreenState.TUTORIAL) {
            this.renderComponentTooltip(guiGraphics, mouseX, mouseY);
        }
    }

    private void renderBackgroundTexture(class_332 guiGraphics) {
        RenderSystem.enableBlend();
        guiGraphics.method_25290(Textures.BACKGROUND, this.panelX, this.panelY, 0.0f, 0.0f, 256, 256, 256, 256);
        if (this.currentScreenState == ScreenState.CHARTING) {
            guiGraphics.method_25290(Textures.CHARTING_OVERLAY, this.panelX, this.panelY, 0.0f, 0.0f, 256, 256, 256, 256);
        }
        RenderSystem.disableBlend();
    }

    private void renderHeader(class_332 guiGraphics) {
        class_5250 statusMessage = this.currentScreenState == ScreenState.CHARTING ? class_2561.method_43471((String)"gui.viaromana.charting_in_progress") : (this.currentScreenState == ScreenState.TUTORIAL ? class_2561.method_43471((String)"gui.viaromana.tutorial_title") : class_2561.method_43471((String)"gui.viaromana.charting_map"));
        int barY = this.panelY + 10 + 40;
        int barColor = -12837376;
        int textWidth = this.field_22793.method_27525((class_5348)statusMessage);
        int textX = this.usableX + (230 - textWidth) / 2;
        Objects.requireNonNull(this.field_22793);
        int textY = barY - 9 / 2 + 1;
        int barPadding = 6;
        guiGraphics.method_25294(this.usableX, barY, textX - barPadding, barY + 1, barColor);
        guiGraphics.method_25294(textX + textWidth + barPadding, barY, this.usableX + 230, barY + 1, barColor);
        guiGraphics.method_51439(this.field_22793, (class_2561)statusMessage, textX, textY, barColor, false);
    }

    private void renderApprovalText(class_332 guiGraphics) {
        class_5250 messageComponent = class_2561.method_43471((String)"gui.viaromana.delete_branch_confirmation");
        int textY = this.usableY + 21;
        this.renderWrappedCenteredText(guiGraphics, (class_2561)messageComponent, textY, 310, 1.5f, -1);
    }

    private void renderTutorialContent(class_332 guiGraphics) {
        class_2960 tutorialImage;
        switch (this.tutorialPage) {
            case 0: {
                class_2960 class_29602 = Textures.TUTORIAL_1;
                break;
            }
            case 1: {
                class_2960 class_29602 = Textures.TUTORIAL_2;
                break;
            }
            case 2: {
                class_2960 class_29602 = Textures.TUTORIAL_3;
                break;
            }
            case 3: {
                class_2960 class_29602 = Textures.TUTORIAL_4;
                break;
            }
            case 4: {
                class_2960 class_29602 = Textures.TUTORIAL_5;
                break;
            }
            case 5: {
                class_2960 class_29602 = Textures.TUTORIAL_6;
                break;
            }
            case 6: {
                class_2960 class_29602 = Textures.TUTORIAL_7;
                break;
            }
            case 7: {
                class_2960 class_29602 = Textures.TUTORIAL_8;
                break;
            }
            default: {
                class_2960 class_29602 = tutorialImage = null;
            }
        }
        if (tutorialImage == null) {
            return;
        }
        int imageWidth = 200;
        int imageHeight = 120;
        int imageX = this.usableX + (230 - imageWidth) / 2;
        int imageY = this.usableY + 10;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        guiGraphics.method_25290(tutorialImage, imageX, imageY, 0.0f, 0.0f, imageWidth, imageHeight, imageWidth, imageHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_2561 tutorialMessage = this.getTutorialMessage();
        imageHeight = 96;
        if (tutorialMessage != class_2561.method_43473()) {
            int textTopY = this.usableY + imageHeight + 20 + 8;
            int textHeight = 180 - imageHeight - 40 - 16;
            this.textBoundsTopY = textTopY;
            this.textBoundsHeight = textHeight;
            int textCenterY = textTopY + textHeight / 2;
            int textColor = -12837376;
            this.renderWrappedCenteredText(guiGraphics, tutorialMessage, textCenterY, 220, 1.0f, textColor);
        }
    }

    private void renderWrappedCenteredText(class_332 guiGraphics, class_2561 text, int centerY, int maxWidth, float scale, int color) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_22905(scale, scale, 1.0f);
        int scaledMaxWidth = (int)((float)maxWidth / scale);
        List lines = this.field_22793.method_1728((class_5348)text, scaledMaxWidth);
        if (lines.isEmpty()) {
            guiGraphics.method_51448().method_22909();
            return;
        }
        int lineSpacing = 1;
        int n = lines.size();
        Objects.requireNonNull(this.field_22793);
        int totalTextHeight = n * 9 + (lines.size() - 1) * lineSpacing;
        int startY = (int)((float)centerY / scale - (float)totalTextHeight / 2.0f);
        int centerX = (int)(((float)this.usableX + 115.0f) / scale);
        for (int i = 0; i < lines.size(); ++i) {
            class_5481 line = (class_5481)lines.get(i);
            Objects.requireNonNull(this.field_22793);
            int lineY = startY + i * (9 + lineSpacing);
            int lineWidth = this.field_22793.method_30880(line);
            guiGraphics.method_51430(this.field_22793, line, centerX - lineWidth / 2, lineY, color, false);
        }
        guiGraphics.method_51448().method_22909();
    }

    private void renderComponentTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        class_2583 style;
        if (mouseX >= this.usableX && mouseX < this.usableX + 230 && mouseY >= this.textBoundsTopY && mouseY < this.textBoundsTopY + this.textBoundsHeight && (style = this.getStyleAt(mouseX, mouseY)) != null && style.method_10969() != null) {
            guiGraphics.method_51441(this.field_22793, style, mouseX, mouseY);
        }
    }

    private class_2583 getStyleAt(double mouseX, double mouseY) {
        class_5481 line;
        int lineWidth;
        int centerX;
        int lineStartX;
        class_2561 tutorialMessage = this.getTutorialMessage();
        if (tutorialMessage == class_2561.method_43473()) {
            return null;
        }
        int maxWidth = 220;
        List lines = this.field_22793.method_1728((class_5348)tutorialMessage, maxWidth);
        int n = lines.size();
        Objects.requireNonNull(this.field_22793);
        int totalTextHeight = n * 9;
        int startY = this.textBoundsTopY + this.textBoundsHeight / 2 - totalTextHeight / 2;
        double d = mouseY - (double)startY;
        Objects.requireNonNull(this.field_22793);
        int hoveredLineIndex = (int)(d / 9.0);
        if (hoveredLineIndex >= 0 && hoveredLineIndex < lines.size() && mouseX >= (double)(lineStartX = (centerX = this.usableX + 115) - (lineWidth = this.field_22793.method_30880(line = (class_5481)lines.get(hoveredLineIndex))) / 2) && mouseX <= (double)(lineStartX + lineWidth)) {
            return this.field_22793.method_27527().method_30876(line, (int)(mouseX - (double)lineStartX));
        }
        return null;
    }

    private class_2561 getTutorialMessage() {
        return switch (this.tutorialPage) {
            case 0 -> class_2561.method_43471((String)"gui.viaromana.tutorial_page_1");
            case 1 -> {
                class_5250 tooltipText = class_2561.method_43471((String)"gui.viaromana.tooltip.infrastructure");
                class_2568 hoverEvent = new class_2568(class_2568.class_5247.field_24342, (Object)tooltipText);
                class_5250 infrastructureTerm = class_2561.method_43471((String)"gui.viaromana.tutorial_infrastructure_term").method_10862(class_2583.field_24360.method_10949(hoverEvent).method_30938(Boolean.valueOf(true)));
                int requiredAmount = (int)Math.ceil((float)(ClientConfigCache.infrastructureCheckRadius * 2 + 1) * ClientConfigCache.pathQualityThreshold);
                yield ChartingScreen.tooltipFromPlaceholder(class_1074.method_4662((String)"gui.viaromana.tutorial_page_2", (Object[])new Object[]{requiredAmount}), (class_2561)infrastructureTerm);
            }
            case 2 -> class_2561.method_43471((String)"gui.viaromana.tutorial_page_3");
            case 3 -> class_2561.method_43471((String)"gui.viaromana.tutorial_page_4");
            case 4 -> class_2561.method_43471((String)"gui.viaromana.tutorial_page_5");
            case 5 -> class_2561.method_43471((String)"gui.viaromana.tutorial_page_6");
            case 6 -> class_2561.method_43471((String)"gui.viaromana.tutorial_page_7");
            case 7 -> class_2561.method_43471((String)"gui.viaromana.tutorial_page_8");
            default -> class_2561.method_43473();
        };
    }

    public static class_2561 tooltipFromPlaceholder(String rawString, class_2561 styledTerm) {
        String[] parts = rawString.split("!", 2);
        if (parts.length == 2) {
            return class_2561.method_43470((String)parts[0]).method_10852(styledTerm).method_10852((class_2561)class_2561.method_43470((String)parts[1]));
        }
        return class_2561.method_43470((String)rawString);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_16014(double mouseX, double mouseY) {
        if (this.currentScreenState == ScreenState.DELETE_APPROVAL) {
            this.withSealButtonsVisible(() -> {
                this.sealApproveButton.method_16014(mouseX, mouseY);
                this.sealCancelButton.method_16014(mouseX, mouseY);
            });
        }
        super.method_16014(mouseX, mouseY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.currentScreenState == ScreenState.DELETE_APPROVAL && button == 0) {
            boolean[] handled = new boolean[]{false};
            this.withSealButtonsVisible(() -> {
                if (this.sealApproveButton.method_25402(mouseX, mouseY, button) || this.sealCancelButton.method_25402(mouseX, mouseY, button)) {
                    handled[0] = true;
                }
            });
            if (handled[0]) {
                return true;
            }
        }
        if (button == 1) {
            Objects.requireNonNull(this.field_22787).method_1507(null);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void sendRoutedAction(RoutedActionC2S.Operation operation) {
        PacketBroadcaster.C2S.sendToServer((Packet)new RoutedActionC2S(operation));
        Objects.requireNonNull(this.field_22787).method_1507(null);
    }

    private void withSealButtonsVisible(Runnable action) {
        boolean wasApproveVisible = this.sealApproveButton.field_22764;
        boolean wasCancelVisible = this.sealCancelButton.field_22764;
        this.sealApproveButton.field_22764 = true;
        this.sealCancelButton.field_22764 = true;
        action.run();
        this.sealApproveButton.field_22764 = wasApproveVisible;
        this.sealCancelButton.field_22764 = wasCancelVisible;
    }

    private void updateNearNodeStatus() {
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        double utilityDistance = ClientConfigCache.nodeUtilityDistance;
        this.isNearNode = ClientPathData.getInstance().getNearestNode(this.field_22787.field_1724.method_24515(), utilityDistance, false).isPresent();
    }

    private void updateInfrastructureStatus() {
        if (this.field_22787 == null || this.field_22787.field_1724 == null || this.field_22787.field_1687 == null) {
            return;
        }
        this.currentInfrastructureQuality = PathUtils.calculateInfrastructureQuality((class_1936)this.field_22787.field_1687, (class_1297)this.field_22787.field_1724);
        float threshold = ClientConfigCache.pathQualityThreshold;
        this.hasGoodInfrastructure = this.currentInfrastructureQuality >= threshold;
    }

    private void setState(ScreenState newState) {
        this.currentScreenState = newState;
        this.updateWidgetStates();
    }

    private void syncScreenState() {
        boolean isPlayerCharting = PlayerData.isChartingPath((class_1657)this.field_22787.field_1724);
        if (isPlayerCharting && this.currentScreenState == ScreenState.IDLE) {
            this.setState(ScreenState.CHARTING);
        } else if (!isPlayerCharting && this.currentScreenState == ScreenState.CHARTING) {
            this.setState(ScreenState.IDLE);
        } else {
            this.updateWidgetStates();
        }
    }

    private void updateWidgetStates() {
        boolean isIdle = this.currentScreenState == ScreenState.IDLE;
        boolean isCharting = this.currentScreenState == ScreenState.CHARTING;
        boolean isApproving = this.currentScreenState == ScreenState.DELETE_APPROVAL;
        boolean isTutorial = this.currentScreenState == ScreenState.TUTORIAL;
        this.severPathButton.field_22764 = !isTutorial;
        this.deleteBranchButton.field_22764 = !isTutorial;
        this.chartStartButton.field_22764 = isIdle || isApproving;
        this.chartFinishButton.field_22764 = isCharting;
        this.sealApproveButton.field_22764 = false;
        this.sealCancelButton.field_22764 = false;
        this.cancelChartingButton.field_22764 = isCharting;
        this.exitTutorialButton.field_22764 = isTutorial;
        this.tutorialButton.field_22764 = isIdle;
        this.tutorialBackButton.field_22764 = isTutorial && this.tutorialPage > 0;
        this.tutorialNextButton.field_22764 = isTutorial && this.tutorialPage < 7;
        this.severPathButton.setFrozen(isApproving);
        this.deleteBranchButton.setFrozen(isApproving);
        this.chartStartButton.setFrozen(isApproving);
        this.severPathButton.setDisabled(!isIdle || !this.isNearNode);
        this.deleteBranchButton.setDisabled(!isIdle || !this.isNearNode);
        this.chartStartButton.setDisabled(!isIdle || !this.hasGoodInfrastructure);
        this.updateTooltips();
    }

    private void updateTooltips() {
        if (this.currentScreenState == ScreenState.CHARTING) {
            this.severPathButton.setTooltips((class_2561)class_2561.method_43471((String)"gui.viaromana.sever_path_tooltip"), (class_2561)class_2561.method_43471((String)"gui.viaromana.sever_path_disabled_charting"));
            this.deleteBranchButton.setTooltips((class_2561)class_2561.method_43471((String)"gui.viaromana.delete_branch_tooltip"), (class_2561)class_2561.method_43471((String)"gui.viaromana.delete_branch_disabled_charting"));
        } else if (!this.isNearNode) {
            double utilityDistance = ClientConfigCache.nodeUtilityDistance;
            class_5250 tooltip = class_2561.method_43469((String)"gui.viaromana.node_distance_tooltip", (Object[])new Object[]{utilityDistance});
            this.severPathButton.setTooltips((class_2561)class_2561.method_43471((String)"gui.viaromana.sever_path_tooltip"), (class_2561)tooltip);
            this.deleteBranchButton.setTooltips((class_2561)class_2561.method_43471((String)"gui.viaromana.delete_branch_tooltip"), (class_2561)tooltip);
        } else {
            this.severPathButton.setTooltip((class_2561)class_2561.method_43471((String)"gui.viaromana.sever_path_tooltip"));
            this.deleteBranchButton.setTooltip((class_2561)class_2561.method_43471((String)"gui.viaromana.delete_branch_tooltip"));
        }
        if (!this.hasGoodInfrastructure) {
            float threshold = ClientConfigCache.pathQualityThreshold;
            int areaCheck = ClientConfigCache.infrastructureCheckRadius * 2 + 1;
            areaCheck *= areaCheck;
            int requiredBlocks = (int)Math.ceil(threshold * (float)areaCheck);
            int currentBlocks = Math.round(this.currentInfrastructureQuality * (float)areaCheck);
            this.chartStartButton.setTooltips(this.getChartStartTooltip(), (class_2561)class_2561.method_43469((String)"gui.viaromana.infrastructure_insufficient", (Object[])new Object[]{currentBlocks, requiredBlocks}));
        } else {
            this.chartStartButton.setTooltip(this.getChartStartTooltip());
        }
        if (this.currentScreenState == ScreenState.DELETE_APPROVAL) {
            this.sealApproveButton.setTooltip((class_2561)class_2561.method_43471((String)"gui.viaromana.approve_deleting"));
            this.sealCancelButton.setTooltip((class_2561)class_2561.method_43471((String)"gui.viaromana.cancel_deleting"));
        }
    }

    private class_2561 getChartStartTooltip() {
        return class_2561.method_43471((String)(!this.isNearNode ? "gui.viaromana.chart_start_tooltip" : "gui.viaromana.chart_continue_tooltip"));
    }

    private void calculateLayout() {
        this.panelX = (this.field_22789 - 256) / 2;
        this.panelY = (this.field_22790 - 256) / 2;
        this.usableX = this.panelX + 13;
        this.usableY = this.panelY + 38 + 7;
    }

    private void createWidgets() {
        this.severPathButton = this.createSeverPathButton();
        this.method_37063((class_364)this.severPathButton);
        this.deleteBranchButton = this.createDeleteBranchButton();
        this.method_37063((class_364)this.deleteBranchButton);
        this.chartStartButton = this.createChartStartButton();
        this.method_37063((class_364)this.chartStartButton);
        this.chartFinishButton = this.createChartFinishButton();
        this.method_37063((class_364)this.chartFinishButton);
        this.sealApproveButton = this.createSealApproveButton();
        this.method_37063((class_364)this.sealApproveButton);
        this.sealCancelButton = this.createSealCancelButton();
        this.method_37063((class_364)this.sealCancelButton);
        this.cancelChartingButton = this.createCancelChartingButton();
        this.method_37063((class_364)this.cancelChartingButton);
        this.exitTutorialButton = this.createExitTutorialButton();
        this.method_37063((class_364)this.exitTutorialButton);
        this.tutorialButton = this.createTutorialButton();
        this.method_37063((class_364)this.tutorialButton);
        this.tutorialBackButton = this.createTutorialBackButton();
        this.method_37063((class_364)this.tutorialBackButton);
        this.tutorialNextButton = this.createTutorialNextButton();
        this.method_37063((class_364)this.tutorialNextButton);
    }

    private MapSquareButton createSeverPathButton() {
        return new MapSquareButton.Builder(this.usableX + 10, this.usableY + 10, 64, 64, (class_2561)class_2561.method_43471((String)"gui.viaromana.sever_path_button"), button -> this.sendRoutedAction(RoutedActionC2S.Operation.SEVER_NEAREST_NODE)).tooltip((class_2561)class_2561.method_43471((String)"gui.viaromana.sever_path_tooltip")).image(Textures.SEVER_PATH_FRAME, 64, 64).animation(Textures.SEVER_PATH_TILE, 7).soundEffect(Sounds.SEVER_PATH).initialHover(0, 6, false).hoverLoop(6, 6, false).mouseOff(6, 0, true).fixedTooltipPosition(true).build();
    }

    private MapSquareButton createDeleteBranchButton() {
        return new MapSquareButton.Builder(this.usableX + 230 - 64 - 10, this.usableY + 10, 64, 64, (class_2561)class_2561.method_43471((String)"gui.viaromana.remove_branch_button"), button -> this.setState(ScreenState.DELETE_APPROVAL)).tooltip((class_2561)class_2561.method_43471((String)"gui.viaromana.delete_branch_detailed_tooltip")).image(Textures.DELETE_BRANCH_FRAME, 64, 64).animation(Textures.DELETE_BRANCH_TILE, 12).soundEffect(Sounds.DELETE_BRANCH_PROMPT).initialHover(0, 11, false).hoverLoop(11, 11, false).mouseOff(9, 0, true).fixedTooltipPosition(true).build();
    }

    private MapSquareButton createChartStartButton() {
        return new MapSquareButton.Builder(this.usableX + 75, this.usableY + 180 - 80 - 10, 80, 80, (class_2561)class_2561.method_43471((String)"gui.viaromana.message.via_romana.start_charting_button"), button -> {
            PathRecord.start(this.field_22787.field_1687, this.field_22787.field_1724, this.field_22787.field_1724.method_24515());
            this.field_22787.method_1507(null);
        }).tooltip(this.getChartStartTooltip()).image(Textures.CHART_START_FRAME, 80, 80).animation(Textures.CHART_START_TILE, 18).soundEffect(Sounds.START_CHARTING).initialHover(0, 5, false).hoverLoop(6, 17, false).mouseOff(5, 0, true).fixedTooltipPosition(true).build();
    }

    private MapSquareButton createChartFinishButton() {
        return new MapSquareButton.Builder(this.usableX + 75, this.usableY + 180 - 80 - 10, 80, 80, (class_2561)class_2561.method_43471((String)"gui.viaromana.message.via_romana.finish_charting_button"), button -> {
            PathRecord.end(this.field_22787.field_1687, this.field_22787.field_1724, this.field_22787.field_1724.method_24515());
            this.field_22787.method_1507(null);
        }).tooltip((class_2561)class_2561.method_43471((String)(!this.isNearNode ? "gui.viaromana.message.via_romana.finish_charting_tooltip" : "gui.viaromana.message.via_romana.finish_charting_nearby_tooltip"))).image(Textures.CHART_FINISH_FRAME, 80, 80).animation(Textures.CHART_FINISH_TILE, 7).soundEffect(Sounds.START_CHARTING).initialHover(0, 6, false).hoverLoop(6, 6, false).mouseOff(6, 0, true).fixedTooltipPosition(true).build();
    }

    private MapActionButton createCancelChartingButton() {
        int btnWidth = 60;
        int btnHeight = 16;
        return new MapActionButton(this.usableX + 230 - btnWidth - 10 + 10, this.usableY + 180 - btnHeight - 10, btnWidth, btnHeight, (class_2561)class_2561.method_43471((String)"gui.viaromana.cancel_button"), (class_2561)class_2561.method_43471((String)"gui.viaromana.message.via_romana.cancel_charting_tooltip"), button -> {
            PathRecord.cancel(this.field_22787.field_1687, this.field_22787.field_1724, true);
            this.field_22787.method_1507(null);
        }, Textures.MAP_CANCEL);
    }

    private MapActionButton createTutorialButton() {
        int btnWidth = 62;
        int btnHeight = 16;
        return new MapActionButton(this.usableX + 230 - btnWidth - 10 + 10, this.usableY + 180 - btnHeight - 10, btnWidth, btnHeight, (class_2561)class_2561.method_43471((String)"gui.viaromana.tutorial_title"), (class_2561)class_2561.method_43471((String)"gui.viaromana.tutorial_tooltip"), button -> this.setState(ScreenState.TUTORIAL), Textures.MAP_TUTORIAL);
    }

    private MapActionButton createExitTutorialButton() {
        int btnWidth = 60;
        int btnHeight = 16;
        return new MapActionButton(this.usableX + 230 - btnWidth - 10 + 10, this.usableY + 180 - btnHeight - 10, btnWidth, btnHeight, (class_2561)class_2561.method_43471((String)"gui.viaromana.exit_tutorial_button"), (class_2561)class_2561.method_43471((String)"gui.viaromana.exit_tutorial_tooltip"), button -> {
            this.setState(ScreenState.IDLE);
            this.tutorialPage = 0;
        }, Textures.MAP_TUTORIAL_RETURN);
    }

    private MapActionButton createTutorialBackButton() {
        int btnWidth = 20;
        int btnHeight = 16;
        return new MapActionButton(this.usableX + 10 + 76, this.usableY + 180 - btnHeight - 10, btnWidth, btnHeight, button -> {
            if (this.tutorialPage > 0) {
                --this.tutorialPage;
                this.updateWidgetStates();
            }
        }, Textures.MAP_TUTORIAL_BACK);
    }

    private MapActionButton createTutorialNextButton() {
        int btnWidth = 20;
        int btnHeight = 16;
        return new MapActionButton(this.usableX + 10 + 117, this.usableY + 180 - btnHeight - 10, btnWidth, btnHeight, button -> {
            ++this.tutorialPage;
            this.updateWidgetStates();
        }, Textures.MAP_TUTORIAL_NEXT);
    }

    private MapSquareButton createSealApproveButton() {
        int sealY = this.usableY + 180 - 80 - 10 - 48;
        int centerX = this.usableX + 115;
        return new MapSquareButton.Builder(centerX - 80 - 10, sealY, 80, 80, (class_2561)class_2561.method_43471((String)"gui.viaromana.confirm_button"), button -> this.sendRoutedAction(RoutedActionC2S.Operation.REMOVE_BRANCH)).image(Textures.SEAL_APPROVE, 80, 80).soundEffect(Sounds.DELETE_BRANCH_CONFIRM).fixedTooltipPosition(true).hoverBrightness(1.2f).build();
    }

    private MapSquareButton createSealCancelButton() {
        int sealY = this.usableY + 180 - 80 - 10 - 48;
        int centerX = this.usableX + 115;
        return new MapSquareButton.Builder(centerX + 10, sealY, 80, 80, (class_2561)class_2561.method_43471((String)"gui.viaromana.cancel_button"), button -> this.setState(ScreenState.IDLE)).image(Textures.SEAL_CANCEL, 80, 80).soundEffect(Sounds.DELETE_BRANCH_CANCEL).fixedTooltipPosition(true).hoverBrightness(1.2f).build();
    }

    private static enum ScreenState {
        IDLE,
        CHARTING,
        DELETE_APPROVAL,
        TUTORIAL;

    }

    private static final class Textures {
        static final class_2960 BACKGROUND = VersionUtils.getLocation("via_romana:textures/screens/background_map.png");
        static final class_2960 CHARTING_OVERLAY = VersionUtils.getLocation("via_romana:textures/screens/background_map_charting.png");
        static final class_2960 MAP_CANCEL = VersionUtils.getLocation("via_romana:textures/screens/element_cancel.png");
        static final class_2960 MAP_TUTORIAL = VersionUtils.getLocation("via_romana:textures/screens/element_tutorial.png");
        static final class_2960 MAP_TUTORIAL_BACK = VersionUtils.getLocation("via_romana:textures/screens/element_tutorial_back.png");
        static final class_2960 MAP_TUTORIAL_NEXT = VersionUtils.getLocation("via_romana:textures/screens/element_tutorial_next.png");
        static final class_2960 MAP_TUTORIAL_RETURN = VersionUtils.getLocation("via_romana:textures/screens/element_return.png");
        static final class_2960 CHART_START_TILE = VersionUtils.getLocation("via_romana:textures/screens/chart_start_tile.png");
        static final class_2960 CHART_START_FRAME = VersionUtils.getLocation("via_romana:textures/screens/chart_start_frame.png");
        static final class_2960 CHART_FINISH_TILE = VersionUtils.getLocation("via_romana:textures/screens/chart_finish_tile.png");
        static final class_2960 CHART_FINISH_FRAME = VersionUtils.getLocation("via_romana:textures/screens/chart_finish_frame.png");
        static final class_2960 SEVER_PATH_TILE = VersionUtils.getLocation("via_romana:textures/screens/chart_sever_tile.png");
        static final class_2960 SEVER_PATH_FRAME = VersionUtils.getLocation("via_romana:textures/screens/chart_sever_frame.png");
        static final class_2960 DELETE_BRANCH_TILE = VersionUtils.getLocation("via_romana:textures/screens/chart_delete_branch_tile.png");
        static final class_2960 DELETE_BRANCH_FRAME = VersionUtils.getLocation("via_romana:textures/screens/chart_delete_branch_frame.png");
        static final class_2960 SEAL_APPROVE = VersionUtils.getLocation("via_romana:textures/screens/seal_approve.png");
        static final class_2960 SEAL_CANCEL = VersionUtils.getLocation("via_romana:textures/screens/seal_cancel.png");
        static final class_2960 TUTORIAL_1 = VersionUtils.getLocation("via_romana:textures/screens/tutorial_1.png");
        static final class_2960 TUTORIAL_2 = VersionUtils.getLocation("via_romana:textures/screens/tutorial_2.png");
        static final class_2960 TUTORIAL_3 = VersionUtils.getLocation("via_romana:textures/screens/tutorial_3.png");
        static final class_2960 TUTORIAL_4 = VersionUtils.getLocation("via_romana:textures/screens/tutorial_4.png");
        static final class_2960 TUTORIAL_5 = VersionUtils.getLocation("via_romana:textures/screens/tutorial_5.png");
        static final class_2960 TUTORIAL_6 = VersionUtils.getLocation("via_romana:textures/screens/tutorial_6.png");
        static final class_2960 TUTORIAL_7 = VersionUtils.getLocation("via_romana:textures/screens/tutorial_7.png");
        static final class_2960 TUTORIAL_8 = VersionUtils.getLocation("via_romana:textures/screens/tutorial_8.png");

        private Textures() {
        }
    }

    private static final class Sounds {
        static final class_2960 SEVER_PATH = VersionUtils.getLocation("minecraft:entity.sheep.shear");
        static final class_2960 DELETE_BRANCH_PROMPT = VersionUtils.getLocation("minecraft:item.flintandsteel.use");
        static final class_2960 DELETE_BRANCH_CONFIRM = VersionUtils.getLocation("minecraft:block.fire.ambient");
        static final class_2960 DELETE_BRANCH_CANCEL = VersionUtils.getLocation("minecraft:block.fire.extinguish");
        static final class_2960 START_CHARTING = VersionUtils.getLocation("minecraft:item.book.page_turn");

        private Sounds() {
        }
    }
}

