/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.client.gui.MapRenderer;
import net.rasanovum.viaromana.init.StatInit;
import net.rasanovum.viaromana.map.ServerMapCache;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.level.LevelDataManager;
import net.rasanovum.viaromana.storage.path.PathDataManager;
import net.rasanovum.viaromana.storage.path.legacy.IPathStorage;
import net.rasanovum.viaromana.storage.player.PlayerData;
import net.rasanovum.viaromana.util.PathSyncUtils;

public class ViaRomanaCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"viaromana").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"nodes").then(class_2170.method_9247((String)"clear").executes(ViaRomanaCommands::clearAllNodes)))).then(class_2170.method_9247((String)"client").then(class_2170.method_9247((String)"clear").executes(ViaRomanaCommands::clearCache)))).then(class_2170.method_9247((String)"convert").then(class_2170.method_9247((String)"legacyPaths").executes(ViaRomanaCommands::convertLegacyPaths)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"maps").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").then(class_2170.method_9247((String)"all").executes(ViaRomanaCommands::clearMaps))).then(class_2170.method_9247((String)"biomePixels").executes(ViaRomanaCommands::clearBiomePixels))).then(class_2170.method_9247((String)"chunkPixels").executes(ViaRomanaCommands::clearChunkPixels)))).then(class_2170.method_9247((String)"regenerate").executes(ViaRomanaCommands::regenerateMaps))).then(class_2170.method_9247((String)"delete").executes(ViaRomanaCommands::deleteMaps))).then(class_2170.method_9247((String)"save").executes(ViaRomanaCommands::saveMaps)))).then(class_2170.method_9247((String)"sync").executes(ViaRomanaCommands::syncDimension))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"stats").then(class_2170.method_9247((String)"get").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9247((String)"distance_charted").executes(ctx -> ViaRomanaCommands.getStat((CommandContext<class_2168>)ctx, "distance_charted")))).then(class_2170.method_9247((String)"distance_walked").executes(ctx -> ViaRomanaCommands.getStat((CommandContext<class_2168>)ctx, "distance_walked")))))).then(class_2170.method_9247((String)"set").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9247((String)"distance_charted").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> ViaRomanaCommands.setStat((CommandContext<class_2168>)ctx, "distance_charted"))))).then(class_2170.method_9247((String)"distance_walked").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> ViaRomanaCommands.setStat((CommandContext<class_2168>)ctx, "distance_walked"))))))));
    }

    private static int clearAllNodes(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        for (class_1657 player : source.method_9225().method_18456()) {
            PlayerData.setChartingPath(player, false);
        }
        PathGraph graph = PathGraph.getInstance(source.method_9225());
        int nodeCount = graph.size();
        graph.removeAllNodes();
        ClientPathData.getInstance().clearData();
        PathSyncUtils.syncPathGraphToAllPlayers(source.method_9225());
        PathDataManager.markDirty(source.method_9225());
        source.method_9226(() -> class_2561.method_43471((String)"command.via_romana.nodes_cleared"), true);
        return nodeCount;
    }

    private static int clearCache(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        if (source.method_9225().method_8608()) {
            ClientPathData.getInstance().clearData();
        }
        PathSyncUtils.syncPathGraphToPlayer(source.method_9207());
        source.method_9226(() -> class_2561.method_43471((String)"command.via_romana.cache_cleared"), true);
        return 1;
    }

    private static int convertLegacyPaths(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3218 currentLevel = source.method_9225();
        PathGraph legacyGraph = IPathStorage.get((class_1937)currentLevel).graph();
        int legacyNodeCount = legacyGraph.size();
        if (legacyNodeCount == 0) {
            source.method_9213((class_2561)class_2561.method_43471((String)"command.via_romana.no_legacy_paths"));
            return 0;
        }
        PathGraph currentGraph = PathDataManager.getOrCreatePathGraph(currentLevel);
        if (currentGraph.size() > 0) {
            source.method_9213((class_2561)class_2561.method_43471((String)"command.via_romana.dimension_has_nodes"));
            return 0;
        }
        class_2487 serializedData = legacyGraph.serialize(new class_2487());
        if (serializedData.method_10545("nodes")) {
            class_2499 nodeList = serializedData.method_10554("nodes", 10);
            for (int i = 0; i < nodeList.size(); ++i) {
                class_2487 nodeTag = nodeList.method_10602(i);
                nodeTag.method_10548("clearance", 0.0f);
            }
        }
        currentGraph.deserialize(serializedData);
        PathDataManager.markDirty(currentLevel);
        PathSyncUtils.syncPathGraphToAllPlayers(currentLevel);
        source.method_9226(() -> class_2561.method_43471((String)"command.via_romana.legacy_converted"), true);
        return legacyNodeCount;
    }

    private static int clearMaps(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43471((String)"command.via_romana.clearing_chunk_data"), false);
        LevelDataManager.clearAllPixelBytes(source.method_9225());
        LevelDataManager.clearAllCornerBytes(source.method_9225());
        ServerMapCache.clear();
        ServerMapCache.deleteAllMapsFromDisk();
        if (source.method_9225().method_8608()) {
            MapRenderer.clearCache();
        }
        source.method_9226(() -> class_2561.method_43471((String)"command.via_romana.maps_and_chunks_cleared"), true);
        return 1;
    }

    private static int clearBiomePixels(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43471((String)"command.via_romana.clearing_biome_data"), false);
        LevelDataManager.clearAllCornerBytes(source.method_9225());
        ServerMapCache.clear();
        ServerMapCache.deleteAllMapsFromDisk();
        if (source.method_9225().method_8608()) {
            MapRenderer.clearCache();
        }
        source.method_9226(() -> class_2561.method_43471((String)"command.via_romana.maps_and_biomes_cleared"), true);
        return 1;
    }

    private static int clearChunkPixels(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43471((String)"command.via_romana.clearing_chunk_pixels"), false);
        LevelDataManager.clearAllPixelBytes(source.method_9225());
        ServerMapCache.clear();
        ServerMapCache.deleteAllMapsFromDisk();
        if (source.method_9225().method_8608()) {
            MapRenderer.clearCache();
        }
        source.method_9226(() -> class_2561.method_43471((String)"command.via_romana.maps_and_chunks_cleared"), true);
        return 1;
    }

    private static int regenerateMaps(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43471((String)"command.via_romana.regenerating_chunks"), false);
        ServerMapCache.regenerateAllChunkPixelData();
        ServerMapCache.processAllDirtyNetworks(true);
        source.method_9226(() -> class_2561.method_43471((String)"command.via_romana.maps_regenerated"), true);
        return 1;
    }

    private static int deleteMaps(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        ServerMapCache.clear();
        ServerMapCache.deleteAllMapsFromDisk();
        if (source.method_9225().method_8608()) {
            MapRenderer.clearCache();
        }
        source.method_9226(() -> class_2561.method_43471((String)"command.via_romana.maps_cleared"), true);
        return 1;
    }

    private static int saveMaps(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        ServerMapCache.saveAllToDisk(true);
        source.method_9226(() -> class_2561.method_43471((String)"command.via_romana.maps_saved"), true);
        return 1;
    }

    private static int syncDimension(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3218 level = source.method_9225();
        PathSyncUtils.syncPathGraphToAllPlayers(level);
        source.method_9226(() -> class_2561.method_43471((String)"command.via_romana.sync_triggered"), true);
        return 1;
    }

    private static int getStat(CommandContext<class_2168> context, String statType) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = class_2186.method_9315(context, (String)"player");
        class_3445<class_2960> stat = ViaRomanaCommands.getStatFromType(statType);
        int value = player.method_14248().method_15025(class_3468.field_15419.method_14956((Object)((class_2960)stat.method_14951())));
        String formattedDistance = ViaRomanaCommands.formatDistance(value);
        source.method_9226(() -> class_2561.method_43470((String)String.format("%s's %s: %s", player.method_5477().getString(), statType.replace("_", " "), formattedDistance)), false);
        return value;
    }

    private static int setStat(CommandContext<class_2168> context, String statType) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = class_2186.method_9315(context, (String)"player");
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        class_3445<class_2960> stat = ViaRomanaCommands.getStatFromType(statType);
        int currentValue = player.method_14248().method_15025(class_3468.field_15419.method_14956((Object)((class_2960)stat.method_14951())));
        player.method_7266(class_3468.field_15419.method_14956((Object)((class_2960)stat.method_14951())));
        player.method_7342(class_3468.field_15419.method_14956((Object)((class_2960)stat.method_14951())), value);
        String formattedDistance = ViaRomanaCommands.formatDistance(value);
        source.method_9226(() -> class_2561.method_43470((String)String.format("Set %s's %s to %s", player.method_5477().getString(), statType.replace("_", " "), formattedDistance)), true);
        return value;
    }

    private static class_3445<class_2960> getStatFromType(String statType) {
        return switch (statType) {
            case "distance_charted" -> class_3468.field_15419.method_14956((Object)StatInit.DISTANCE_CHARTED);
            case "distance_walked" -> class_3468.field_15419.method_14956((Object)StatInit.DISTANCE_WALKED);
            default -> throw new IllegalArgumentException("Unknown stat type: " + statType);
        };
    }

    private static String formatDistance(int centimeters) {
        double meters = (double)centimeters / 100.0;
        if (meters > 1000.0) {
            double kilometers = meters / 1000.0;
            return String.format("%.2f km", kilometers);
        }
        return String.format("%.2f m", meters);
    }
}

